/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramParameter;
import io.debezium.ibmi.db2.journal.retrieve.FileFilter;
import io.debezium.ibmi.db2.journal.retrieve.PositionRange;
import io.debezium.ibmi.db2.journal.retrieve.RetrievalCriteria;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterListBuilder {
    private static final Logger log = LoggerFactory.getLogger(ParameterListBuilder.class);
    public static final int DEFAULT_JOURNAL_BUFFER_SIZE = 131072;
    public static final int ERROR_CODE = 0;
    private static final byte[] errorCodeData = new AS400Bin4().toBytes(0);
    public static final String FORMAT_NAME = "RJNE0200";
    private static final byte[] formatNameData = new AS400Text(8).toBytes((Object)"RJNE0200");
    private int bufferLength = 131072;
    private byte[] bufferLengthData = new AS400Bin4().toBytes(this.bufferLength);
    private String receiver = "";
    private String receiverLibrary = "";
    private final RetrievalCriteria criteria = new RetrievalCriteria();
    private byte[] journalData;
    private String startReceiver;
    private String startLibrary;
    private String endReceiver;
    private String endLibrary;
    private List<FileFilter> tableFilters;
    private String startOffset;
    private String endOffset;
    private RetrievalCriteria.JournalEntryType[] journalEntryTypes;
    private RetrievalCriteria.JournalCode[] journalCode;

    public ParameterListBuilder() {
        this.criteria.withLenNullPointerIndicatorVarLength();
    }

    public ParameterListBuilder withBufferLenth(int bufferLength) {
        this.bufferLength = bufferLength;
        this.bufferLengthData = new AS400Bin4().toBytes(bufferLength);
        return this;
    }

    public ParameterListBuilder withRange(PositionRange range) {
        if (range.fromBeginning()) {
            log.warn("starting from beginning");
            this.withFromBeginningToEnd();
        } else {
            this.withReceivers(range);
        }
        return this;
    }

    public ParameterListBuilder withJournal(String receiver, String receiverLibrary) {
        if (!this.receiver.equals(receiver) && !this.receiverLibrary.equals(receiverLibrary)) {
            this.receiver = receiver;
            this.receiverLibrary = receiverLibrary;
            String jrnLib = StringHelpers.padRight(receiver, 10) + StringHelpers.padRight(receiverLibrary, 10);
            this.journalData = new AS400Text(20).toBytes((Object)jrnLib);
        }
        return this;
    }

    public void init() {
        this.criteria.reset();
    }

    public ParameterListBuilder withJournalEntryType(RetrievalCriteria.JournalEntryType type) {
        this.criteria.withEntTyp(new RetrievalCriteria.JournalEntryType[]{type});
        return this;
    }

    public ParameterListBuilder withReceivers(PositionRange range) {
        this.startReceiver = range.start().getReceiver().name();
        this.startLibrary = range.start().getReceiver().library();
        this.withStartingSequence(range.start().getOffset());
        this.endReceiver = range.end().getReceiver().name();
        this.endLibrary = range.end().receiver().library();
        this.withEnd(range.end().getOffset());
        this.criteria.withReceiverRange(this.startReceiver, this.startLibrary, this.endReceiver, this.endLibrary);
        return this;
    }

    private ParameterListBuilder withStartingSequence(BigInteger start) {
        this.startOffset = start.toString();
        this.criteria.withFromEnt(start);
        return this;
    }

    private ParameterListBuilder withEnd() {
        this.endOffset = "*LAST";
        this.criteria.withEnd();
        return this;
    }

    private ParameterListBuilder withEnd(BigInteger end) {
        this.endOffset = end.toString();
        this.criteria.withEnd(end);
        return this;
    }

    public ParameterListBuilder withStartReceiversToCurrentEnd(BigInteger start, String startReceiver, String startLibrary) {
        this.withStartingSequence(start);
        this.startReceiver = startReceiver;
        this.startLibrary = startLibrary;
        this.endReceiver = "*CURRENT";
        this.endLibrary = "";
        this.criteria.withReceiverRange(startReceiver, startLibrary, this.endReceiver, this.endLibrary);
        this.withEnd();
        return this;
    }

    public ParameterListBuilder withFromBeginningToEnd() {
        this.startReceiver = "*CURCHAIN";
        this.startLibrary = "";
        this.endReceiver = "";
        this.endLibrary = "";
        this.criteria.withReceiverRange(this.startReceiver, this.startLibrary, this.endReceiver, this.endLibrary);
        this.startOffset = "*FIRST";
        this.criteria.withStart();
        this.withEnd();
        return this;
    }

    public ParameterListBuilder filterJournalCodes(RetrievalCriteria.JournalCode[] journalCode) {
        this.journalCode = journalCode;
        this.criteria.withJrnCde(journalCode);
        return this;
    }

    public ParameterListBuilder withFileFilters(List<FileFilter> tableFilters) {
        this.tableFilters = tableFilters;
        this.criteria.withFILE(tableFilters);
        return this;
    }

    public ParameterListBuilder filterJournalEntryType(RetrievalCriteria.JournalEntryType[] journalEntryTypes) {
        this.journalEntryTypes = journalEntryTypes;
        this.criteria.withEntTyp(journalEntryTypes);
        return this;
    }

    public ProgramParameter[] build() {
        byte[] criteriaData = new AS400Structure(this.criteria.getStructure()).toBytes((Object)this.criteria.getObject());
        return new ProgramParameter[]{new ProgramParameter(2, this.bufferLength), new ProgramParameter(2, this.bufferLengthData), new ProgramParameter(2, this.journalData), new ProgramParameter(2, formatNameData), new ProgramParameter(2, criteriaData), new ProgramParameter(2, errorCodeData)};
    }

    public String toString() {
        return String.format("ParameterListBuilder [receiver=%s, receiverLibrary=%s, startReceiver=%s, startLibrary=%s, endReceiver=%s, endLibrary=%s, startOffset=%s, endOffset=%s, journalEntryTypes=%s, journalCode=%s, tableFilters=%s]", this.receiver, this.receiverLibrary, this.startReceiver, this.startLibrary, this.endReceiver, this.endLibrary, this.startOffset, this.endOffset, Arrays.toString((Object[])this.journalEntryTypes), Arrays.toString((Object[])this.journalCode), this.filtersToShortString(this.tableFilters));
    }

    public String filtersToShortString(List<FileFilter> tableFilters) {
        if (tableFilters == null) {
            return "null";
        }
        return tableFilters.stream().map(FileFilter::toShortString).collect(Collectors.joining("-", "{", "}"));
    }
}

