/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.FileAttributes;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import io.debezium.ibmi.db2.journal.retrieve.DetailedJournalReceiverCache;
import io.debezium.ibmi.db2.journal.retrieve.FileFilter;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfo;
import io.debezium.ibmi.db2.journal.retrieve.JournalPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalReceiverInfo;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.KeyDecoder;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.KeyHeader;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.ReceiverDecoder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalInfoRetrieval {
    private static final Logger log = LoggerFactory.getLogger(JournalInfoRetrieval.class);
    public static final String JOURNAL_SERVICE_LIB = "/QSYS.LIB/QJOURNAL.SRVPGM";
    private static final byte[] EMPTY_AS400_TEXT = new AS400Text(0).toBytes((Object)"");
    private final AS400Text as400Text8 = new AS400Text(8);
    private final AS400Text as400Text20 = new AS400Text(20);
    private final AS400Text as400Text1 = new AS400Text(1);
    private final AS400Text as400Text10 = new AS400Text(10);
    private final AS400Bin8 as400Bin8 = new AS400Bin8();
    private final AS400Bin4 as400Bin4 = new AS400Bin4();
    private static final int KEY_HEADER_LENGTH = 20;
    private final DetailedJournalReceiverCache cache = new DetailedJournalReceiverCache();
    static final Pattern JOURNAL_REGEX = Pattern.compile("\\/[^/]*\\/([^.]*).LIB\\/(.*).JRN");

    public JournalPosition getCurrentPosition(AS400 as400, JournalInfo journalLib) throws Exception {
        JournalReceiver ji = this.getReceiver(as400, journalLib);
        BigInteger offset = this.getOffset(as400, ji).end();
        return new JournalPosition(offset, ji);
    }

    public DetailedJournalReceiver getCurrentDetailedJournalReceiver(AS400 as400, JournalInfo journalLib) throws Exception {
        JournalReceiver ji = this.getReceiver(as400, journalLib);
        return this.getOffset(as400, ji);
    }

    @Deprecated
    public static JournalInfo getJournal(AS400 as400, String schema) throws IllegalStateException {
        try {
            FileAttributes fa = new FileAttributes(as400, String.format("/QSYS.LIB/%s.LIB", schema));
            Matcher m = JOURNAL_REGEX.matcher(fa.getJournal());
            if (m.matches()) {
                return new JournalInfo(m.group(2), m.group(1));
            }
            log.error("no match searching for journal filename {}", (Object)fa.getJournal());
        }
        catch (Exception e) {
            throw new IllegalStateException("Journal not found", e);
        }
        throw new IllegalStateException("Journal not found");
    }

    public JournalInfo getJournal(AS400 as400, String schema, List<FileFilter> includes) throws IllegalStateException {
        if (includes.isEmpty()) {
            return JournalInfoRetrieval.getJournal(as400, schema);
        }
        try {
            HashSet<JournalInfo> jis = new HashSet<JournalInfo>();
            for (FileFilter f : includes) {
                if (!schema.equals(f.schema())) {
                    throw new IllegalArgumentException(String.format("schema %s does not match for filter: %s", schema, f));
                }
                JournalInfo ji = this.getJournal(as400, f.schema(), f.table());
                jis.add(ji);
            }
            if (jis.size() > 1) {
                throw new IllegalArgumentException(String.format("more than one journal for the set of tables journals: %s", jis));
            }
            return (JournalInfo)jis.iterator().next();
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to retrieve journal details", e);
        }
    }

    public JournalInfo getJournal(AS400 as400, String schema, String table) throws Exception {
        int rcvLen = 32768;
        String filename = JournalInfoRetrieval.padRight(table.toUpperCase(), 10) + JournalInfoRetrieval.padRight(schema.toUpperCase(), 10);
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, 32768), new ProgramParameter(2, this.as400Bin4.toBytes(32768)), new ProgramParameter(2, 20), new ProgramParameter(2, this.as400Text8.toBytes((Object)"FILD0100")), new ProgramParameter(2, this.as400Text20.toBytes((Object)filename)), new ProgramParameter(2, this.as400Text10.toBytes((Object)"*FIRST")), new ProgramParameter(2, this.as400Text1.toBytes((Object)"0")), new ProgramParameter(2, this.as400Text10.toBytes((Object)"*LCL")), new ProgramParameter(2, this.as400Text10.toBytes((Object)"*INT")), new ProgramParameter(2, this.as400Bin4.toBytes(0))};
        ProgramCall pc = new ProgramCall();
        pc.setSystem(as400);
        QSYSObjectPathName programName = new QSYSObjectPathName("QSYS", "QDBRTVFD", "PGM");
        pc.setProgram(programName.getPath(), parameters);
        boolean success = pc.run();
        if (success) {
            byte[] data = parameters[0].getOutputData();
            int offsetJournalHeader = this.decodeInt(data, 378);
            int offsetJournalOrn = this.decodeInt(data, offsetJournalHeader + 378);
            String journalName = JournalInfoRetrieval.decodeString(data, offsetJournalOrn += offsetJournalHeader, 10);
            String journalLib = JournalInfoRetrieval.decodeString(data, offsetJournalOrn + 10, 10);
            return new JournalInfo(journalName, journalLib);
        }
        String msg = Arrays.asList(pc.getMessageList()).stream().map(AS400Message::getText).reduce("", (a, s) -> a + s);
        throw new IllegalStateException(String.format("Journal not found for %s.%s error %s", schema, table, msg));
    }

    public JournalReceiver getReceiver(AS400 as400, JournalInfo journalLib) throws Exception {
        int rcvLen = 4096;
        String jrnLib = JournalInfoRetrieval.padRight(journalLib.journalName(), 10) + JournalInfoRetrieval.padRight(journalLib.journalLibrary(), 10);
        String format = "RJRN0200";
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, 4096), new ProgramParameter(2, this.as400Bin4.toBytes(1)), new ProgramParameter(2, this.as400Text20.toBytes((Object)jrnLib)), new ProgramParameter(2, this.as400Text8.toBytes((Object)"RJRN0200")), new ProgramParameter(2, EMPTY_AS400_TEXT), new ProgramParameter(2, this.as400Bin4.toBytes(0))};
        return JournalInfoRetrieval.callServiceProgram(as400, JOURNAL_SERVICE_LIB, "QjoRetrieveJournalInformation", parameters, data -> {
            String journalReceiver = JournalInfoRetrieval.decodeString(data, 200, 10);
            String journalLibrary = JournalInfoRetrieval.decodeString(data, 210, 10);
            return new JournalReceiver(journalReceiver, journalLibrary);
        });
    }

    private byte[] getReceiversForJournal(AS400 as400, JournalInfo journalLib, int bufSize) throws Exception {
        String jrnLib = JournalInfoRetrieval.padRight(journalLib.journalName(), 10) + JournalInfoRetrieval.padRight(journalLib.journalLibrary(), 10);
        String format = "RJRN0200";
        JournalRetrievalCriteria criteria = new JournalRetrievalCriteria();
        byte[] toRetrieve = new AS400Structure(criteria.getStructure()).toBytes((Object)criteria.getObject());
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, bufSize), new ProgramParameter(2, this.as400Bin4.toBytes(bufSize / 4096)), new ProgramParameter(2, this.as400Text20.toBytes((Object)jrnLib)), new ProgramParameter(2, this.as400Text8.toBytes((Object)"RJRN0200")), new ProgramParameter(2, toRetrieve), new ProgramParameter(2, this.as400Bin4.toBytes(0))};
        return JournalInfoRetrieval.callServiceProgram(as400, JOURNAL_SERVICE_LIB, "QjoRetrieveJournalInformation", parameters, data -> data);
    }

    public List<DetailedJournalReceiver> getReceivers(AS400 as400, JournalInfo journalLib) throws Exception {
        int defaultSize = 32768;
        byte[] data = this.getReceiversForJournal(as400, journalLib, 32768);
        int actualSizeRequired = this.decodeInt(data, 4) * 4096;
        if (actualSizeRequired > 32768) {
            data = this.getReceiversForJournal(as400, journalLib, actualSizeRequired + 4096);
        }
        Integer keyOffset = this.decodeInt(data, 8) + 4;
        Integer totalKeys = this.decodeInt(data, keyOffset);
        KeyDecoder keyDecoder = new KeyDecoder();
        ArrayList<DetailedJournalReceiver> l = new ArrayList<DetailedJournalReceiver>();
        for (int k = 0; k < totalKeys; ++k) {
            KeyHeader kheader = keyDecoder.decode(data, keyOffset + k * 20);
            if (kheader.getKey() != 1) continue;
            ReceiverDecoder dec = new ReceiverDecoder();
            for (int i = 0; i < kheader.getNumberOfEntries(); ++i) {
                int kioffset = keyOffset + kheader.getOffset() + kheader.getLengthOfHeader() + i * kheader.getLengthOfKeyInfo();
                JournalReceiverInfo r = dec.decode(data, kioffset);
                DetailedJournalReceiver details = this.getReceiverDetails(as400, r);
                l.add(details);
            }
        }
        this.cache.keepOnly(l);
        return DetailedJournalReceiver.lastJoined(l);
    }

    DetailedJournalReceiver getOffset(AS400 as400, JournalReceiver receiver) throws Exception {
        return this.getReceiverDetails(as400, new JournalReceiverInfo(receiver, null, null, Optional.empty()));
    }

    private DetailedJournalReceiver getReceiverDetails(AS400 as400, JournalReceiverInfo receiverInfo) throws Exception {
        DetailedJournalReceiver r;
        int rcvLen = 32768;
        String receiverNameLib = JournalInfoRetrieval.padRight(receiverInfo.receiver().name(), 10) + JournalInfoRetrieval.padRight(receiverInfo.receiver().library(), 10);
        if (this.cache.containsKey(receiverInfo) && !(r = this.cache.getUpdatingStatus(receiverInfo)).isAttached()) {
            return r;
        }
        String format = "RRCV0100";
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, 32768), new ProgramParameter(2, this.as400Bin4.toBytes(32768)), new ProgramParameter(2, this.as400Text20.toBytes((Object)receiverNameLib)), new ProgramParameter(2, this.as400Text8.toBytes((Object)"RRCV0100")), new ProgramParameter(2, this.as400Bin4.toBytes(0))};
        return JournalInfoRetrieval.callServiceProgram(as400, JOURNAL_SERVICE_LIB, "QjoRtvJrnReceiverInformation", parameters, data -> {
            String journalName = JournalInfoRetrieval.decodeString(data, 8, 10);
            String attachTimeStr = JournalInfoRetrieval.decodeString(data, 95, 13);
            String nextReceiverName = JournalInfoRetrieval.decodeString(data, 332, 10);
            String nextReceiverLib = JournalInfoRetrieval.decodeString(data, 342, 10);
            nextReceiverLib = nextReceiverLib == null ? receiverInfo.receiver().library() : nextReceiverLib;
            Long numberOfEntries = Long.valueOf(JournalInfoRetrieval.decodeString(data, 372, 20));
            Long maxEntryLength = Long.valueOf(JournalInfoRetrieval.decodeString(data, 392, 20));
            BigInteger firstSequence = this.decodeBigIntFromString(data, 412);
            BigInteger lastSequence = this.decodeBigIntFromString(data, 432);
            JournalStatus status = JournalStatus.valueOfString(JournalInfoRetrieval.decodeString(data, 88, 1));
            if (!journalName.equals(receiverInfo.receiver().name())) {
                String msg = String.format("journal names don't match requested %s got %s", receiverInfo.receiver().name(), journalName);
                throw new Exception(msg);
            }
            Date attachTime = ReceiverDecoder.toDate(attachTimeStr);
            JournalReceiverInfo updatedInfo = new JournalReceiverInfo(receiverInfo.receiver(), attachTime, status, receiverInfo.chain());
            Optional<JournalReceiver> nextReceiver = nextReceiverName == null ? Optional.empty() : Optional.of(new JournalReceiver(nextReceiverName, nextReceiverLib));
            DetailedJournalReceiver dr = new DetailedJournalReceiver(updatedInfo, firstSequence, lastSequence, nextReceiver, maxEntryLength, numberOfEntries);
            this.cache.put(dr);
            return dr;
        });
    }

    public static <T> T callServiceProgramParams(AS400 as400, String programLibrary, String program, ProgramParameter[] parameters, ProcessDataAllParamaterData<T> processor) throws Exception {
        ServiceProgramCall spc = new ServiceProgramCall(as400);
        spc.getServerJob().setLoggingLevel(0);
        spc.setProgram(programLibrary, parameters);
        spc.setProcedureName(program);
        spc.setAlignOn16Bytes(true);
        spc.setReturnValueFormat(1);
        boolean success = spc.run();
        if (success) {
            return processor.process(parameters);
        }
        String msg = Arrays.asList(spc.getMessageList()).stream().map(AS400Message::getText).reduce("", (a, s) -> a + s);
        log.error(String.format("service program %s/%s call failed %s", programLibrary, program, msg));
        throw new Exception(msg);
    }

    public static <T> T callServiceProgram(AS400 as400, String programLibrary, String program, ProgramParameter[] parameters, ProcessFirstParamaterData<T> processor) throws Exception {
        return (T)JournalInfoRetrieval.callServiceProgramParams(as400, programLibrary, program, parameters, p -> processor.process(p[0].getOutputData()));
    }

    public Integer decodeInt(byte[] data, int offset) {
        byte[] b = Arrays.copyOfRange(data, offset, offset + 4);
        return this.as400Bin4.toInt(b);
    }

    public Long decodeLong(byte[] data, int offset) {
        byte[] b = Arrays.copyOfRange(data, offset, offset + 8);
        return this.as400Bin8.toLong(b);
    }

    public static String decodeString(byte[] data, int offset, int length) {
        byte[] b = Arrays.copyOfRange(data, offset, offset + length);
        return StringHelpers.safeTrim((String)new AS400Text(length).toObject(b));
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public BigInteger decodeBigIntFromString(byte[] data, int offset) {
        byte[] b = Arrays.copyOfRange(data, offset, offset + 20);
        String s = (String)this.as400Text20.toObject(b);
        return new BigInteger(s);
    }

    public static interface ProcessFirstParamaterData<T> {
        public T process(byte[] var1) throws Exception;
    }

    public static class JournalRetrievalCriteria {
        private static final Integer ZERO_INT = 0;
        private static final Integer TWELVE_INT = 12;
        private static final Integer ONE_INT = 1;
        private final ArrayList<AS400DataType> structure = new ArrayList();
        private final ArrayList<Object> data = new ArrayList();

        public JournalRetrievalCriteria() {
            this.structure.add((AS400DataType)new AS400Bin4());
            this.structure.add((AS400DataType)new AS400Bin4());
            this.structure.add((AS400DataType)new AS400Bin4());
            this.structure.add((AS400DataType)new AS400Bin4());
            this.structure.add((AS400DataType)new AS400Text(1));
            this.data.add(ONE_INT);
            this.data.add(TWELVE_INT);
            this.data.add(ONE_INT);
            this.data.add(ZERO_INT);
            this.data.add("");
        }

        public AS400DataType[] getStructure() {
            return this.structure.toArray(new AS400DataType[this.structure.size()]);
        }

        public Object[] getObject() {
            return this.data.toArray(new Object[0]);
        }
    }

    public static interface ProcessDataAllParamaterData<T> {
        public T process(ProgramParameter[] var1) throws Exception;
    }
}

