/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalReceiverInfo;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedJournalReceiverCache {
    private Map<String, DetailedJournalReceiver> cached = new HashMap<String, DetailedJournalReceiver>();
    private static final Logger log = LoggerFactory.getLogger(DetailedJournalReceiverCache.class);

    public boolean containsKey(JournalReceiverInfo receiverInfo) {
        String key = this.toKey(receiverInfo);
        return this.cached.containsKey(key);
    }

    public DetailedJournalReceiver getUpdatingStatus(JournalReceiverInfo receiverInfo) {
        String key = this.toKey(receiverInfo);
        DetailedJournalReceiver dr = this.cached.get(key);
        if (dr.info() == null || dr.info().status() == null) {
            log.warn("null in receiver info", (Object)dr);
        }
        if (receiverInfo.status() != null && dr.info() != null && !receiverInfo.status().equals((Object)dr.info().status())) {
            dr = dr.withStatus(receiverInfo.status());
            this.cached.put(key, dr);
        }
        return dr;
    }

    public void put(DetailedJournalReceiver details) {
        if (details.info().status() == null || details.info().attachTime() == null) {
            log.debug("not caching {} ", (Object)details);
        }
        if (details.info().status() == null || details.info().attachTime() == null || JournalStatus.Attached.equals((Object)details.info().status())) {
            return;
        }
        this.cached.put(this.toKey(details.info()), details);
    }

    public void keepOnly(List<DetailedJournalReceiver> list) {
        HashSet<String> toGo = new HashSet<String>(this.cached.keySet());
        Set keep = list.stream().map(this::toKey).collect(Collectors.toSet());
        toGo.removeAll(keep);
        toGo.stream().forEach(x -> this.cached.remove(x));
    }

    private String toKey(JournalReceiverInfo receiverInfo) {
        String key = String.format("%s:%s", receiverInfo.receiver().name(), receiverInfo.receiver().library());
        return key;
    }

    private String toKey(DetailedJournalReceiver receiverInfo) {
        String key = String.format("%s:%s", receiverInfo.info().receiver().name(), receiverInfo.info().receiver().library());
        return key;
    }
}

