/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve.rnrn0200;

import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalReceiverInfo;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.ReceiverChain;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReceiverChainTest {
    DetailedJournalReceiver dr6 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("6", "lib"), new Date(6L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ZERO, BigInteger.ONE, Optional.empty(), 1L, 1L);
    DetailedJournalReceiver dr5 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("5", "lib"), new Date(5L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ZERO, BigInteger.ONE, Optional.of(this.dr6.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr4 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("4", "lib"), new Date(4L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.of(this.dr5.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("3", "lib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.of(this.dr4.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("2", "lib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.of(this.dr3.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("1", "lib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.of(this.dr2.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr1Unavailable = this.dr1.withStatus(JournalStatus.Partial);

    ReceiverChainTest() {
    }

    @BeforeEach
    protected void setUp() throws Exception {
    }

    @Test
    void testAvailableSingleChainElement() {
        DetailedJournalReceiver available = this.dr2;
        List<DetailedJournalReceiver> l = Arrays.asList(this.dr1Unavailable, available);
        Map map = ReceiverChain.availableSingleChainElement(l);
        HashMap<JournalReceiver, ReceiverChain> expected = new HashMap<JournalReceiver, ReceiverChain>();
        expected.put(available.info().receiver(), new ReceiverChain(available));
        Assertions.assertEquals(expected, (Object)map);
    }

    @Test
    void testBuildReceiverChains() {
        DetailedJournalReceiver firstAvailable = this.dr2;
        DetailedJournalReceiver secondAvailable = this.dr3;
        List<DetailedJournalReceiver> l = Arrays.asList(this.dr1Unavailable, firstAvailable, secondAvailable);
        Map map = ReceiverChain.availableSingleChainElement(l);
        Assertions.assertEquals((int)2, (int)map.size());
        Set detachedSet = ReceiverChain.buildReceiverChains((Map)map);
        Assertions.assertEquals((int)1, (int)detachedSet.size());
        ReceiverChain chain = (ReceiverChain)detachedSet.iterator().next();
        Assertions.assertEquals((Object)firstAvailable, (Object)chain.details, (String)"first avaiable");
        Assertions.assertEquals((Object)secondAvailable, (Object)((ReceiverChain)chain.next.get()).details, (String)"second availabe");
        Assertions.assertEquals(Optional.empty(), (Object)((ReceiverChain)chain.next.get()).next, (String)"end of list");
    }

    @Test
    void testFindCurrentChain() {
        List<DetailedJournalReceiver> l = Arrays.asList(this.dr1.withStatus(JournalStatus.Partial), this.dr2, this.dr3);
        Map map = ReceiverChain.availableSingleChainElement(l);
        Assertions.assertEquals((int)2, (int)map.size());
        Set detachedSet = ReceiverChain.buildReceiverChains((Map)map);
        Assertions.assertEquals((int)1, (int)detachedSet.size());
        Optional chainOpt = ReceiverChain.findChain((Map)map, (DetailedJournalReceiver)this.dr3);
        Assertions.assertTrue((boolean)chainOpt.isPresent(), (String)"chain found");
        ReceiverChain chain = (ReceiverChain)chainOpt.get();
        Assertions.assertEquals((Object)this.dr2, (Object)chain.details, (String)"first avaiable");
        Assertions.assertEquals((Object)this.dr3, (Object)((ReceiverChain)chain.next.get()).details, (String)"second availabe");
        Assertions.assertEquals(Optional.empty(), (Object)((ReceiverChain)chain.next.get()).next, (String)"end of list");
    }

    @Test
    void testFindCurrentChainWithDetachedChains() {
        List<DetailedJournalReceiver> l = Arrays.asList(this.dr1, this.dr2, this.dr3, new DetailedJournalReceiver(this.dr4.info(), this.dr4.start(), this.dr4.end(), Optional.empty(), this.dr4.maxEntryLength(), this.dr4.numberOfEntries()), this.dr5, this.dr6);
        Map map = ReceiverChain.availableSingleChainElement(l);
        Assertions.assertEquals((int)6, (int)map.size());
        Set detachedSet = ReceiverChain.buildReceiverChains((Map)map);
        Assertions.assertEquals((int)2, (int)detachedSet.size());
        Optional chainOpt = ReceiverChain.findChain((Map)map, (DetailedJournalReceiver)this.dr6);
        Assertions.assertTrue((boolean)chainOpt.isPresent(), (String)"chain found");
        ReceiverChain chain = (ReceiverChain)chainOpt.get();
        Assertions.assertEquals((Object)this.dr5, (Object)chain.details, (String)"first avaiable");
        Assertions.assertEquals((Object)this.dr6, (Object)((ReceiverChain)chain.next.get()).details, (String)"second availabe");
        Assertions.assertEquals(Optional.empty(), (Object)((ReceiverChain)chain.next.get()).next, (String)"end of list");
    }
}

