/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveJournal;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.EntryHeader;
import java.math.BigInteger;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RetrieveJournalTest {
    RetrieveJournalTest() {
    }

    private JournalProcessedPosition firstPosition() {
        JournalProcessedPosition positionMatches = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("receiver", "receiverLibrary"), Instant.ofEpochMilli(1L), true);
        return positionMatches;
    }

    @Test
    public void testAlreadyProcessedOffsetSequenceReceiverAndReceiverLibrary() {
        JournalProcessedPosition positionMatches = this.firstPosition();
        EntryHeader entryHeader = new EntryHeader(-1, -1, -1L, positionMatches.getOffset(), BigInteger.TWO, Instant.ofEpochMilli(2L), 'Z', "UB", "OBJECT", BigInteger.TEN, -1, -1L, positionMatches.getReceiver().name(), positionMatches.getReceiver().library());
        Assertions.assertTrue((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatches, (EntryHeader)entryHeader), (String)"compare sequence number, library and receiver match");
        JournalProcessedPosition positionIncorrectReceiver = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("receiverDoesn'tMatch", "receiverLibrary"), Instant.now(), true);
        Assertions.assertFalse((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionIncorrectReceiver, (EntryHeader)entryHeader), (String)"compare where only receiver name doesn't match");
        JournalProcessedPosition positionIncorrectReceiverLibrary = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("receiver", "receiverLibraryDoesn'tMatch"), Instant.now(), true);
        Assertions.assertFalse((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionIncorrectReceiverLibrary, (EntryHeader)entryHeader), (String)"compare where only receiver name doesn't match");
        JournalProcessedPosition positionIncorrectSequence = new JournalProcessedPosition(BigInteger.TWO, new JournalReceiver("receiver", "receiverLibrary"), Instant.now(), true);
        Assertions.assertFalse((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionIncorrectSequence, (EntryHeader)entryHeader), (String)"compare where only receiver name doesn't match");
    }

    @Test
    public void testAlreadyProcessedOffsetSequenceMissingReceiverAndReceiverLibrary() {
        JournalProcessedPosition positionMatches = this.firstPosition();
        EntryHeader entryHeader = new EntryHeader(-1, -1, -1L, positionMatches.getOffset(), BigInteger.TWO, Instant.ofEpochMilli(2L), 'Z', "UB", "OBJECT", BigInteger.TEN, -1, -1L, positionMatches.getReceiver().name(), positionMatches.getReceiver().library());
        Assertions.assertTrue((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatches, (EntryHeader)entryHeader), (String)"compare only sequence number, library and receiver empty");
        EntryHeader entryHeaderDifferentOffset = new EntryHeader(-1, -1, -1L, positionMatches.getOffset().add(BigInteger.ONE), BigInteger.TWO, Instant.ofEpochMilli(2L), 'Z', "UB", "OBJECT", BigInteger.TEN, -1, -1L, "", "");
        Assertions.assertFalse((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatches, (EntryHeader)entryHeaderDifferentOffset), (String)"compare only sequence number, library and receiver empty");
    }

    @Test
    public void testAlreadyProcessedOffsetNotProcessed() {
        JournalProcessedPosition positionMatches = this.firstPosition();
        JournalProcessedPosition positionMatchesNotProcessed = this.firstPosition().setProcessed(false);
        EntryHeader entryHeader = new EntryHeader(-1, -1, -1L, positionMatchesNotProcessed.getOffset(), BigInteger.TWO, Instant.ofEpochMilli(2L), 'Z', "UB", "OBJECT", BigInteger.TEN, -1, -1L, positionMatchesNotProcessed.getReceiver().name(), positionMatchesNotProcessed.getReceiver().library());
        Assertions.assertTrue((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatches, (EntryHeader)entryHeader), (String)"compare sequence number, library and receiver match");
        Assertions.assertFalse((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatchesNotProcessed, (EntryHeader)entryHeader), (String)"compare sequence number, library and receiver match");
        EntryHeader entryHeaderEmptyReceiver = new EntryHeader(-1, -1, -1L, positionMatchesNotProcessed.getOffset(), BigInteger.TWO, Instant.ofEpochMilli(2L), 'Z', "UB", "OBJECT", BigInteger.TEN, -1, -1L, "", "");
        Assertions.assertTrue((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatches, (EntryHeader)entryHeaderEmptyReceiver), (String)"compare sequence number, library and receiver match");
        Assertions.assertFalse((boolean)RetrieveJournal.alreadyProcessed((JournalProcessedPosition)positionMatchesNotProcessed, (EntryHeader)entryHeaderEmptyReceiver), (String)"compare only sequence number, library and receiver empty");
    }
}

