/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelpers {
    private static Logger log = LoggerFactory.getLogger(StringHelpers.class);

    private StringHelpers() {
    }

    public static String padLeft(String s, int n) {
        if (s.length() > n) {
            log.error("String '{}' longer than padded length {} truncating", new Object[]{s, n, new IllegalArgumentException("Too long")});
        }
        return String.format(String.format("%%1$%ds", n), s).substring(0, n);
    }

    public static String padRight(String s, int n) {
        if (s.length() > n) {
            log.error("String '{}' longer than padded length {} truncating", new Object[]{s, n, new IllegalArgumentException("Too long")});
        }
        return String.format(String.format("%%1$-%ds", n), s).substring(0, n);
    }

    public static String safeTrim(String s) {
        if (s == null) {
            return s;
        }
        return s.trim();
    }
}

