/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import io.debezium.ibmi.db2.journal.retrieve.FileFilter;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrievalCriteria {
    private static final int AS400_TEXT_20_LENGTTH = new AS400Text(20).getByteLength();
    private static final Logger log = LoggerFactory.getLogger(RetrievalCriteria.class);
    private ArrayList<AS400DataType> structure = new ArrayList();
    private ArrayList<Object> data = new ArrayList();

    public AS400DataType[] getStructure() {
        return this.structure.toArray(new AS400DataType[this.structure.size()]);
    }

    public Object[] getObject() {
        return this.data.toArray(new Object[0]);
    }

    public void withReceiverRange(String value) {
        String temp = value.trim();
        if (!(temp.equals("*CURAVLCHN") || temp.equals("*CURCHAIN") || temp.equals("*CURRENT"))) {
            throw new IllegalArgumentException(String.format("value '%s' for 'Range of journal receivers' must be either '*CURAVLCHN' or '*CURCHAIN' or '*CURRENT'", value));
        }
        temp = StringHelpers.padRight(temp, 40);
        this.addStructureData(RetrieveKey.RCVRNG, (AS400DataType)new AS400Text(40), temp);
    }

    public void withReceiverRange(String startReceiver, String startLibrary, String endReceiver, String endLibrary) {
        String padded = String.format("%-10s%-10s%-10s%-10s", startReceiver, startLibrary, endReceiver, endLibrary);
        this.addStructureData(RetrieveKey.RCVRNG, (AS400DataType)new AS400Text(40), padded);
    }

    public void withLenNullPointerIndicatorVarLength() {
        this.addStructureData(RetrieveKey.NULLINDLEN, (AS400DataType)new AS400Text(10), StringHelpers.padRight("*VARLEN", 10));
    }

    public void withNullPointerIndicatorLength(int value) {
        String padded = null;
        if (value % 16 != 0) {
            throw new IllegalArgumentException(String.format("Value %d for 'Null value indicators length' should be divisible by 16", value));
        }
        padded = StringHelpers.padLeft(Integer.toString(value), 10);
        this.addStructureData(RetrieveKey.NULLINDLEN, (AS400DataType)new AS400Text(10), padded);
    }

    public void withFromEnt(FromEnt value) {
        String temp = StringHelpers.padRight(value.getValue(), AS400_TEXT_20_LENGTTH);
        this.addStructureData(RetrieveKey.FROMENT, (AS400DataType)new AS400Text(20), temp);
    }

    public void withFromEnt(BigInteger value) {
        String temp = String.format("%20d", value);
        this.addStructureData(RetrieveKey.FROMENT, (AS400DataType)new AS400Text(20), temp);
    }

    public void withStart() {
        this.addStructureData(RetrieveKey.FROMENT, (AS400DataType)new AS400Text(20), "*FIRST");
    }

    public void withEnd() {
        this.addStructureData(RetrieveKey.TOENT, (AS400DataType)new AS400Text(20), "*LAST");
    }

    public void withEnd(BigInteger value) {
        String temp = String.format("%20d", value);
        this.addStructureData(RetrieveKey.TOENT, (AS400DataType)new AS400Text(20), temp);
    }

    private void withMaxEntriesToReturn(Integer value) {
        this.addStructureData(RetrieveKey.NBRENT, (AS400DataType)new AS400Bin4(), value);
    }

    public void withJrnCde(JournalCode[] value) {
        JournalCode[] range = value;
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < range.length; ++i) {
            code.append(StringHelpers.padRight(range[i].getKey(), 10));
            code.append(StringHelpers.padRight("*ALLSLT", 10));
        }
        this._withJrnCde(range.length, code.toString());
    }

    private void _withJrnCde(int count, String codes) {
        Object[] temp2 = new Object[]{count, codes};
        AS400DataType[] type = new AS400DataType[]{new AS400Bin4(), new AS400Text(codes.length())};
        AS400Structure temp2Structure = new AS400Structure(type);
        this.addStructureData(RetrieveKey.JRNCDE, (AS400DataType)temp2Structure, temp2);
    }

    public void withEntTyp(JournalEntryType[] range) {
        String temp = null;
        int count = 0;
        StringBuilder entry = new StringBuilder();
        for (int i = 0; i < range.length; ++i) {
            entry.append(StringHelpers.padRight(range[i].getKey(), 10));
        }
        temp = entry.toString();
        count = range.length;
        Object[] temp2 = new Object[]{count, temp};
        AS400DataType[] type = new AS400DataType[]{new AS400Bin4(), new AS400Text(temp.length())};
        AS400Structure temp2Structure = new AS400Structure(type);
        this.addStructureData(RetrieveKey.ENTTYP, (AS400DataType)temp2Structure, temp2);
    }

    public void withFILE(List<FileFilter> fileFilters) {
        if (fileFilters == null) {
            return;
        }
        int length = fileFilters.size();
        if (length > 300) {
            log.error("unable to filter for more than 300 files requested length was {}", (Object)length);
            return;
        }
        Object[] fdata = new Object[length * 3 + 1];
        AS400DataType[] types = new AS400DataType[length * 3 + 1];
        fdata[0] = length;
        types[0] = new AS400Bin4();
        int i = 1;
        for (FileFilter f : fileFilters) {
            types[i] = new AS400Text(10);
            fdata[i++] = StringHelpers.padRight(f.table().toUpperCase(), 10);
            types[i] = new AS400Text(10);
            fdata[i++] = StringHelpers.padRight(f.schema().toUpperCase(), 10);
            types[i] = new AS400Text(10);
            fdata[i++] = "*ALL      ";
        }
        AS400Structure asStructure = new AS400Structure(types);
        this.addStructureData(RetrieveKey.FILE, (AS400DataType)asStructure, fdata);
    }

    public void reset() {
        this.structure.clear();
        this.data.clear();
        this.structure.add((AS400DataType)new AS400Bin4());
        this.data.add(0);
    }

    private void addStructureData(RetrieveKey rKey, AS400DataType valueType, Object value) {
        AS400Bin4 totalLengthType = new AS400Bin4();
        AS400Bin4 keyType = new AS400Bin4();
        AS400Bin4 valueLenghtType = new AS400Bin4();
        int totalLengthValue = totalLengthType.getByteLength() + keyType.getByteLength() + valueLenghtType.getByteLength() + valueType.getByteLength();
        Integer key = rKey.getKey();
        Integer valueLength = valueType.getByteLength();
        this.structure.add((AS400DataType)totalLengthType);
        this.structure.add((AS400DataType)keyType);
        this.structure.add((AS400DataType)valueLenghtType);
        this.structure.add(valueType);
        this.data.add(totalLengthValue);
        this.data.add(key);
        this.data.add(valueLength);
        this.data.add(value);
        this.data.set(0, (Integer)this.data.get(0) + 1);
    }

    public static enum RetrieveKey {
        RCVRNG(1, "Range of journal receivers"),
        FROMENT(2, "Starting sequence number"),
        FROMTIME(3, "Starting time stamp"),
        TOENT(4, "Ending sequence number"),
        TOTIME(5, "Ending time stamp"),
        NBRENT(6, "Number of entries"),
        JRNCDE(7, "Journal codes"),
        ENTTYP(8, "Journal entry types"),
        JOB(9, "Job"),
        PGM(10, "Program"),
        USRPRF(11, "User profile"),
        CMTCYCID(12, "Commit cycle identifier"),
        DEPENT(13, "Dependent entries"),
        INCENT(14, "Include entries"),
        NULLINDLEN(15, "Null value indicators length"),
        FILE(16, "File"),
        OBJ(17, "Object"),
        OBJPATH(18, "Object Path"),
        OBJFID(19, "Object file identifier"),
        SUBTREE(20, "Directory substree"),
        PATTERN(21, "Name pattern"),
        FMTMINDTA(22, "Format Minimized Data");

        private int key;
        private String description;

        private RetrieveKey(int key, String description) {
            this.key = key;
            this.description = description;
        }

        public int getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("%s, (%d)", this.getDescription(), this.getKey());
        }
    }

    public static enum FromEnt {
        FIRST("*FIRST"),
        LAST("*LAST");

        private final String value;

        private FromEnt(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum JournalCode {
        A("A", "System accounting entry"),
        B("B", "Integrated file system operation"),
        C("C", "Commitment control operation"),
        D("D", "Database file operation"),
        E("E", "Data area operation"),
        F("F", "Database file member operation"),
        I("I", "Internal operation"),
        J("J", "Journal or journal receiver operation"),
        L("L", "License management"),
        M("M", "Network management data"),
        P("P", "Performance tuning entry"),
        Q("Q", "Data queue operation"),
        R("R", "Record level operation"),
        S("S", "Distributed mail service for SNA distribution services (SNADS), network alerts, or mail server framework"),
        T("T", "Audit trail entry"),
        U("U", "User generated");

        private String key;
        private String description;

        private JournalCode(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("%s, (%s)", this.getDescription(), this.getKey());
        }
    }

    public static enum JournalEntryType {
        BR("BR", "Before-image of record updated for rollback"),
        DL("DL", "Record deleted from physical file member"),
        DR("DR", "Record deleted for rollback"),
        IL("IL", "Increment record limit"),
        PT("PT", "Record added to physical file member"),
        PX("PX", "Record added directly to physical file member"),
        UB("UB", "Before-image of record updated in physical file member"),
        UP("UP", "After-image of record updated in physical file member"),
        UR("UR", "After-image of record updated for rollback"),
        ALL("*ALL", "All entry types"),
        CT("CT", "file created"),
        CG("CG", "file changed"),
        SC("SC", "start commit"),
        CM("CM", "end commit");

        private String key;
        private String description;

        private JournalEntryType(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("%s, (%s)", this.getDescription(), this.getKey());
        }
    }
}

