/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import io.debezium.ibmi.db2.journal.retrieve.Connect;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcsidCache {
    private static final String GET_CCSID = "select table_name, system_table_name, column_name, system_column_name, ccsid FROM qsys2.SYSCOLUMNS where table_schema=? and (system_table_name = ? or table_name = ?)";
    private final Map<String, Integer> ccsidMap = new HashMap<String, Integer>();
    private final Connect<Connection, SQLException> jdbcConnect;
    static final Logger log = LoggerFactory.getLogger(CcsidCache.class);
    private final int fromCcsid;
    private final int toCcsid;

    public CcsidCache(Connect<Connection, SQLException> jdbcConnect, int fromCcsid, int toCcsid) {
        this.jdbcConnect = jdbcConnect;
        this.fromCcsid = fromCcsid;
        this.toCcsid = toCcsid;
    }

    public Integer getCcsid(String schema, String table, String columnName) {
        String canonicalName = String.format("%s.%s.%s", schema, table, columnName);
        if (this.ccsidMap.containsKey(canonicalName)) {
            return this.ccsidMap.get(canonicalName);
        }
        try {
            this.fetchAllCcsidForTable(schema, table);
            return this.ccsidMap.get(canonicalName);
        }
        catch (SQLException e) {
            log.error("failed to fetch ccsid", (Throwable)e);
            return -1;
        }
    }

    private void fetchAllCcsidForTable(String schema, String table) throws SQLException {
        Connection con = this.jdbcConnect.connection();
        try (PreparedStatement ps = con.prepareStatement(GET_CCSID);){
            ps.setString(1, schema.toUpperCase());
            ps.setString(2, table.toUpperCase());
            ps.setString(3, table.toUpperCase());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int ccsid;
                    String longTableName = StringHelpers.safeTrim(rs.getString(1));
                    String shortTableName = StringHelpers.safeTrim(rs.getString(2));
                    String longcolumn = StringHelpers.safeTrim(rs.getString(3));
                    String shortcolumn = StringHelpers.safeTrim(rs.getString(4));
                    Object ccsidObj = rs.getObject(5);
                    String canonicalLongName = String.format("%s.%s.%s", schema, longTableName, longcolumn);
                    String canonicalShortName = String.format("%s.%s.%s", schema, shortTableName, shortcolumn);
                    int n = ccsid = ccsidObj == null ? -1 : (Integer)ccsidObj;
                    if (this.fromCcsid == ccsid && this.toCcsid != -1) {
                        log.debug("overriding ccsid for {} was {} now {}", new Object[]{longTableName, this.fromCcsid, this.toCcsid});
                        ccsid = this.toCcsid;
                    }
                    this.ccsidMap.put(canonicalLongName, ccsid);
                    this.ccsidMap.put(canonicalShortName, ccsid);
                }
            }
        }
    }
}

