/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.sqs;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;

public class SqsTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"localstack/localstack");
    private static final LocalStackContainer container = new LocalStackContainer(DEFAULT_IMAGE_NAME).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.SQS});
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static String queueUrl;

    private static synchronized void init() throws IOException, InterruptedException {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public static SqsClient sqsClient() {
        return (SqsClient)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().endpointOverride(SqsTestResourceLifecycleManager.getAWSEndpoint())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)SqsTestResourceLifecycleManager.getAWSAccessKey(), (String)SqsTestResourceLifecycleManager.getAWSSecretKey())))).region(Region.of((String)SqsTestResourceLifecycleManager.getAWSRegion()))).build();
    }

    public Map<String, String> start() {
        try {
            SqsTestResourceLifecycleManager.init();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.sink.type", "sqs");
        params.put("debezium.sink.sqs.endpoint", SqsTestResourceLifecycleManager.getAWSEndpoint().toString());
        params.put("debezium.sink.sqs.region", SqsTestResourceLifecycleManager.getAWSRegion());
        CreateQueueResponse createdQueue = SqsTestResourceLifecycleManager.creteTestQueue();
        queueUrl = createdQueue.queueUrl();
        params.put("debezium.sink.sqs.queue.url", queueUrl);
        return params;
    }

    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static CreateQueueResponse creteTestQueue() {
        HashMap<QueueAttributeName, String> queueAttributes = new HashMap<QueueAttributeName, String>();
        queueAttributes.put(QueueAttributeName.FIFO_QUEUE, "true");
        queueAttributes.put(QueueAttributeName.CONTENT_BASED_DEDUPLICATION, "true");
        return SqsTestResourceLifecycleManager.sqsClient().createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName("debezium-cdc-events-queue.fifo").attributes(queueAttributes).build());
    }

    public static String getQueueUrl() {
        return queueUrl;
    }

    public static String getAWSAccessKey() {
        return container.getAccessKey();
    }

    public static String getAWSSecretKey() {
        return container.getSecretKey();
    }

    public static String getAWSRegion() {
        return container.getRegion();
    }

    public static URI getAWSEndpoint() {
        return container.getEndpoint();
    }
}

