/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.sqs;

import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.sqs.SqsTestConfigSource;
import io.debezium.server.sqs.SqsTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.enterprise.event.Observes;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class), @QuarkusTestResource(value=SqsTestResourceLifecycleManager.class)})
public class SqsIT {
    private static final int MESSAGE_COUNT = 4;

    public SqsIT() {
        Testing.Files.delete((Path)SqsTestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)SqsTestConfigSource.OFFSET_STORE_PATH);
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            throw (Exception)event.getError().get();
        }
    }

    @Test
    public void testSqs() throws Exception {
        Testing.Print.enable();
        ArrayList messages = new ArrayList();
        Awaitility.await().atMost(Duration.ofSeconds(SqsTestConfigSource.waitForSeconds())).until(() -> {
            ReceiveMessageResponse receiveMessageResponse = SqsTestResourceLifecycleManager.sqsClient().receiveMessage((ReceiveMessageRequest)ReceiveMessageRequest.builder().queueUrl(SqsTestResourceLifecycleManager.getQueueUrl()).waitTimeSeconds(Integer.valueOf(3)).maxNumberOfMessages(Integer.valueOf(4)).build());
            messages.addAll(receiveMessageResponse.messages());
            return messages.size() >= 4;
        });
    }
}

