/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.infinispan;

import io.debezium.server.Images;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;

public class InfinispanTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanTestResourceLifecycleManager.class);
    public static final int PORT = 11222;
    public static final String CONFIG_PATH = "/etc/infinispan-local.xml";
    private static final GenericContainer<?> container = new GenericContainer(Images.INFINISPAN_IMAGE).withExposedPorts(new Integer[]{11222}).withClasspathResourceMapping("infinispan-local.xml", "/etc/infinispan-local.xml", BindMode.READ_ONLY).withCommand(new String[]{"-c", "/etc/infinispan-local.xml"}).withEnv("USER", "admin").withEnv("PASS", "secret");
    private static final AtomicBoolean running = new AtomicBoolean(false);

    private static synchronized void init() {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public static String getHost() {
        return container.getHost();
    }

    public static int getPort() {
        return container.getMappedPort(11222);
    }

    public Map<String, String> start() {
        InfinispanTestResourceLifecycleManager.init();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.sink.infinispan.server.host", InfinispanTestResourceLifecycleManager.getHost());
        params.put("debezium.sink.infinispan.server.port", String.valueOf(InfinispanTestResourceLifecycleManager.getPort()));
        return params;
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }
}

