/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.infinispan;

import com.google.inject.Inject;
import io.debezium.server.DebeziumServer;
import io.debezium.server.infinispan.InfinispanTestConfigSource;
import io.debezium.server.infinispan.InfinispanTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.file.Path;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class), @QuarkusTestResource(value=InfinispanTestResourceLifecycleManager.class)})
public class InfinispanSinkConsumerIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanSinkConsumerIT.class);
    private static final int MESSAGE_COUNT = 4;
    @Inject
    DebeziumServer server;
    private DefaultCacheManager cacheManager;
    private Cache<String, String> cache;

    @Test
    public void testStreaming() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        String uri = String.format("hotrod://%s:%s@%s:%d", "admin", "secret", InfinispanTestResourceLifecycleManager.getHost(), InfinispanTestResourceLifecycleManager.getPort());
        LOGGER.info("Connected to Infinispan server using URI '{}'", (Object)uri);
        builder.uri(uri);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(builder.build());
        RemoteCache remoteCache = remoteCacheManager.getCache("debezium_test");
        Assertions.assertThat((int)remoteCache.size()).isEqualTo(0);
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> remoteCache.size() == 4);
        Assertions.assertThat((int)remoteCache.size()).isEqualTo(4);
    }

    static {
        Testing.Files.delete((Path)InfinispanTestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)InfinispanTestConfigSource.OFFSET_STORE_PATH);
    }
}

