/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ai.embeddings;

import io.debezium.ai.embeddings.FieldToEmbedding;
import io.debezium.ai.embeddings.FieldToEmbeddingTest;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;

@EnabledIfEnvironmentVariable(named="HF_API_KEY", matches=".+")
public class HuggingFaceMiniLmL6V2IT {
    @Test
    public void testMiniLmEmbeddings() {
        FieldToEmbedding embeddingSmt = new FieldToEmbedding();
        embeddingSmt.configure(Map.of("field.source", "after.product", "field.embedding", "after.prod_embedding", "huggingface.access.token", System.getenv("HF_API_KEY"), "huggingface.model.name", "sentence-transformers/all-MiniLM-L6-v2"));
        SourceRecord transformedRecord = (SourceRecord)embeddingSmt.apply((ConnectRecord)FieldToEmbeddingTest.SOURCE_RECORD);
        Struct payloadStruct = (Struct)transformedRecord.value();
        Assertions.assertThat((String)payloadStruct.getStruct("after").getString("product")).contains(new CharSequence[]{"a product"});
        List embeddings = payloadStruct.getStruct("after").getArray("prod_embedding");
        Assertions.assertThat((int)embeddings.size()).isEqualTo(384);
        Assertions.assertThat((List)embeddings).startsWith((Object[])new Float[]{Float.valueOf(-0.07157832f), Float.valueOf(0.02243797f), Float.valueOf(-0.02365577f), Float.valueOf(-0.014294202f), Float.valueOf(0.0048212307f), Float.valueOf(0.020384131f), Float.valueOf(0.20435654f), Float.valueOf(0.057306245f), Float.valueOf(0.054578826f), Float.valueOf(-0.030588612f)});
    }
}

