/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.test.rules;

import ch.qos.logback.classic.Level;
import io.datakernel.test.rules.LambdaStatement;
import io.datakernel.test.rules.LoggerConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingRule
implements TestRule {
    private static final Level DEFAULT_LOGGING_LEVEL = Level.TRACE;

    private static List<LoggerConfig> getAnnotations(AnnotationExtractor fn) {
        LoggerConfig single = fn.get(LoggerConfig.class);
        if (single == null) {
            LoggerConfig.Container container = fn.get(LoggerConfig.Container.class);
            if (container == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(container.value());
        }
        return Collections.singletonList(single);
    }

    public Statement apply(Statement base, Description description) {
        ArrayList<LoggerConfig> clauses = new ArrayList<LoggerConfig>();
        clauses.addAll(LoggingRule.getAnnotations(description.getTestClass()::getAnnotation));
        clauses.addAll(LoggingRule.getAnnotations(arg_0 -> ((Description)description).getAnnotation(arg_0)));
        return new LambdaStatement(() -> {
            int i;
            LoggingRule.setLoggerLevel("ROOT", DEFAULT_LOGGING_LEVEL);
            Level[] oldLevels = new Level[clauses.size()];
            Logger[] loggers = new Logger[clauses.size()];
            for (i = 0; i < clauses.size(); ++i) {
                LoggerConfig clause = (LoggerConfig)clauses.get(i);
                Logger logger = LoggerFactory.getLogger((String)(clause.logger() != Void.class ? clause.logger().getName() : (clause.packageOf() != Void.class ? clause.packageOf().getPackage().getName() : "ROOT")));
                oldLevels[i] = LoggingRule.getLoggerLevel(logger);
                loggers[i] = logger;
                LoggingRule.setLoggerLevel(logger, this.getAdaptedLevel(clause.value()));
            }
            try {
                base.evaluate();
            }
            finally {
                for (i = 0; i < loggers.length; ++i) {
                    LoggingRule.setLoggerLevel(loggers[i], oldLevels[i]);
                }
            }
        });
    }

    private Level getAdaptedLevel(org.slf4j.event.Level level) {
        switch (level) {
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return DEFAULT_LOGGING_LEVEL;
    }

    private static Level getLoggerLevel(Logger logger) {
        return ((ch.qos.logback.classic.Logger)logger).getLevel();
    }

    private static void setLoggerLevel(String name, Level level) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)name)).setLevel(level);
    }

    private static void setLoggerLevel(Logger logger, Level level) {
        ((ch.qos.logback.classic.Logger)logger).setLevel(level);
    }

    public static void enableOfPackageLogging(Class<?> cls) {
        LoggingRule.setLoggerLevel(cls.getPackage().getName(), DEFAULT_LOGGING_LEVEL);
    }

    public static void enableOfLoggerLogging(Class<?> cls) {
        LoggingRule.setLoggerLevel(cls.getName(), DEFAULT_LOGGING_LEVEL);
    }

    public static void enableOfPackageLogging(Class<?> cls, Level level) {
        LoggingRule.setLoggerLevel(cls.getPackage().getName(), level);
    }

    public static void enableOfLoggerLogging(Class<?> cls, Level level) {
        LoggingRule.setLoggerLevel(cls.getName(), level);
    }

    public static void enableLogging() {
        LoggingRule.setLoggerLevel("ROOT", DEFAULT_LOGGING_LEVEL);
    }

    public static void enableLogging(Level level) {
        LoggingRule.setLoggerLevel("ROOT", level);
    }

    private static interface AnnotationExtractor {
        @Nullable
        public <A extends Annotation> A get(Class<A> var1);
    }
}

