/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.test.rules;

import ch.qos.logback.classic.Level;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.FatalErrorHandlers;
import io.datakernel.test.rules.LoggingRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class EventloopRule
implements TestRule {
    private static void createEventloop() {
        Eventloop.create().withCurrentThread().withFatalErrorHandler(FatalErrorHandlers.rethrowOnAnyError());
    }

    public Statement apply(Statement base, Description description) {
        if (!Eventloop.getCurrentEventloop().inEventloopThread()) {
            EventloopRule.createEventloop();
        }
        return base;
    }

    static {
        EventloopRule.createEventloop();
        LoggingRule.enableOfLoggerLogging(Eventloop.class, Level.WARN);
    }
}

