/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.test.rules;

import io.datakernel.test.TestUtils;
import io.datakernel.test.rules.LambdaStatement;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActivePromisesRule
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(ActivePromisesRule.class);

    public Statement apply(Statement base, Description description) {
        return new LambdaStatement(() -> {
            TestUtils.clearActivePromises();
            try {
                base.evaluate();
            }
            catch (Throwable t) {
                int n = TestUtils.getActivePromises();
                if (n != 0) {
                    logger.info(n + " promise assertion" + (n == 1 ? " was" : "s were") + " not checked");
                }
                throw t;
            }
            assert (TestUtils.getActivePromises() == 0) : "Some promises have not been completed";
        });
    }
}

