/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.test;

import com.mysql.cj.jdbc.MysqlDataSource;
import io.datakernel.async.Callback;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jetbrains.annotations.Nullable;

public final class TestUtils {
    private static int activePromises = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int getFreePort() {
        try (ServerSocket s = new ServerSocket(0);){
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static DataSource dataSource(String databasePropertiesPath) throws IOException, SQLException {
        Properties properties = new Properties();
        properties.load(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(new File(databasePropertiesPath))), StandardCharsets.UTF_8));
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setUrl("jdbc:mysql://" + properties.getProperty("dataSource.serverName") + '/' + properties.getProperty("dataSource.databaseName"));
        dataSource.setUser(properties.getProperty("dataSource.user"));
        dataSource.setPassword(properties.getProperty("dataSource.password"));
        dataSource.setServerTimezone(properties.getProperty("dataSource.timeZone"));
        dataSource.setAllowMultiQueries(true);
        return dataSource;
    }

    public static <T> Callback<T> assertComplete(ThrowingConsumer<T> consumer) {
        ++activePromises;
        return (t, e) -> {
            --activePromises;
            if (e != null) {
                if (e instanceof AssertionError) {
                    throw (AssertionError)((Object)e);
                }
                throw new AssertionError((Object)e);
            }
            try {
                consumer.accept(t);
            }
            catch (Throwable e2) {
                if (e2 instanceof AssertionError) {
                    throw (AssertionError)((Object)e2);
                }
                throw new AssertionError((Object)e2);
            }
        };
    }

    public static <T> Callback<T> assertComplete() {
        return TestUtils.assertComplete($ -> {});
    }

    public static int getActivePromises() {
        return activePromises;
    }

    public static void clearActivePromises() {
        activePromises = 0;
    }

    public static <T> Supplier<T> asserting(ThrowingSupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static <T> Consumer<T> asserting(ThrowingConsumer<T> consumer) {
        return x -> {
            try {
                consumer.accept(x);
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static <T> Callback<T> asserting(ThrowingConsumerEx<T> consumer) {
        return (x, y) -> {
            try {
                consumer.accept(x, y);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        };
    }

    public static <T, R> Function<T, R> asserting(ThrowingFunction<T, R> function) {
        return x -> {
            try {
                return function.apply(x);
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> asserting(ThrowingBiFunction<T, U, R> function) {
        return (x, y) -> {
            try {
                return function.apply(x, y);
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingConsumerEx<T> {
        public void accept(T var1, @Nullable Throwable var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }
}

