/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.test;

import io.datakernel.di.core.Binding;
import io.datakernel.di.core.Dependency;
import io.datakernel.di.core.Injector;
import io.datakernel.di.core.Key;
import io.datakernel.di.module.Module;
import io.datakernel.di.module.Modules;
import io.datakernel.di.util.ReflectionUtils;
import io.datakernel.test.UseModules;
import io.datakernel.test.rules.LambdaStatement;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class DatakernelRunner
extends BlockJUnit4ClassRunner {
    private final List<FrameworkMethod> beforesAndAfters = new ArrayList<FrameworkMethod>();
    private final Set<Dependency> staticDependencies;
    protected Injector currentInjector;
    private Module currentModule;
    private Set<Dependency> currentDependencies;

    public DatakernelRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.beforesAndAfters.addAll(this.getTestClass().getAnnotatedMethods(Before.class));
        this.beforesAndAfters.addAll(this.getTestClass().getAnnotatedMethods(After.class));
        this.staticDependencies = this.beforesAndAfters.stream().flatMap(m -> Arrays.stream(ReflectionUtils.toDependencies((Type)clazz, (Parameter[])m.getMethod().getParameters()))).collect(Collectors.toSet());
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        for (FrameworkMethod testMethod : this.getTestClass().getAnnotatedMethods(annotation)) {
            testMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new LambdaStatement(() -> {
            Object[] args = Arrays.stream(method.getMethod().getParameters()).map(parameter -> this.currentInjector.getInstance(ReflectionUtils.keyOf((Type)this.getTestClass().getJavaClass(), (Type)parameter.getParameterizedType(), (AnnotatedElement)parameter))).toArray(Object[]::new);
            method.invokeExplosively(test, args);
        });
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement test) {
        Statement before = this.createCleanupStatement(target, Before.class);
        return new LambdaStatement(() -> {
            before.evaluate();
            test.evaluate();
        });
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement test) {
        Statement after = this.createCleanupStatement(target, After.class);
        return new LambdaStatement(() -> {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            try {
                test.evaluate();
            }
            catch (Throwable e) {
                errors.add(e);
            }
            finally {
                try {
                    after.evaluate();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
            MultipleFailureException.assertEmpty(errors);
        });
    }

    private Statement createCleanupStatement(Object target, Class<? extends Annotation> annotation) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        if (methods.isEmpty()) {
            return LambdaStatement.EMPTY;
        }
        Set statements = methods.stream().map(m -> this.methodInvoker((FrameworkMethod)m, target)).collect(Collectors.toSet());
        return new LambdaStatement(() -> {
            for (Statement statement : statements) {
                statement.evaluate();
            }
        });
    }

    protected Object createTest() throws Exception {
        Object instance = super.createTest();
        Key self = Key.ofType((Type)this.getTestClass().getJavaClass());
        this.currentInjector = Injector.of((Module[])new Module[]{this.currentModule, Module.create().scan(instance).bind(self).to(Binding.toInstance((Object)instance).addDependencies(this.currentDependencies).addDependencies(this.staticDependencies)).postInjectInto(self)});
        this.currentInjector.getInstance(self);
        this.currentInjector.createEagerSingletons();
        this.currentInjector.postInjectInstances();
        return instance;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
            return;
        }
        try {
            HashSet<Module> modules = new HashSet<Module>();
            this.addClassModules(modules);
            this.addMethodModules(modules, method);
            for (FrameworkMethod m : this.beforesAndAfters) {
                this.addMethodModules(modules, m);
            }
            this.currentModule = Modules.combine(modules);
            this.currentDependencies = new HashSet<Dependency>(Arrays.asList(ReflectionUtils.toDependencies((Type)this.getTestClass().getJavaClass(), (Parameter[])method.getMethod().getParameters())));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            return;
        }
        this.runLeaf(this.methodBlock(method), description, notifier);
    }

    private void addClassModules(Set<Module> modules) throws IllegalAccessException, InstantiationException {
        for (Class currentClass = this.getTestClass().getJavaClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            UseModules useModules = currentClass.getAnnotation(UseModules.class);
            if (useModules == null) continue;
            for (Class<? extends Module> moduleClass : useModules.value()) {
                modules.add(moduleClass.newInstance());
            }
        }
    }

    private void addMethodModules(Set<Module> modules, FrameworkMethod method) throws IllegalAccessException, InstantiationException {
        UseModules useModules = method.getMethod().getAnnotation(UseModules.class);
        if (useModules == null) {
            return;
        }
        for (Class<? extends Module> moduleClass : useModules.value()) {
            modules.add(moduleClass.newInstance());
        }
    }
}

