/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.compatibilitykit;

import io.cucumber.messages.types.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;

public final class MessageOrderer {
    private final Random random;

    public MessageOrderer(Random random) {
        this.random = random;
    }

    public Consumer<List<Envelope>> originalOrder() {
        return envelopes -> {};
    }

    public Consumer<List<Envelope>> simulateParallelExecution() {
        return messages -> {
            List<Envelope> testCaseMessagesInSerial = MessageOrderer.testCasesSubList(messages);
            List<List<Envelope>> testCaseMessagesGrouped = MessageOrderer.groupTestCasesIntoBuckets(testCaseMessagesInSerial);
            List<Envelope> testCaseMessagesInterleaved = MessageOrderer.interleafMessagesFromTestCases(this.random, testCaseMessagesGrouped);
            MessageOrderer.replaceAll(testCaseMessagesInSerial, testCaseMessagesInterleaved);
        };
    }

    private static void replaceAll(List<Envelope> testCaseMessagesInSerial, List<Envelope> envelopes) {
        for (int i = 0; i < testCaseMessagesInSerial.size(); ++i) {
            testCaseMessagesInSerial.set(i, envelopes.get(i));
        }
    }

    private static List<Envelope> interleafMessagesFromTestCases(Random random, List<List<Envelope>> messagesGroupedByTestCase) {
        ArrayList<Envelope> serial = new ArrayList<Envelope>();
        while (!messagesGroupedByTestCase.isEmpty()) {
            Collections.shuffle(messagesGroupedByTestCase, random);
            Iterator<List<Envelope>> bucketIterator = messagesGroupedByTestCase.iterator();
            while (bucketIterator.hasNext()) {
                List<Envelope> bucket = bucketIterator.next();
                if (bucket.isEmpty()) {
                    bucketIterator.remove();
                    continue;
                }
                serial.add(bucket.remove(0));
            }
        }
        return serial;
    }

    private static List<List<Envelope>> groupTestCasesIntoBuckets(List<Envelope> testCaseMessages) {
        ArrayList<List<Envelope>> buckets = new ArrayList<List<Envelope>>();
        ArrayList<Envelope> currentBucket = new ArrayList<Envelope>();
        for (Envelope middleMessage : testCaseMessages) {
            if (middleMessage.getTestCaseStarted().isPresent()) {
                buckets.add(currentBucket);
                currentBucket = new ArrayList();
            }
            currentBucket.add(middleMessage);
        }
        buckets.add(currentBucket);
        return buckets;
    }

    private static List<Envelope> testCasesSubList(List<Envelope> messages) {
        int testRunStartedIndex = MessageOrderer.findTestRunStartedIndex(messages);
        int testRunFinishedIndex = MessageOrderer.findTestRunFinishedIndex(messages);
        if (testRunStartedIndex == -1 || testRunFinishedIndex == -1) {
            return Collections.emptyList();
        }
        int firstTestRunMessage = testRunStartedIndex + 1;
        int lastTestRunMessage = testRunFinishedIndex - 1;
        if (firstTestRunMessage >= lastTestRunMessage) {
            return Collections.emptyList();
        }
        return messages.subList(firstTestRunMessage, lastTestRunMessage);
    }

    private static int findTestRunFinishedIndex(List<Envelope> messages) {
        for (int testRunFinishedIndex = messages.size() - 1; testRunFinishedIndex >= 0; --testRunFinishedIndex) {
            if (!messages.get(testRunFinishedIndex).getTestRunFinished().isPresent()) continue;
            return testRunFinishedIndex;
        }
        return -1;
    }

    private static int findTestRunStartedIndex(List<Envelope> messages) {
        for (int testRunStartedIndex = 0; testRunStartedIndex < messages.size(); ++testRunStartedIndex) {
            if (!messages.get(testRunStartedIndex).getTestRunStarted().isPresent()) continue;
            return testRunStartedIndex;
        }
        return -1;
    }
}

