/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.triggers;

import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.triggers.SmartTrigger;
import io.cryostat.agent.util.StringUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerParser {
    private static final String EXPRESSION_PATTERN_STRING = "\\[(.*(&&)*|(\\|\\|)*)\\]~([\\w\\-]+)(?:\\.jfc)?";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\[(.*(&&)*|(\\|\\|)*)\\]~([\\w\\-]+)(?:\\.jfc)?");
    private final FlightRecorderHelper flightRecorderHelper;
    private final Optional<Path> triggerPath;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public TriggerParser(FlightRecorderHelper flightRecorderHelper, Optional<Path> triggerPath) {
        this.flightRecorderHelper = flightRecorderHelper;
        this.triggerPath = triggerPath;
    }

    public List<SmartTrigger> parseFromFiles() {
        if (this.triggerPath.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.triggerPath.isPresent() && !this.checkDir()) {
            this.log.warn("Configuration directory {} doesn't exist or is missing permissions", (Object)this.triggerPath.get().toString());
            return Collections.emptyList();
        }
        try {
            return Files.walk(this.triggerPath.get(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).flatMap(path -> this.createFromFile((Path)path).stream()).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<SmartTrigger> createFromFile(Path path) {
        try {
            String triggerDefinitions = Files.readString(path);
            return Arrays.asList(triggerDefinitions.split(System.lineSeparator())).stream().map(String::strip).flatMap(definition -> this.parse((String)definition).stream()).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            this.log.error(ioe.getMessage());
            return Collections.emptyList();
        }
    }

    private boolean checkDir() {
        return Files.exists(this.triggerPath.get(), new LinkOption[0]) && Files.isReadable(this.triggerPath.get()) && Files.isExecutable(this.triggerPath.get()) && Files.isDirectory(this.triggerPath.get(), new LinkOption[0]);
    }

    public List<SmartTrigger> parse(String str) {
        String[] expressions;
        ArrayList<SmartTrigger> triggers = new ArrayList<SmartTrigger>();
        if (StringUtils.isBlank(str)) {
            return triggers;
        }
        for (String s : expressions = str.split(",")) {
            Matcher m = EXPRESSION_PATTERN.matcher(s = s.replaceAll("\\s", ""));
            if (!m.matches()) continue;
            String constraintString = m.group(1);
            String templateName = m.group(4);
            if (this.flightRecorderHelper.isValidTemplate(templateName)) {
                try {
                    SmartTrigger trigger = new SmartTrigger(constraintString, templateName);
                    triggers.add(trigger);
                }
                catch (DateTimeParseException dtpe) {
                    this.log.error("Failed to parse trigger duration constraint", (Throwable)dtpe);
                }
                continue;
            }
            this.log.warn("Template " + templateName + " not found. Skipping trigger.");
        }
        return triggers;
    }
}

