/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.triggers;

import dagger.Module;
import dagger.Provides;
import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.harvest.Harvester;
import io.cryostat.agent.triggers.TriggerEvaluator;
import io.cryostat.agent.triggers.TriggerParser;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.projectnessie.cel.tools.ScriptHost;

@Module
public abstract class TriggerModule {
    private static final String TRIGGER_SCHEDULER = "TRIGGER_SCHEDULER";

    @Provides
    @Singleton
    @Named(value="TRIGGER_SCHEDULER")
    public static ScheduledExecutorService provideTriggerScheduler() {
        return Executors.newScheduledThreadPool(0);
    }

    @Provides
    @Singleton
    public static TriggerParser provideTriggerParser(FlightRecorderHelper helper, @Named(value="cryostat.agent.smart-trigger.config.path") Optional<Path> triggerPath) {
        return new TriggerParser(helper, triggerPath);
    }

    @Provides
    @Singleton
    public static TriggerEvaluator provideTriggerEvaluatorFactory(@Named(value="TRIGGER_SCHEDULER") ScheduledExecutorService scheduler, ScriptHost scriptHost, @Named(value="cryostat.agent.smart-trigger.definitions") List<String> definitions, TriggerParser parser, FlightRecorderHelper helper, Harvester harvester, @Named(value="cryostat.agent.smart-trigger.evaluation.period-ms") long evaluationPeriodMs) {
        return new TriggerEvaluator(scheduler, scriptHost, definitions, parser, helper, harvester, evaluationPeriodMs);
    }
}

