/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import io.cryostat.agent.CryostatClient;
import io.cryostat.agent.remote.MutatingRemoteContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvokeContext
extends MutatingRemoteContext {
    private static final String DUMP_THREADS = "threadPrint";
    private static final String DUMP_THREADS_TO_FIlE = "threadDumpToFile";
    private static final String DIAGNOSTIC_BEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper;
    private CryostatClient client;

    @Inject
    InvokeContext(ObjectMapper mapper, Config config, CryostatClient client) {
        super(config);
        this.mapper = mapper;
        this.client = client;
    }

    @Override
    public String path() {
        return "/mbean-invoke/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String mtd;
            switch (mtd = exchange.getRequestMethod()) {
                case "POST": {
                    try (InputStream body = exchange.getRequestBody();){
                        MBeanInvocationRequest req = (MBeanInvocationRequest)this.mapper.readValue(body, MBeanInvocationRequest.class);
                        String requestId = "";
                        Object filename = (String)this.config.getValue("cryostat.agent.app.name", String.class);
                        if (!req.isValid()) {
                            exchange.sendResponseHeaders(400, -1L);
                        }
                        if (req.getOperation().equals("dumpHeap")) {
                            requestId = (String)req.parameters[2];
                            req.parameters[0] = filename = (String)filename + "-" + UUID.randomUUID().toString() + ".hprof";
                            Object[] parameters = new Object[]{req.parameters[0], req.parameters[1]};
                            req.parameters = parameters;
                        }
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        Object response = server.invoke(ObjectName.getInstance(req.beanName), req.operation, req.parameters, req.signature);
                        if (req.getOperation().equals("dumpHeap")) {
                            this.client.pushHeapDump(Paths.get((String)filename, new String[0]), requestId);
                        }
                        if (Objects.nonNull(response)) {
                            exchange.sendResponseHeaders(200, 0L);
                            try (OutputStream responseStream = exchange.getResponseBody();){
                                this.mapper.writeValue(responseStream, response);
                                return;
                            }
                        }
                        exchange.sendResponseHeaders(202, -1L);
                        return;
                    }
                    catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                        this.log.error("mbean serialization failure", (Throwable)e);
                        exchange.sendResponseHeaders(502, -1L);
                        return;
                    }
                }
                default: {
                    this.log.warn("Unknown request method {}", (Object)mtd);
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
            }
        }
        finally {
            exchange.close();
        }
    }

    static class MBeanInvocationRequest<T> {
        public String beanName;
        public String operation;
        public Object[] parameters;
        public String[] signature;
        private static final String HOTSPOT_DIAGNOSTIC_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

        MBeanInvocationRequest() {
        }

        public boolean isValid() {
            if (this.beanName.equals("java.lang:type=Memory") || this.beanName.equals(HOTSPOT_DIAGNOSTIC_BEAN_NAME)) {
                return true;
            }
            return this.beanName.equals(InvokeContext.DIAGNOSTIC_BEAN_NAME) && (this.operation.equals(InvokeContext.DUMP_THREADS) || this.operation.equals(InvokeContext.DUMP_THREADS_TO_FIlE));
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public void setParameters(Object[] parameters) {
            this.parameters = parameters;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }
    }
}

