/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import io.cryostat.agent.remote.RemoteContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.SettingDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventTypesContext
implements RemoteContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper;

    @Inject
    EventTypesContext(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String path() {
        return "/event-types/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String mtd;
            switch (mtd = exchange.getRequestMethod()) {
                case "GET": {
                    ArrayList<EventInfo> events = new ArrayList<EventInfo>();
                    try {
                        events.addAll(this.getEventTypes());
                    }
                    catch (Exception e) {
                        this.log.error("events serialization failure", (Throwable)e);
                        exchange.sendResponseHeaders(500, -1L);
                        return;
                    }
                    exchange.sendResponseHeaders(200, 0L);
                    try (OutputStream response = exchange.getResponseBody();){
                        this.mapper.writeValue(response, events);
                        return;
                    }
                }
                default: {
                    this.log.warn("Unknown request method {}", (Object)mtd);
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
            }
        }
        finally {
            exchange.close();
        }
    }

    private List<EventInfo> getEventTypes() {
        return FlightRecorder.getFlightRecorder().getEventTypes().stream().map(evt -> {
            EventInfo evtInfo = new EventInfo((EventType)evt);
            evtInfo.settings.addAll(evt.getSettingDescriptors().stream().map(SettingInfo::new).collect(Collectors.toList()));
            return evtInfo;
        }).collect(Collectors.toList());
    }

    private static class SettingInfo {
        public final String name;
        public final String defaultValue;

        SettingInfo(SettingDescriptor desc) {
            this.name = desc.getName();
            this.defaultValue = desc.getDefaultValue();
        }
    }

    private static class EventInfo {
        public final String name;
        public final String label;
        public final String description;
        public final List<String> categories;
        public final List<SettingInfo> settings = new ArrayList<SettingInfo>();

        EventInfo(EventType evt) {
            this.name = evt.getName();
            this.label = evt.getLabel();
            this.description = evt.getDescription();
            this.categories = evt.getCategoryNames();
        }
    }
}

