/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import io.cryostat.agent.remote.RemoteContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import jdk.jfr.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventTemplatesContext
implements RemoteContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper;

    @Inject
    EventTemplatesContext(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String path() {
        return "/event-templates/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String mtd;
            switch (mtd = exchange.getRequestMethod()) {
                case "GET": {
                    try {
                        List xmlTexts = Configuration.getConfigurations().stream().map(Configuration::getContents).collect(Collectors.toList());
                        exchange.sendResponseHeaders(200, 0L);
                        try (OutputStream response = exchange.getResponseBody();){
                            this.mapper.writeValue(response, xmlTexts);
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.log.error("events serialization failure", (Throwable)e);
                        return;
                    }
                }
                default: {
                    this.log.warn("Unknown request method {}", (Object)mtd);
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
            }
        }
        finally {
            exchange.close();
        }
    }
}

