/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.model;

import io.cryostat.agent.model.KeyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PluginInfo {
    private String id;
    private String token;
    private List<KeyValue> env = new ArrayList<KeyValue>();

    public PluginInfo() {
    }

    public PluginInfo(String id, String token, List<KeyValue> env) {
        this.id = id;
        this.token = token;
        this.env.addAll(env);
    }

    public PluginInfo(String id, String token, Map<String, String> env) {
        this(id, token, env.entrySet().stream().map(e -> new KeyValue((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
    }

    public void copyFrom(PluginInfo o) {
        this.setId(o.getId());
        this.setToken(o.getToken());
        this.setEnv(o.getEnv());
    }

    public void clear() {
        this.copyFrom(new PluginInfo());
    }

    public boolean isInitialized() {
        return this.id != null && this.token != null;
    }

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public List<KeyValue> getEnv() {
        return new ArrayList<KeyValue>(this.env);
    }

    public Map<String, String> getEnvAsMap() {
        return this.env.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setEnv(List<KeyValue> env) {
        this.env.clear();
        this.env.addAll(env);
    }

    public void setEnvFromMap(Map<String, String> env) {
        this.setEnv(env.entrySet().stream().map(e -> new KeyValue((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.token, this.env);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginInfo other = (PluginInfo)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.token, other.token) && Objects.equals(this.env, other.env);
    }
}

