/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.harvest;

import dagger.Module;
import dagger.Provides;
import io.cryostat.agent.CryostatClient;
import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.Registration;
import io.cryostat.agent.harvest.Harvester;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;

@Module
public abstract class HarvestModule {
    @Provides
    @Singleton
    public static Harvester provideHarvester(ScheduledExecutorService workerPool, @Named(value="cryostat.agent.harvester.period-ms") long period, @Named(value="cryostat.agent.harvester.template") String template, @Named(value="cryostat.agent.harvester.max-files") int maxFiles, @Named(value="cryostat.agent.harvester.exit.max-age-ms") long exitMaxAge, @Named(value="cryostat.agent.harvester.exit.max-size-b") long exitMaxSize, @Named(value="cryostat.agent.harvester.max-age-ms") long maxAge, @Named(value="cryostat.agent.harvester.max-size-b") long maxSize, @Named(value="cryostat.agent.harvester.autoanalyze") boolean autoanalyze, CryostatClient client, FlightRecorderHelper flightRecorderHelper, Registration registration) {
        Harvester.RecordingSettings exitSettings = new Harvester.RecordingSettings();
        exitSettings.name = "onexit";
        exitSettings.maxAge = exitMaxAge;
        exitSettings.maxSize = exitMaxSize;
        Harvester.RecordingSettings periodicSettings = new Harvester.RecordingSettings();
        periodicSettings.name = "cryostat-agent-harvester";
        periodicSettings.maxAge = maxAge > 0L ? maxAge : (long)((double)period * 1.5);
        periodicSettings.maxSize = maxSize;
        return new Harvester(Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("cryostat-agent-harvester");
            t.setDaemon(true);
            return t;
        }), workerPool, period, template, maxFiles, exitSettings, periodicSettings, autoanalyze, client, flightRecorderHelper, registration);
    }
}

