/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dagger.Lazy;
import io.cryostat.agent.CryostatClient;
import io.cryostat.agent.Registration;
import io.cryostat.agent.remote.RemoteContext;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Lazy<Set<RemoteContext>> remoteContexts;
    private final Lazy<CryostatClient> cryostat;
    private final Credentials credentials;
    private final Lazy<Registration> registration;
    private HttpServer http;
    private volatile int credentialId = -1;
    private final AgentAuthenticator agentAuthenticator;
    private final RequestLoggingFilter requestLoggingFilter;
    private final CompressionFilter compressionFilter;

    WebServer(Lazy<Set<RemoteContext>> remoteContexts, Lazy<CryostatClient> cryostat, HttpServer http, MessageDigest digest, String user, int passLength, Lazy<Registration> registration) {
        this.remoteContexts = remoteContexts;
        this.cryostat = cryostat;
        this.http = http;
        this.credentials = new Credentials(digest, user, passLength);
        this.registration = registration;
        this.agentAuthenticator = new AgentAuthenticator();
        this.requestLoggingFilter = new RequestLoggingFilter();
        this.compressionFilter = new CompressionFilter();
    }

    void start() {
        HashSet<PingContext> mergedContexts = new HashSet<PingContext>((Collection)this.remoteContexts.get());
        mergedContexts.add(new PingContext(this.registration));
        mergedContexts.stream().filter(RemoteContext::available).forEach(rc -> {
            HttpContext ctx = this.http.createContext(rc.path(), this.wrap(rc::handle));
            ctx.setAuthenticator(this.agentAuthenticator);
            ctx.getFilters().add(this.requestLoggingFilter);
            ctx.getFilters().add(this.compressionFilter);
        });
        this.http.start();
        this.log.debug("WebServer listening on {}", (Object)this.http.getAddress());
    }

    void stop() {
        if (this.http != null) {
            this.http.stop(0);
            this.http = null;
        }
    }

    int getCredentialId() {
        return this.credentialId;
    }

    void resetCredentialId() {
        this.credentialId = -1;
    }

    CompletableFuture<Void> generateCredentials(URI callback) {
        this.credentials.regenerate();
        return ((CompletableFuture)((CryostatClient)this.cryostat.get()).submitCredentialsIfRequired(this.credentialId, this.credentials, Objects.requireNonNull(callback)).handle((v, t) -> {
            this.credentials.clear();
            if (t != null) {
                this.resetCredentialId();
                this.log.error("Could not submit credentials", t);
                throw new CompletionException("Could not submit credentials", (Throwable)t);
            }
            return v;
        })).thenAccept(i -> {
            this.credentialId = i;
            this.log.trace("Defined credentials with id {}", i);
        });
    }

    private HttpHandler wrap(HttpHandler handler) {
        return x -> {
            try {
                handler.handle(x);
            }
            catch (Exception e) {
                this.log.error("Unhandled exception", (Throwable)e);
                x.sendResponseHeaders(500, -1L);
                x.close();
            }
        };
    }

    static class Credentials {
        private final SecureRandom random = new SecureRandom();
        private final MessageDigest digest;
        private final String user;
        private final byte[] pass;
        private byte[] passHash = new byte[0];

        Credentials(MessageDigest digest, String user, int passLength) {
            this.digest = digest;
            this.user = user;
            this.pass = new byte[passLength];
        }

        synchronized boolean checkUserInfo(String username, String password) {
            return this.passHash.length > 0 && Objects.equals(username, this.user) && Arrays.equals(this.hash(password), this.passHash);
        }

        synchronized void regenerate() {
            for (int idx = 0; idx < this.pass.length; ++idx) {
                this.pass[idx] = this.randomAscii();
            }
            this.passHash = this.hash(this.pass);
        }

        String user() {
            return this.user;
        }

        synchronized byte[] pass() {
            return this.pass;
        }

        synchronized void clear() {
            Arrays.fill(this.pass, (byte)0);
        }

        private byte randomAscii() {
            int start = 33;
            int end = 126;
            int diff = end - start;
            return (byte)(this.random.nextInt(diff + 1) + start);
        }

        private byte[] hash(String pass) {
            return this.hash(pass.getBytes(StandardCharsets.US_ASCII));
        }

        private byte[] hash(byte[] bytes) {
            return this.digest.digest(bytes);
        }
    }

    private class AgentAuthenticator
    extends BasicAuthenticator {
        public AgentAuthenticator() {
            super("cryostat-agent");
        }

        @Override
        public boolean checkCredentials(String username, String password) {
            return WebServer.this.credentials.checkUserInfo(username, password);
        }
    }

    private class CompressionFilter
    extends Filter {
        private CompressionFilter() {
        }

        @Override
        public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
            List requestedEncodings = exchange.getRequestHeaders().getOrDefault("Accept-Encoding", List.of()).stream().map(raw -> raw.replaceAll("\\s", "")).map(raw -> raw.split(",")).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toList());
            String negotiatedEncoding = null;
            Iterator iterator = requestedEncodings.iterator();
            block6: while (iterator.hasNext()) {
                String encoding;
                switch (encoding = (String)iterator.next()) {
                    case "deflate": {
                        negotiatedEncoding = encoding;
                        exchange.setStreams(exchange.getRequestBody(), new DeflaterOutputStream(exchange.getResponseBody()));
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if (negotiatedEncoding == null) {
                WebServer.this.log.trace("Using no encoding");
            } else {
                WebServer.this.log.trace("Using '{}' encoding", negotiatedEncoding);
                exchange.getResponseHeaders().put("Content-Encoding", List.of(negotiatedEncoding));
            }
            chain.doFilter(exchange);
        }

        @Override
        public String description() {
            return "responseCompression";
        }
    }

    private class RequestLoggingFilter
    extends Filter {
        private RequestLoggingFilter() {
        }

        @Override
        public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
            long start = System.nanoTime();
            String requestMethod = exchange.getRequestMethod();
            String path = exchange.getRequestURI().getPath();
            WebServer.this.log.trace("{} {}", (Object)requestMethod, (Object)path);
            chain.doFilter(exchange);
            long elapsed = System.nanoTime() - start;
            WebServer.this.log.trace("{} {} : {} {}ms", new Object[]{requestMethod, path, exchange.getResponseCode(), Duration.ofNanos(elapsed).toMillis()});
        }

        @Override
        public String description() {
            return "requestLog";
        }
    }

    private class PingContext
    implements RemoteContext {
        private final Lazy<Registration> registration;

        PingContext(Lazy<Registration> registration) {
            this.registration = registration;
        }

        @Override
        public String path() {
            return "/";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                String mtd;
                switch (mtd = exchange.getRequestMethod()) {
                    case "POST": {
                        Credentials credentials = WebServer.this.credentials;
                        synchronized (credentials) {
                            exchange.sendResponseHeaders(204, -1L);
                            ((Registration)this.registration.get()).notify(Registration.RegistrationEvent.State.REFRESHING);
                            return;
                        }
                    }
                    case "GET": {
                        exchange.sendResponseHeaders(204, -1L);
                        return;
                    }
                    default: {
                        WebServer.this.log.warn("Unknown request method {}", (Object)mtd);
                        exchange.sendResponseHeaders(405, -1L);
                        return;
                    }
                }
            }
            finally {
                exchange.close();
            }
        }
    }
}

