/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import io.cryostat.agent.util.ResourcesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final String RESOURCE_LOCATION = "versions.properties";
    static final String AGENT_VERSION_KEY = "cryostat.agent.version";
    static final String MIN_VERSION_KEY = "cryostat.server.version.min";
    static final String MAX_VERSION_KEY = "cryostat.server.version.max";
    private static Logger log = LoggerFactory.getLogger(VersionInfo.class);
    private final Semver agentVersion;
    private final Semver serverMin;
    private final Semver serverMax;

    VersionInfo(Semver agentVersion, Semver serverMin, Semver serverMax) {
        this.agentVersion = agentVersion;
        this.serverMin = serverMin;
        this.serverMax = serverMax;
    }

    public static VersionInfo load() throws IOException {
        Properties prop = new Properties();
        try (InputStream is = ResourcesUtil.getResourceAsStream(RESOURCE_LOCATION);){
            if (is == null) {
                log.warn("Could not locate resource {}", (Object)RESOURCE_LOCATION);
            } else {
                try {
                    prop.load(is);
                }
                catch (Exception e) {
                    log.warn(String.format("Failed to load resource %s", RESOURCE_LOCATION), (Throwable)e);
                }
            }
        }
        Semver agentVersion = Semver.fromString(prop.getProperty(AGENT_VERSION_KEY));
        Semver serverMin = Semver.fromString(prop.getProperty(MIN_VERSION_KEY));
        Semver serverMax = Semver.fromString(prop.getProperty(MAX_VERSION_KEY));
        return new VersionInfo(agentVersion, serverMin, serverMax);
    }

    public Map<String, String> asMap() {
        return Map.of(AGENT_VERSION_KEY, this.getAgentVersion().toString(), MIN_VERSION_KEY, this.getServerMin().toString(), MAX_VERSION_KEY, this.getServerMax().toString());
    }

    public Semver getAgentVersion() {
        return this.agentVersion;
    }

    public Semver getServerMin() {
        return this.serverMin;
    }

    public Semver getServerMax() {
        return this.serverMax;
    }

    public boolean validateServerVersion(Semver actual) {
        boolean greaterEqualMin = this.getServerMin().compareTo(actual) <= 0;
        boolean lesserMax = this.getServerMax().compareTo(actual) > 0;
        return greaterEqualMin && lesserMax;
    }

    public static class Semver
    implements Comparable<Semver> {
        public static final Pattern VERSION_PATTERN = Pattern.compile("^v?(?<major>[\\d]+)\\.(?<minor>[\\d]+)\\.(?<patch>[\\d]+)(?:[-_\\.][a-z0-9\\._-]*)?", 10);
        private static Logger log = LoggerFactory.getLogger(Semver.class);
        public static final Semver UNKNOWN = new Semver(0, 0, 0){

            @Override
            public String toString() {
                return "unknown";
            }
        };
        private final int major;
        private final int minor;
        private final int patch;

        public Semver(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public static Semver fromString(String in) {
            if (StringUtils.isBlank((CharSequence)in)) {
                return UNKNOWN;
            }
            try {
                Matcher m = VERSION_PATTERN.matcher(in);
                if (!m.matches()) {
                    log.warn("Input version \"{}\" did not match expected semver pattern", (Object)in);
                    return UNKNOWN;
                }
                return new Semver(Integer.parseInt(m.group("major")), Integer.parseInt(m.group("minor")), Integer.parseInt(m.group("patch")));
            }
            catch (NumberFormatException nfe) {
                log.error(String.format("Unable to parse input string \"%s\"", in), (Throwable)nfe);
                return UNKNOWN;
            }
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public String toString() {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }

        @Override
        public int compareTo(Semver o) {
            return Comparator.comparingInt(Semver::getMajor).thenComparing(Semver::getMinor).thenComparing(Semver::getPatch).compare(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.patch);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Semver other = (Semver)obj;
            return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
        }
    }
}

