/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import io.cryostat.agent.CallbackResolver;
import io.cryostat.agent.CryostatClient;
import io.cryostat.agent.RegistrationException;
import io.cryostat.agent.VersionInfo;
import io.cryostat.agent.WebServer;
import io.cryostat.agent.model.DiscoveryNode;
import io.cryostat.agent.model.PluginInfo;
import io.cryostat.agent.util.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registration {
    private static final String NODE_TYPE = "JVM";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService executor;
    private final CryostatClient cryostat;
    private final CallbackResolver callbackResolver;
    private final WebServer webServer;
    private final String instanceId;
    private final String jvmId;
    private final String appName;
    private final String realm;
    private final String hostname;
    private final int jmxPort;
    private final int registrationRetryMs;
    private final int registrationCheckMs;
    private final boolean registrationJmxIgnore;
    private final boolean registrationJmxUseCallbackHost;
    private final PluginInfo pluginInfo = new PluginInfo();
    private final Set<Consumer<RegistrationEvent>> listeners = new HashSet<Consumer<RegistrationEvent>>();
    private volatile URI callback;
    private ScheduledFuture<?> registrationCheckTask;

    Registration(ScheduledExecutorService executor, CryostatClient cryostat, CallbackResolver callbackResolver, WebServer webServer, String instanceId, String jvmId, String appName, String realm, String hostname, int jmxPort, int registrationRetryMs, int registrationCheckMs, boolean registrationJmxIgnore, boolean registrationJmxUseCallbackHost) {
        this.executor = executor;
        this.cryostat = cryostat;
        this.callbackResolver = callbackResolver;
        this.webServer = webServer;
        this.instanceId = instanceId;
        this.jvmId = jvmId;
        this.appName = appName;
        this.realm = realm;
        this.hostname = hostname;
        this.jmxPort = jmxPort;
        this.registrationRetryMs = registrationRetryMs;
        this.registrationCheckMs = registrationCheckMs;
        this.registrationJmxIgnore = registrationJmxIgnore;
        this.registrationJmxUseCallbackHost = registrationJmxUseCallbackHost;
    }

    void start() {
        this.addRegistrationListener(evt -> {
            switch (evt.state) {
                case UNREGISTERED: {
                    if (this.registrationCheckTask != null) {
                        this.registrationCheckTask.cancel(false);
                        this.registrationCheckTask = null;
                    }
                    try {
                        this.callback = this.callbackResolver.determineSelfCallback();
                    }
                    catch (UnknownHostException e) {
                        this.executor.schedule(() -> this.notify(RegistrationEvent.State.UNREGISTERED), (long)this.registrationRetryMs, TimeUnit.MILLISECONDS);
                    }
                    this.executor.submit(() -> this.webServer.generateCredentials(this.callback).handle((v, t) -> {
                        if (t != null) {
                            this.executor.schedule(() -> this.notify(RegistrationEvent.State.UNREGISTERED), (long)this.registrationRetryMs, TimeUnit.MILLISECONDS);
                            this.log.error("Failed to generate credentials", t);
                            throw new CompletionException((Throwable)t);
                        }
                        this.notify(RegistrationEvent.State.REFRESHING);
                        return v;
                    }));
                    break;
                }
                case REGISTERED: {
                    if (this.registrationCheckTask != null) {
                        this.log.warn("Re-registered without previous de-registration");
                        this.registrationCheckTask.cancel(false);
                    }
                    this.registrationCheckTask = this.executor.scheduleAtFixedRate(() -> {
                        try {
                            ((CompletableFuture)this.cryostat.checkRegistration(this.pluginInfo).handle((v, t) -> {
                                if (t != null || !Boolean.TRUE.equals(v)) {
                                    this.pluginInfo.clear();
                                    this.notify(RegistrationEvent.State.UNREGISTERED);
                                }
                                return null;
                            })).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            this.log.error("Could not check registration status", (Throwable)e);
                        }
                    }, this.registrationCheckMs, this.registrationCheckMs, TimeUnit.MILLISECONDS);
                    break;
                }
                case REFRESHING: {
                    this.executor.submit(this::tryRegister);
                    break;
                }
                case REFRESHED: {
                    break;
                }
                case PUBLISHED: {
                    break;
                }
            }
        });
        this.notify(RegistrationEvent.State.UNREGISTERED);
        this.log.trace("{} started", (Object)this.getClass().getName());
    }

    public void addRegistrationListener(Consumer<RegistrationEvent> listener) {
        this.listeners.add(listener);
    }

    void tryRegister() {
        int credentialId = this.webServer.getCredentialId();
        if (credentialId < 0) {
            this.notify(RegistrationEvent.State.UNREGISTERED);
            return;
        }
        try {
            ((CompletableFuture)this.cryostat.serverHealth().thenAccept(health -> {
                VersionInfo.Semver cryostatSemver = health.cryostatSemver();
                this.log.debug("Connected to Cryostat server: version {} , build {}", (Object)cryostatSemver, (Object)health.buildInfo().git().hash());
                try {
                    VersionInfo version = VersionInfo.load();
                    if (!version.validateServerVersion(cryostatSemver)) {
                        this.log.warn("Cryostat server version {} is outside of expected range [{}, {})", new Object[]{cryostatSemver, version.getServerMin(), version.getServerMax()});
                    }
                }
                catch (IOException ioe) {
                    this.log.error("Unable to read versions.properties file", (Throwable)ioe);
                }
            })).get();
            URI credentialedCallback = new URIBuilder(this.callback).setUserInfo("storedcredentials", String.valueOf(credentialId)).build();
            CompletionStage f = this.cryostat.register(credentialId, this.pluginInfo, credentialedCallback).handle((plugin, t) -> {
                if (plugin != null) {
                    boolean previouslyRegistered = this.pluginInfo.isInitialized();
                    this.pluginInfo.copyFrom((PluginInfo)plugin);
                    this.log.debug("Registered as {}", (Object)this.pluginInfo.getId());
                    if (previouslyRegistered) {
                        this.notify(RegistrationEvent.State.REFRESHED);
                    } else {
                        this.notify(RegistrationEvent.State.REGISTERED);
                        this.tryUpdate();
                    }
                } else if (t != null) {
                    this.webServer.resetCredentialId();
                    this.pluginInfo.clear();
                    throw new RegistrationException((Throwable)t);
                }
                return null;
            });
            ((CompletableFuture)f).get();
        }
        catch (InterruptedException | URISyntaxException | ExecutionException e) {
            this.log.error("Registration failure", (Throwable)e);
            this.log.trace("Registration retry period: {}", (Object)Duration.ofMillis(this.registrationRetryMs));
            this.executor.schedule(this::tryRegister, (long)this.registrationRetryMs, TimeUnit.MILLISECONDS);
        }
    }

    private void tryUpdate() {
        Set<DiscoveryNode> selfNodes;
        if (!this.pluginInfo.isInitialized()) {
            this.log.warn("update attempted before initialized");
            return;
        }
        try {
            selfNodes = this.defineSelf();
        }
        catch (URISyntaxException | UnknownHostException e) {
            this.log.error("Unable to define self", (Throwable)e);
            return;
        }
        this.log.trace("publishing self as {}", selfNodes.stream().map(n -> n.getTarget().getConnectUrl()).collect(Collectors.toList()));
        CompletionStage f = this.cryostat.update(this.pluginInfo, selfNodes).handle((n, t) -> {
            if (t != null) {
                this.log.error("Update failure", t);
                this.deregister();
            } else {
                this.log.trace("Publish success");
                this.notify(RegistrationEvent.State.PUBLISHED);
            }
            return null;
        });
        try {
            f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.log.error("Failed to update", (Throwable)e);
        }
    }

    private Set<DiscoveryNode> defineSelf() throws UnknownHostException, URISyntaxException {
        HashSet<DiscoveryNode> discoveryNodes = new HashSet<DiscoveryNode>();
        long pid = ProcessHandle.current().pid();
        String javaMain = System.getProperty("sun.java.command", System.getenv("JAVA_MAIN_CLASS"));
        if (StringUtils.isBlank(javaMain)) {
            this.log.warn("Unable to determine application mainclass");
            javaMain = null;
        }
        long startTime = ProcessHandle.current().info().startInstant().orElse(Instant.EPOCH).getEpochSecond();
        URI uri = this.callback;
        int port = uri.getPort();
        DiscoveryNode.Target httpSelf = new DiscoveryNode.Target(this.realm, uri, this.appName, this.instanceId, this.jvmId, pid, this.hostname, port, javaMain, startTime);
        discoveryNodes.add(new DiscoveryNode(this.appName + "-agent-" + this.pluginInfo.getId(), NODE_TYPE, httpSelf));
        if (!this.registrationJmxIgnore && this.jmxPort > 0) {
            uri = URI.create(String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", this.registrationJmxUseCallbackHost ? uri.getHost() : this.hostname, this.jmxPort));
            port = this.jmxPort;
            DiscoveryNode.Target jmxSelf = new DiscoveryNode.Target(this.realm, uri, this.appName, this.instanceId, this.jvmId, pid, this.hostname, port, javaMain, startTime);
            discoveryNodes.add(new DiscoveryNode(this.appName + "-jmx-" + this.pluginInfo.getId(), NODE_TYPE, jmxSelf));
        }
        return discoveryNodes;
    }

    void stop() {
    }

    CompletableFuture<Void> deregister() {
        if (!this.pluginInfo.isInitialized()) {
            this.log.warn("Deregistration requested before registration complete!");
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.cryostat.deleteCredentials(this.webServer.getCredentialId()).handle((v, t) -> this.cryostat.deregister(this.pluginInfo))).handle((n, t) -> {
            if (t != null) {
                this.log.warn("Failed to deregister as Cryostat discovery plugin [{}]", (Object)this.pluginInfo.getId());
            } else {
                this.log.debug("Deregistered from Cryostat discovery plugin [{}]", (Object)this.pluginInfo.getId());
            }
            this.pluginInfo.clear();
            this.notify(RegistrationEvent.State.UNREGISTERED);
            return null;
        });
    }

    public void notify(RegistrationEvent.State state) {
        RegistrationEvent evt = new RegistrationEvent(state);
        this.executor.submit(() -> this.listeners.forEach(listener -> listener.accept(evt)));
    }

    PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public static class RegistrationEvent {
        public final State state;

        RegistrationEvent(State state) {
            this.state = state;
        }

        public static enum State {
            UNREGISTERED,
            REGISTERED,
            PUBLISHED,
            REFRESHING,
            REFRESHED;

        }
    }
}

