/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.cryostat.libcryostat.templates.TemplateType;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.jfr.Configuration;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightRecorderHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Optional<Recording> createSnapshot() {
        Recording snapshot = FlightRecorder.getFlightRecorder().takeSnapshot();
        if (snapshot.getSize() == 0L) {
            this.log.warn("No active recordings");
            snapshot.close();
            return Optional.empty();
        }
        return Optional.of(snapshot);
    }

    public Recording createRecordingWithCustomTemplate(String template) throws IOException, ParseException {
        Recording recording = new Recording(Configuration.create(new StringReader(template)));
        recording.setToDisk(true);
        return recording;
    }

    public Optional<TemplatedRecording> createRecordingWithPredefinedTemplate(String templateNameOrLabel) {
        if ("ALL".equals(templateNameOrLabel)) {
            HashMap<String, String> allTemplate = new HashMap<String, String>();
            FlightRecorder.getFlightRecorder().getEventTypes().forEach(e -> {
                e.getSettingDescriptors().forEach(s -> allTemplate.put(e.getName() + "#" + s.getName(), s.getDefaultValue()));
                allTemplate.put(e.getName() + "#enabled", "true");
            });
            Recording recording = new Recording(allTemplate);
            recording.setToDisk(true);
            return Optional.of(new TemplatedRecording(new ConfigurationInfo(TemplateType.TARGET, "ALL", "ALL"), recording));
        }
        Optional<Configuration> opt = this.getTemplate(templateNameOrLabel);
        if (opt.isEmpty()) {
            this.log.error("Cannot start recording with template named or labelled {}", (Object)templateNameOrLabel);
            return Optional.empty();
        }
        Configuration configuration = opt.get();
        Recording recording = new Recording(configuration.getSettings());
        recording.setToDisk(true);
        return Optional.of(new TemplatedRecording(new ConfigurationInfo(configuration), recording));
    }

    public Optional<Configuration> getTemplate(String nameOrLabel) {
        Objects.requireNonNull(nameOrLabel);
        return Configuration.getConfigurations().stream().filter(c -> c.getName().equals(nameOrLabel) || c.getLabel().equals(nameOrLabel)).findFirst();
    }

    public boolean isValidTemplate(String nameOrLabel) {
        Objects.requireNonNull(nameOrLabel);
        return this.getTemplate(nameOrLabel).isPresent();
    }

    public List<Recording> getRecordings() {
        return this.getRecordings(r -> true);
    }

    public List<Recording> getRecordings(Predicate<Recording> predicate) {
        if (!FlightRecorder.isAvailable()) {
            this.log.error("FlightRecorder is unavailable");
            return List.of();
        }
        return FlightRecorder.getFlightRecorder().getRecordings().stream().filter(predicate).collect(Collectors.toList());
    }

    public Optional<Recording> getRecording(long id) {
        return this.getRecordings(r -> r.getId() == id).stream().findFirst();
    }

    public static class RecordingInfo {
        public final long id;
        public final String name;
        public final String state;
        public final Map<String, String> options;
        public final long startTime;
        public final long duration;
        public final boolean isContinuous;
        public final boolean toDisk;
        public final long maxSize;
        public final long maxAge;

        RecordingInfo(Recording rec) {
            this.id = rec.getId();
            this.name = rec.getName();
            this.state = rec.getState().name();
            this.options = rec.getSettings();
            this.startTime = rec.getStartTime() != null ? rec.getStartTime().toEpochMilli() : 0L;
            this.isContinuous = rec.getDuration() == null;
            this.duration = this.isContinuous ? 0L : rec.getDuration().toMillis();
            this.toDisk = rec.isToDisk();
            this.maxSize = rec.getMaxSize();
            this.maxAge = rec.getMaxAge() != null ? rec.getMaxAge().toMillis() : 0L;
        }
    }

    public static class ConfigurationInfo {
        private final String name;
        private final String label;
        private final TemplateType type;

        public ConfigurationInfo(TemplateType type, String name, String label) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.label = Objects.requireNonNull(label);
        }

        public ConfigurationInfo(Configuration configuration) {
            this(TemplateType.TARGET, configuration.getName(), configuration.getLabel());
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public TemplateType getType() {
            return this.type;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public static class TemplatedRecording {
        private final ConfigurationInfo configuration;
        private final Recording recording;

        public TemplatedRecording(ConfigurationInfo configuration, Recording recording) {
            this.configuration = Objects.requireNonNull(configuration);
            this.recording = Objects.requireNonNull(recording);
        }

        public ConfigurationInfo getConfigurationInfo() {
            return this.configuration;
        }

        public Recording getRecording() {
            return this.recording;
        }
    }
}

