/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.HttpException;
import io.cryostat.agent.RegistrationException;
import io.cryostat.agent.WebServer;
import io.cryostat.agent.harvest.Harvester;
import io.cryostat.agent.model.DiscoveryNode;
import io.cryostat.agent.model.PluginInfo;
import io.cryostat.agent.model.RegistrationInfo;
import io.cryostat.agent.model.ServerHealth;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.jfr.Recording;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryostatClient {
    private static final String DISCOVERY_API_PATH = "/api/v4/discovery";
    private static final String CREDENTIALS_API_PATH = "/api/v4/credentials";
    private static final String CHECK_CREDENTIAL_API_PATH = "/api/beta/discovery/credential_exists";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Executor executor;
    private final ObjectMapper mapper;
    private final HttpClient http;
    private final Supplier<Optional<String>> authorizationSupplier;
    private final String appName;
    private final String instanceId;
    private final String jvmId;
    private final URI baseUri;
    private final String realm;

    CryostatClient(Executor executor, ObjectMapper mapper, HttpClient http, Supplier<Optional<String>> authorizationSupplier, String instanceId, String jvmId, String appName, URI baseUri, String realm) {
        this.executor = executor;
        this.mapper = mapper;
        this.http = http;
        this.authorizationSupplier = authorizationSupplier;
        this.instanceId = instanceId;
        this.jvmId = jvmId;
        this.appName = appName;
        this.baseUri = baseUri;
        this.realm = realm;
        this.log.trace("Using Cryostat baseuri {}", (Object)baseUri);
    }

    public CompletableFuture<ServerHealth> serverHealth() {
        HttpGet req = new HttpGet(this.baseUri.resolve("/health"));
        this.log.trace("{}", (Object)req);
        return ((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).thenApply(res -> {
            ServerHealth serverHealth;
            block8: {
                InputStream is = res.getEntity().getContent();
                try {
                    serverHealth = (ServerHealth)this.mapper.readValue(is, ServerHealth.class);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.log.error("Unable to parse response as JSON", (Throwable)e);
                        throw new RegistrationException(e);
                    }
                }
                is.close();
            }
            return serverHealth;
        })).whenComplete((v, t) -> req.reset());
    }

    public CompletableFuture<Boolean> checkRegistration(PluginInfo pluginInfo) {
        if (!pluginInfo.isInitialized()) {
            return CompletableFuture.completedFuture(false);
        }
        HttpGet req = new HttpGet(this.baseUri.resolve("/api/v4/discovery/" + pluginInfo.getId() + "?token=" + pluginInfo.getToken()));
        this.log.trace("{}", (Object)req);
        return ((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).thenApply(this::isOkStatus)).whenComplete((v, t) -> req.reset());
    }

    public CompletableFuture<PluginInfo> register(int credentialId, PluginInfo pluginInfo, URI callback) {
        try {
            RegistrationInfo registrationInfo = new RegistrationInfo(pluginInfo.getId(), this.realm, callback, pluginInfo.getToken());
            HttpPost req = new HttpPost(this.baseUri.resolve(DISCOVERY_API_PATH));
            this.log.trace("{}", (Object)req);
            req.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)registrationInfo), ContentType.APPLICATION_JSON));
            return ((CompletableFuture)((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).handle((res, t) -> {
                if (t != null) {
                    throw new CompletionException((Throwable)t);
                }
                if (!this.isOkStatus((HttpResponse)res)) {
                    try {
                        this.deleteCredentials(credentialId).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.log.error("Failed to delete previous credentials", (Throwable)e);
                    }
                }
                return this.assertOkStatus((HttpRequestBase)req, (HttpResponse)res);
            })).thenApply(res -> {
                PluginInfo pluginInfo;
                block8: {
                    InputStream is = res.getEntity().getContent();
                    try {
                        pluginInfo = (PluginInfo)this.mapper.readValue(is, PluginInfo.class);
                        if (is == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            this.log.error("Unable to parse response as JSON", (Throwable)e);
                            throw new RegistrationException(e);
                        }
                    }
                    is.close();
                }
                return pluginInfo;
            })).whenComplete((v, t) -> req.reset());
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Integer> submitCredentialsIfRequired(int prevId, WebServer.Credentials credentials, URI callback) {
        if (prevId < 0) {
            return this.queryExistingCredentials(callback).thenCompose(id -> {
                if (id >= 0) {
                    return CompletableFuture.completedFuture(id);
                }
                return this.submitCredentials(prevId, credentials, callback);
            });
        }
        HttpGet req = new HttpGet(this.baseUri.resolve("/api/v4/credentials/" + prevId));
        this.log.trace("{}", (Object)req);
        return ((CompletableFuture)((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).handle((v, t) -> {
            if (t != null) {
                this.log.error("Failed to get credentials with ID " + prevId, t);
                throw new CompletionException((Throwable)t);
            }
            return this.isOkStatus((HttpResponse)v);
        })).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(prevId);
            }
            return this.submitCredentials(prevId, credentials, callback);
        })).whenComplete((v, t) -> req.reset());
    }

    private CompletableFuture<Integer> queryExistingCredentials(URI callback) {
        HttpPost req = new HttpPost(this.baseUri.resolve(CHECK_CREDENTIAL_API_PATH));
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addPart(FormBodyPartBuilder.create((String)"script", (ContentBody)new StringBody(this.selfMatchExpression(callback), ContentType.TEXT_PLAIN)).build());
        this.log.trace("{}", (Object)req);
        req.setEntity(entityBuilder.build());
        return ((CompletableFuture)((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).handle((res, t) -> {
            if (t != null) {
                this.log.error("Failed to check credential", t);
                throw new CompletionException((Throwable)t);
            }
            return res;
        })).thenApply(res -> {
            Integer n;
            block9: {
                if (!this.isOkStatus((HttpResponse)res)) {
                    return -1;
                }
                InputStream is = res.getEntity().getContent();
                try {
                    n = ((StoredCredential)this.mapper.readValue((InputStream)is, StoredCredential.class)).id;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.log.error("Unable to parse response as JSON", (Throwable)e);
                        throw new RegistrationException(e);
                    }
                }
                is.close();
            }
            return n;
        })).whenComplete((v, t) -> req.reset());
    }

    private CompletableFuture<Integer> submitCredentials(int prevId, WebServer.Credentials credentials, URI callback) {
        HttpPost req = new HttpPost(this.baseUri.resolve(CREDENTIALS_API_PATH));
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addPart(FormBodyPartBuilder.create((String)"username", (ContentBody)new StringBody(credentials.user(), ContentType.TEXT_PLAIN)).build()).addPart(FormBodyPartBuilder.create((String)"password", (ContentBody)new ByteArrayBody(credentials.pass(), ContentType.TEXT_PLAIN, "pass")).build()).addPart(FormBodyPartBuilder.create((String)"matchExpression", (ContentBody)new StringBody(this.selfMatchExpression(callback), ContentType.TEXT_PLAIN)).build());
        this.log.trace("{}", (Object)req);
        req.setEntity(entityBuilder.build());
        return ((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).thenApply(res -> {
            if (!this.isOkStatus((HttpResponse)res)) {
                try {
                    int queried;
                    if (res.getStatusLine().getStatusCode() == 409 && (queried = this.queryExistingCredentials(callback).get().intValue()) >= 0) {
                        return queried;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    this.log.error("Failed to query for existing credentials", (Throwable)e);
                }
                try {
                    this.deleteCredentials(prevId).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.log.error("Failed to delete previous credentials with id " + prevId, (Throwable)e);
                    throw new RegistrationException(e);
                }
            }
            String location = this.assertOkStatus((HttpRequestBase)req, (HttpResponse)res).getFirstHeader("Location").getValue();
            String id = location.substring(location.lastIndexOf(47) + 1, location.length());
            return Integer.valueOf(id);
        })).whenComplete((v, t) -> req.reset());
    }

    public CompletableFuture<Void> deleteCredentials(int id) {
        if (id < 0) {
            return CompletableFuture.completedFuture(null);
        }
        HttpDelete req = new HttpDelete(this.baseUri.resolve("/api/v4/credentials/" + id));
        this.log.trace("{}", (Object)req);
        return ((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).whenComplete((v, t) -> req.reset())).thenApply(res -> null);
    }

    public CompletableFuture<Void> deregister(PluginInfo pluginInfo) {
        HttpDelete req = new HttpDelete(this.baseUri.resolve("/api/v4/discovery/" + pluginInfo.getId() + "?token=" + pluginInfo.getToken()));
        this.log.trace("{}", (Object)req);
        return ((CompletableFuture)((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).thenApply(res -> this.assertOkStatus((HttpRequestBase)req, (HttpResponse)res))).whenComplete((v, t) -> req.reset())).thenApply(res -> null);
    }

    public CompletableFuture<Void> update(PluginInfo pluginInfo, Collection<DiscoveryNode> subtree) {
        try {
            HttpPost req = new HttpPost(this.baseUri.resolve("/api/v4/discovery/" + pluginInfo.getId() + "?token=" + pluginInfo.getToken()));
            req.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString(subtree), ContentType.APPLICATION_JSON));
            this.log.trace("{}", (Object)req);
            return ((CompletableFuture)((CompletableFuture)this.supply((HttpRequestBase)req, res -> this.logResponse((HttpRequestBase)req, (HttpResponse)res)).thenApply(res -> this.assertOkStatus((HttpRequestBase)req, (HttpResponse)res))).whenComplete((v, t) -> req.reset())).thenApply(res -> null);
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Void> pushHeapDump(Path heapDump, String requestId) throws IOException, IllegalArgumentException {
        Instant start = Instant.now();
        if (heapDump.toFile().getName().isBlank()) {
            throw new IllegalArgumentException("Failed to generate heap dump");
        }
        HttpPost req = new HttpPost(this.baseUri.resolve("/api/beta/diagnostics/heapdump/upload/" + this.jvmId));
        CountingInputStream is = this.getRecordingInputStream(heapDump);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addPart(FormBodyPartBuilder.create((String)"heapDump", (ContentBody)new InputStreamBody((InputStream)is, ContentType.APPLICATION_OCTET_STREAM, heapDump.toFile().getName())).build()).addPart(FormBodyPartBuilder.create((String)"jobId", (ContentBody)new StringBody(requestId, ContentType.TEXT_PLAIN)).build());
        req.setEntity(entityBuilder.build());
        return this.supply((HttpRequestBase)req, res -> {
            Instant finish = Instant.now();
            this.log.trace("{} {} ({} -> {}): {}/{}", new Object[]{req.getMethod(), res.getStatusLine().getStatusCode(), heapDump.getFileName().toString(), req.getURI(), FileUtils.byteCountToDisplaySize((long)is.getByteCount()), Duration.between(start, finish)});
            this.assertOkStatus((HttpRequestBase)req, (HttpResponse)res);
            return null;
        }).whenComplete((v, t) -> {
            try {
                Files.delete(heapDump);
            }
            catch (IOException ioe) {
                this.log.warn("Failed to delete heap dump: ", (Object)heapDump.toString());
            }
            req.reset();
        });
    }

    public CompletableFuture<Void> upload(Harvester.PushType pushType, Optional<FlightRecorderHelper.TemplatedRecording> opt, int maxFiles, Map<String, String> additionalLabels, Path recording) throws IOException {
        Instant start = Instant.now();
        String timestamp = start.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("[-:]", "");
        String template = opt.map(FlightRecorderHelper.TemplatedRecording::getConfigurationInfo).map(FlightRecorderHelper.ConfigurationInfo::getName).map(String::toLowerCase).map(String::trim).orElse("unknown");
        String fileName = String.format("%s_%s_%s.jfr", this.appName + opt.map(FlightRecorderHelper.TemplatedRecording::getRecording).map(Recording::getName).map(n -> "-" + n).orElse(""), template, timestamp);
        HashMap<String, String> labels = new HashMap<String, String>(additionalLabels);
        labels.putAll(Map.of("jvmId", this.jvmId, "pushType", pushType.name(), "template.name", template, "template.type", "TARGET"));
        HttpPost req = new HttpPost(this.baseUri.resolve("/api/beta/recordings/" + this.jvmId));
        CountingInputStream is = this.getRecordingInputStream(recording);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addPart(FormBodyPartBuilder.create((String)"recording", (ContentBody)new InputStreamBody((InputStream)is, ContentType.APPLICATION_OCTET_STREAM, fileName)).build()).addPart(FormBodyPartBuilder.create((String)"labels", (ContentBody)new StringBody(this.mapper.writeValueAsString(labels), ContentType.APPLICATION_JSON)).build()).addPart(FormBodyPartBuilder.create((String)"maxFiles", (ContentBody)new StringBody(Integer.toString(maxFiles), ContentType.TEXT_PLAIN)).build());
        req.setEntity(entityBuilder.build());
        return this.supply((HttpRequestBase)req, res -> {
            Instant finish = Instant.now();
            this.log.trace("{} {} ({} -> {}): {}/{}", new Object[]{req.getMethod(), res.getStatusLine().getStatusCode(), fileName, req.getURI(), FileUtils.byteCountToDisplaySize((long)is.getByteCount()), Duration.between(start, finish)});
            this.assertOkStatus((HttpRequestBase)req, (HttpResponse)res);
            return null;
        }).whenComplete((v, t) -> req.reset());
    }

    private HttpResponse logResponse(HttpRequestBase req, HttpResponse res) {
        this.log.trace("{} {} : {}", new Object[]{req.getMethod(), req.getURI(), res.getStatusLine().getStatusCode()});
        return res;
    }

    private <T> CompletableFuture<T> supply(HttpRequestBase req, Function<HttpResponse, T> fn) {
        this.authorizationSupplier.get().ifPresent(v -> req.addHeader("Authorization", v));
        return CompletableFuture.supplyAsync(() -> fn.apply(this.executeQuiet((HttpUriRequest)req)), this.executor);
    }

    private HttpResponse executeQuiet(HttpUriRequest req) {
        try {
            return this.http.execute(req);
        }
        catch (IOException ioe) {
            throw new CompletionException(ioe);
        }
    }

    private CountingInputStream getRecordingInputStream(Path filePath) throws IOException {
        return new CountingInputStream((InputStream)new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0])));
    }

    private String selfMatchExpression(URI callback) {
        return String.format("target.connectUrl == \"%s\" && target.annotations.platform[\"INSTANCE_ID\"] == \"%s\"", callback, this.instanceId);
    }

    private boolean isOkStatus(HttpResponse res) {
        int sc = res.getStatusLine().getStatusCode();
        return 200 <= sc && sc < 400;
    }

    private HttpResponse assertOkStatus(HttpRequestBase req, HttpResponse res) {
        int sc = res.getStatusLine().getStatusCode();
        if (!this.isOkStatus(res)) {
            URI uri = req.getURI();
            this.log.error("Non-OK response ({}) on HTTP API {}", (Object)sc, (Object)uri);
            try {
                throw new HttpException(sc, new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null));
            }
            catch (URISyntaxException use) {
                throw new IllegalStateException(use);
            }
        }
        return res;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    public static class StoredCredential {
        public int id;
        public String matchExpression;

        public int hashCode() {
            return Objects.hash(this.id, this.matchExpression);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoredCredential other = (StoredCredential)obj;
            return this.id == other.id && Objects.equals(this.matchExpression, other.matchExpression);
        }
    }
}

