/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import dagger.Module;
import dagger.Provides;
import io.cryostat.agent.Agent;
import io.cryostat.agent.AuthorizationType;
import io.cryostat.agent.TruststoreConfig;
import io.cryostat.agent.util.ResourcesUtil;
import io.cryostat.agent.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module
public abstract class ConfigModule {
    private static final Logger log = LoggerFactory.getLogger(ConfigModule.class);
    public static final String CRYOSTAT_AGENT_CALLBACK_CANDIDATES = "cryostat-agent-callback-candidates";
    public static final String CRYOSTAT_AGENT_INSTANCE_ID = "cryostat.agent.instance-id";
    public static final String CRYOSTAT_AGENT_BASEURI_RANGE = "cryostat.agent.baseuri-range";
    public static final String CRYOSTAT_AGENT_BASEURI = "cryostat.agent.baseuri";
    public static final String CRYOSTAT_AGENT_CALLBACK = "cryostat.agent.callback";
    public static final String CRYOSTAT_AGENT_REALM = "cryostat.agent.realm";
    public static final String CRYOSTAT_AGENT_AUTHORIZATION = "cryostat.agent.authorization";
    public static final String CRYOSTAT_AGENT_AUTHORIZATION_TYPE = "cryostat.agent.authorization.type";
    public static final String CRYOSTAT_AGENT_AUTHORIZATION_VALUE = "cryostat.agent.authorization.value";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_VERSION = "cryostat.agent.webclient.tls.version";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUST_ALL = "cryostat.agent.webclient.tls.trust-all";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_VERIFY_HOSTNAME = "cryostat.agent.webclient.tls.verify-hostname";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_CONNECT_TIMEOUT_MS = "cryostat.agent.webclient.connect.timeout-ms";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_RESPONSE_TIMEOUT_MS = "cryostat.agent.webclient.response.timeout-ms";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PATH = "cryostat.agent.webclient.tls.truststore.path";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PASS_FILE = "cryostat.agent.webclient.tls.truststore.pass.file";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PASS_CHARSET = "cryostat.agent.webclient.tls.truststore.pass-charset";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PASS = "cryostat.agent.webclient.tls.truststore.pass";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_TYPE = "cryostat.agent.webclient.tls.truststore.type";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_CERTS = "cryostat.agent.webclient.tls.truststore.cert";
    public static final Pattern CRYOSTAT_AGENT_TRUSTSTORE_PATTERN = Pattern.compile("^(?:cryostat\\.agent\\.webclient\\.tls\\.truststore\\.cert).(?<index>\\d+).\\.(?<property>.*)$");
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_CERT_PATH = "cryostat.agent.webclient.tls.client-auth.cert.path";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_CERT_TYPE = "cryostat.agent.webclient.tls.client-auth.cert.type";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_CERT_ALIAS = "cryostat.agent.webclient.tls.client-auth.cert.alias";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PATH = "cryostat.agent.webclient.tls.client-auth.key.path";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_CHARSET = "cryostat.agent.webclient.tls.client-auth.key.charset";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_ENCODING = "cryostat.agent.webclient.tls.client-auth.key.encoding";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_TYPE = "cryostat.agent.webclient.tls.client-auth.key.type";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PASS_FILE = "cryostat.agent.webclient.tls.client-auth.key.pass.file";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PASS_CHARSET = "cryostat.agent.webclient.tls.client-auth.key.pass-charset";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PASS = "cryostat.agent.webclient.tls.client-auth.key.pass";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS_FILE = "cryostat.agent.webclient.tls.client-auth.keystore.pass.file";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS_CHARSET = "cryostat.agent.webclient.tls.client-auth.keystore.pass-charset";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS = "cryostat.agent.webclient.tls.client-auth.keystore.pass";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_TYPE = "cryostat.agent.webclient.tls.client-auth.keystore.type";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_MANAGER_TYPE = "cryostat.agent.webclient.tls.client-auth.key-manager.type";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_RESPONSE_RETRY_COUNT = "cryostat.agent.webclient.response.retry-count";
    public static final String CRYOSTAT_AGENT_WEBCLIENT_TLS_REQUIRED = "cryostat.agent.webclient.tls.required";
    public static final String CRYOSTAT_AGENT_WEBSERVER_HOST = "cryostat.agent.webserver.host";
    public static final String CRYOSTAT_AGENT_WEBSERVER_PORT = "cryostat.agent.webserver.port";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_VERSION = "cryostat.agent.webserver.tls.version";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_PASS = "cryostat.agent.webserver.tls.keystore.pass";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_PASS_CHARSET = "cryostat.agent.webserver.tls.keystore.pass-charset";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_FILE = "cryostat.agent.webserver.tls.keystore.file";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_TYPE = "cryostat.agent.webserver.tls.keystore.type";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_ALIAS = "cryostat.agent.webserver.tls.key.alias";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PATH = "cryostat.agent.webserver.tls.key.path";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_CHARSET = "cryostat.agent.webserver.tls.key.charset";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_ENCODING = "cryostat.agent.webserver.tls.key.encoding";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_TYPE = "cryostat.agent.webserver.tls.key.type";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PASS_FILE = "cryostat.agent.webserver.tls.key.pass.file";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PASS_CHARSET = "cryostat.agent.webserver.tls.key.pass-charset";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PASS = "cryostat.agent.webserver.tls.key.pass";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_CERT_ALIAS = "cryostat.agent.webserver.tls.cert.alias";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_CERT_FILE = "cryostat.agent.webserver.tls.cert.file";
    public static final String CRYOSTAT_AGENT_WEBSERVER_TLS_CERT_TYPE = "cryostat.agent.webserver.tls.cert.type";
    public static final String CRYOSTAT_AGENT_WEBSERVER_CREDENTIALS_USER = "cryostat.agent.webserver.credentials.user";
    public static final String CRYOSTAT_AGENT_WEBSERVER_CREDENTIALS_PASS_HASH_FUNCTION = "cryostat.agent.webserver.credentials.pass.hash-function";
    public static final String CRYOSTAT_AGENT_WEBSERVER_CREDENTIALS_PASS_LENGTH = "cryostat.agent.webserver.credentials.pass.length";
    public static final String CRYOSTAT_AGENT_CONFIG_LOADABLE = "cryostat.agent.config.loadable";
    public static final String CRYOSTAT_AGENT_APP_NAME = "cryostat.agent.app.name";
    public static final String CRYOSTAT_AGENT_HOSTNAME = "cryostat.agent.hostname";
    public static final String CRYOSTAT_AGENT_APP_JMX_PORT = "cryostat.agent.app.jmx.port";
    public static final String CRYOSTAT_AGENT_REGISTRATION_RETRY_MS = "cryostat.agent.registration.retry-ms";
    public static final String CRYOSTAT_AGENT_REGISTRATION_CHECK_MS = "cryostat.agent.registration.check-ms";
    public static final String CRYOSTAT_AGENT_REGISTRATION_JMX_IGNORE = "cryostat.agent.registration.jmx.ignore";
    public static final String CRYOSTAT_AGENT_REGISTRATION_JMX_USE_CALLBACK_HOST = "cryostat.agent.registration.jmx.use-callback-host";
    public static final String CRYOSTAT_AGENT_EXIT_SIGNALS = "cryostat.agent.exit.signals";
    public static final String CRYOSTAT_AGENT_EXIT_DEREGISTRATION_TIMEOUT_MS = "cryostat.agent.exit.deregistration.timeout-ms";
    public static final String CRYOSTAT_AGENT_HARVESTER_PERIOD_MS = "cryostat.agent.harvester.period-ms";
    public static final String CRYOSTAT_AGENT_HARVESTER_TEMPLATE = "cryostat.agent.harvester.template";
    public static final String CRYOSTAT_AGENT_HARVESTER_MAX_FILES = "cryostat.agent.harvester.max-files";
    public static final String CRYOSTAT_AGENT_HARVESTER_UPLOAD_TIMEOUT_MS = "cryostat.agent.harvester.upload.timeout-ms";
    public static final String CRYOSTAT_AGENT_HARVESTER_EXIT_MAX_AGE_MS = "cryostat.agent.harvester.exit.max-age-ms";
    public static final String CRYOSTAT_AGENT_HARVESTER_EXIT_MAX_SIZE_B = "cryostat.agent.harvester.exit.max-size-b";
    public static final String CRYOSTAT_AGENT_HARVESTER_MAX_AGE_MS = "cryostat.agent.harvester.max-age-ms";
    public static final String CRYOSTAT_AGENT_HARVESTER_MAX_SIZE_B = "cryostat.agent.harvester.max-size-b";
    public static final String CRYOSTAT_AGENT_HARVESTER_AUTOANALYZE = "cryostat.agent.harvester.autoanalyze";
    public static final String CRYOSTAT_AGENT_SMART_TRIGGER_DEFINITIONS = "cryostat.agent.smart-trigger.definitions";
    public static final String CRYOSTAT_AGENT_SMART_TRIGGER_EVALUATION_PERIOD_MS = "cryostat.agent.smart-trigger.evaluation.period-ms";
    public static final String CRYOSTAT_AGENT_SMART_TRIGGER_CONFIG_PATH = "cryostat.agent.smart-trigger.config.path";
    public static final String CRYOSTAT_AGENT_CALLBACK_SCHEME = "cryostat.agent.callback.scheme";
    public static final String CRYOSTAT_AGENT_CALLBACK_HOST_NAME = "cryostat.agent.callback.host-name";
    public static final String CRYOSTAT_AGENT_CALLBACK_DOMAIN_NAME = "cryostat.agent.callback.domain-name";
    public static final String CRYOSTAT_AGENT_CALLBACK_PORT = "cryostat.agent.callback.port";
    public static final String CRYOSTAT_AGENT_API_WRITES_ENABLED = "cryostat.agent.api.writes-enabled";
    public static final String CRYOSTAT_AGENT_FLEET_SAMPLING_RATIO = "cryostat.agent.fleet-sampling-ratio";

    @Provides
    @Singleton
    public static Config provideConfig() {
        ArrayList<Pair> fns = new ArrayList<Pair>();
        fns.add(Pair.of((Object)"Simple", ConfigProvider::getConfig));
        Function<Callable, Callable> clConfigLoader = cl -> () -> {
            ClassLoader loader;
            try {
                loader = AccessController.doPrivileged(() -> (ClassLoader)cl.call());
            }
            catch (Exception e) {
                log.warn("ClassLoader AccessController failure - is this JVM too new to have the AccessController and SecurityManager?", (Throwable)e);
                loader = (ClassLoader)cl.call();
            }
            return ConfigProvider.getConfig((ClassLoader)loader);
        };
        fns.add(Pair.of((Object)"ResourcesUtil ClassLoader", (Object)clConfigLoader.apply(ResourcesUtil::getClassLoader)));
        fns.add(Pair.of((Object)"Config Class ClassLoader", (Object)clConfigLoader.apply(Config.class::getClassLoader)));
        fns.add(Pair.of((Object)"Agent JAR URL ClassLoader", (Object)clConfigLoader.apply(() -> new URLClassLoader(new URL[]{Agent.selfJarLocation().toURL()}))));
        Config config = null;
        for (Pair fn : fns) {
            try {
                log.trace("Testing classloader \"{}\" for {} property", fn.getLeft(), (Object)CRYOSTAT_AGENT_CONFIG_LOADABLE);
                Config candidate = (Config)((Callable)fn.getRight()).call();
                if (!((Boolean)candidate.getValue(CRYOSTAT_AGENT_CONFIG_LOADABLE, Boolean.TYPE)).booleanValue()) {
                    log.warn("{} was false. Assuming that this means the {} classloader cannot be used to load properties. Do not override this configuration property with a blank or false value!", (Object)CRYOSTAT_AGENT_CONFIG_LOADABLE, fn.getLeft());
                    continue;
                }
                config = candidate;
                break;
            }
            catch (Exception e) {
                config = null;
                log.debug(String.format("Failed to load config from \"%s\" supplier", fn.getLeft()), (Throwable)e);
            }
        }
        if (config == null || !((Boolean)config.getValue(CRYOSTAT_AGENT_CONFIG_LOADABLE, Boolean.TYPE)).booleanValue()) {
            log.error("Unable to load configuration from any classloader source!");
        }
        return config;
    }

    @Provides
    @Named(value="cryostat.agent.baseuri-range")
    public static URIRange provideUriRange(Config config) {
        return URIRange.fromString((String)config.getValue(CRYOSTAT_AGENT_BASEURI_RANGE, String.class));
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.baseuri")
    public static URI provideCryostatAgentBaseUri(Config config) {
        return (URI)config.getValue(CRYOSTAT_AGENT_BASEURI, URI.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat-agent-callback-candidates")
    public static List<CallbackCandidate> provideCryostatAgentCallback(Config config) {
        List<CallbackCandidate> callbacks = ConfigModule.buildCallbacksFromComponents(config);
        if (!callbacks.isEmpty()) {
            return callbacks;
        }
        return List.of(CallbackCandidate.from((URI)config.getValue(CRYOSTAT_AGENT_CALLBACK, URI.class)));
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.realm")
    public static String provideCryostatAgentRealm(Config config, @Named(value="cryostat.agent.app.name") String appName) {
        return config.getOptionalValue(CRYOSTAT_AGENT_REALM, String.class).orElse(appName);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.authorization")
    public static Supplier<Optional<String>> provideCryostatAgentAuthorization(Config config, AuthorizationType authorizationType, @Named(value="cryostat.agent.authorization.value") Optional<String> authorizationValue) {
        Optional opt = config.getOptionalValue(CRYOSTAT_AGENT_AUTHORIZATION, String.class);
        return () -> opt.or(() -> authorizationValue.map(authorizationType::apply));
    }

    @Provides
    @Singleton
    public static AuthorizationType provideCryostatAgentAuthorizationType(Config config) {
        return AuthorizationType.fromString((String)config.getValue(CRYOSTAT_AGENT_AUTHORIZATION_TYPE, String.class));
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.authorization.value")
    public static Optional<String> provideCryostatAgentAuthorizationValue(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_AUTHORIZATION_VALUE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.trust-all")
    public static boolean provideCryostatAgentWebclientTrustAll(Config config) {
        return (Boolean)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUST_ALL, Boolean.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.verify-hostname")
    public static boolean provideCryostatAgentWebclientVerifyHostname(Config config) {
        return (Boolean)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_VERIFY_HOSTNAME, Boolean.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.connect.timeout-ms")
    public static int provideCryostatAgentWebclientConnectTimeoutMs(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_CONNECT_TIMEOUT_MS, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.response.timeout-ms")
    public static int provideCryostatAgentWebclientResponseTimeoutMs(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_RESPONSE_TIMEOUT_MS, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.truststore.path")
    public static Optional<String> provideCryostatAgentWebclientTlsTruststorePath(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PATH, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.truststore.pass.file")
    public static Optional<BytePass> provideCryostatAgentWebclientTlsTruststorePassFromFile(Config config) {
        Optional<BytePass> optional;
        Optional truststorePassFile = config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PASS_FILE, String.class);
        if (truststorePassFile.isEmpty()) {
            return Optional.empty();
        }
        FileInputStream passFile = new FileInputStream((String)truststorePassFile.get());
        try {
            byte[] pass = passFile.readAllBytes();
            Optional<BytePass> bytePass = Optional.of(new BytePass(pass));
            Arrays.fill(pass, (byte)0);
            optional = bytePass;
        }
        catch (Throwable throwable) {
            try {
                try {
                    passFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        passFile.close();
        return optional;
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.truststore.pass-charset")
    public static String provideCryostatAgentWebclientTlsTruststorePassCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PASS_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.truststore.pass")
    public static Optional<BytePass> provideCryostatAgentWebclientTlsTruststorePass(Config config, @Named(value="cryostat.agent.webclient.tls.truststore.pass.file") Optional<BytePass> truststorePass, @Named(value="cryostat.agent.webclient.tls.truststore.pass-charset") String passCharset) {
        Optional opt = config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_PASS, String.class);
        if (opt.isEmpty()) {
            return truststorePass;
        }
        return Optional.of(new BytePass((String)opt.get(), passCharset));
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.truststore.type")
    public static String provideCryostatAgentWebclientTlsTruststoreType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.truststore.cert")
    public static List<TruststoreConfig> provideCryostatAgentWecblientTlsTruststoreCerts(Config config, @Named(value="cryostat.agent.webclient.tls.truststore.pass") Optional<BytePass> truststorePass, @Named(value="cryostat.agent.webclient.tls.truststore.path") Optional<String> truststorePath) {
        HashMap truststoreBuilders = new HashMap();
        ArrayList<TruststoreConfig> truststoreConfigs = new ArrayList<TruststoreConfig>();
        if (!truststorePass.isEmpty() || !truststorePath.isEmpty()) {
            return truststoreConfigs;
        }
        StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(e -> e.startsWith(CRYOSTAT_AGENT_WEBCLIENT_TLS_TRUSTSTORE_CERTS)).forEach(name -> {
            Matcher matcher = CRYOSTAT_AGENT_TRUSTSTORE_PATTERN.matcher((CharSequence)name);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Invalid truststore config property name format: \"%s\". Make sure the config property matches the following pattern: 'cryostat.agent.webclient.tls.truststore.cert[CERT_NUMBER].CERT_PROPERTY'", name));
            }
            int truststoreNumber = Integer.parseInt(matcher.group("index"));
            String configProp = matcher.group("property");
            TruststoreConfig.Builder truststoreBuilder = truststoreBuilders.computeIfAbsent(truststoreNumber, k -> new TruststoreConfig.Builder());
            String value = (String)config.getValue(name, String.class);
            switch (configProp) {
                case "alias": {
                    truststoreBuilder = truststoreBuilder.withAlias(value);
                    break;
                }
                case "path": {
                    truststoreBuilder = truststoreBuilder.withPath(value);
                    break;
                }
                case "type": {
                    truststoreBuilder = truststoreBuilder.withType(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Truststore config only includes alias, path, and type. Rename this config property: %s", name));
                }
            }
        });
        for (TruststoreConfig.Builder builder : truststoreBuilders.values()) {
            try {
                truststoreConfigs.add(builder.build());
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
        }
        return truststoreConfigs;
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.cert.path")
    public static Optional<String> provideCryostatAgentWebclientTlsClientAuthCertPath(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_CERT_PATH, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.cert.type")
    public static String provideCryostatAgentWebclientTlsClientAuthCertType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_CERT_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.cert.alias")
    public static String provideCryostatAgentWebclientTlsClientAuthCertAlias(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_CERT_ALIAS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.path")
    public static Optional<String> provideCryostatAgentWebclientTlsClientAuthKeyPath(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PATH, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.type")
    public static String provideCryostatAgentWebclientTlsClientAuthKeyType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.charset")
    public static String provideCryostatAgentWebclientTlsClientAuthKeyCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.encoding")
    public static String provideCryostatAgentWebclientTlsClientAuthKeyEncoding(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_ENCODING, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.pass.file")
    public static Optional<String> provideCryostatAgentWebclientTlsClientAuthKeyPassFile(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PASS_FILE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.pass-charset")
    public static String provideCryostatAgentWebclientTlsClientAuthKeyPassCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_PASS_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key.pass")
    public static Optional<String> provideCryostatAgentWebclientTlsClientAuthKeyPass(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.pass.file")
    public static Optional<String> provideCryostatAgentWebclientTlsClientAuthKeystorePassFile(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS_FILE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.pass-charset")
    public static String provideCryostatAgentWebclientTlsClientAuthKeystorePassCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.pass")
    public static Optional<String> provideCryostatAgentWebclientTlsClientAuthKeystorePass(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_PASS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.keystore.type")
    public static String provideCryostatAgentWebclientTlsClientAuthKeystoreType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEYSTORE_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.client-auth.key-manager.type")
    public static String provideCryostatAgentWebclientTlsClientAuthKeyManagerType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_CLIENT_AUTH_KEY_MANAGER_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.response.retry-count")
    public static int provideCryostatAgentWebclientResponseRetryCount(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_RESPONSE_RETRY_COUNT, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.host")
    public static String provideCryostatAgentWebserverHost(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_HOST, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.port")
    public static int provideCryostatAgentWebserverPort(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_WEBSERVER_PORT, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.version")
    public static String provideCryostatAgentWebclientTlsVersion(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_VERSION, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.version")
    public static String provideCryostatAgentWebserverTlsVersion(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_VERSION, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.keystore.pass")
    public static Optional<String> provideCryostatAgentWebserverTlsKeyStorePass(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_PASS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.keystore.pass-charset")
    public static String provideCryostatAgentWebserverTlsKeyStorePassCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_PASS_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.keystore.file")
    public static Optional<String> provideCryostatAgentWebserverTlsKeyStoreFile(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_FILE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.keystore.type")
    public static String provideCryostatAgentWebserverTlsKeyStoreType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEYSTORE_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.alias")
    public static String provideCryostatAgentWebserverTlsKeyAlias(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_ALIAS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.path")
    public static Optional<String> provideCryostatAgentWebserverTlsKeyPath(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PATH, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.charset")
    public static String provideCryostatAgentWebserverTlsKeyCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.encoding")
    public static String provideCryostatAgentWebserverTlsKeyEncoding(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_ENCODING, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.type")
    public static String provideCryostatAgentWebserverTlsKeyType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.pass.file")
    public static Optional<String> provideCryostatAgentWebserverTlsKeyPassFile(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PASS_FILE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.pass-charset")
    public static String provideCryostatAgentWebserverTlsKeyPassCharset(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PASS_CHARSET, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.key.pass")
    public static Optional<String> provideCryostatAgentWebserverTlsKeyPass(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBSERVER_TLS_KEY_PASS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.cert.alias")
    public static String provideCryostatAgentWebserverTlsCertAlias(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_CERT_ALIAS, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.cert.file")
    public static Optional<String> provideCryostatAgentWebserverTlsCertFile(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_WEBSERVER_TLS_CERT_FILE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.tls.cert.type")
    public static String provideCryostatAgentWebserverTlsCertType(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_TLS_CERT_TYPE, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.credentials.user")
    public static String provideCryostatAgentWebserverCredentialsUser(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_CREDENTIALS_USER, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.credentials.pass.hash-function")
    public static MessageDigest provideCryostatAgentWebserverCredentialsPassHashFunction(Config config) {
        try {
            String id = (String)config.getValue(CRYOSTAT_AGENT_WEBSERVER_CREDENTIALS_PASS_HASH_FUNCTION, String.class);
            return MessageDigest.getInstance(id);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webserver.credentials.pass.length")
    public static int provideCryostatAgentWebserverCredentialsPassLength(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_WEBSERVER_CREDENTIALS_PASS_LENGTH, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.instance-id")
    public static String provideCryostatAgentInstanceId(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_INSTANCE_ID, String.class).orElseGet(() -> UUID.randomUUID().toString());
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.app.name")
    public static String provideCryostatAgentAppName(Config config) {
        return (String)config.getValue(CRYOSTAT_AGENT_APP_NAME, String.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.hostname")
    public static String provideCryostatAgentHostname(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_HOSTNAME, String.class).orElseGet(() -> {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                log.error("Unable to determine own hostname", (Throwable)uhe);
                return null;
            }
        });
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.app.jmx.port")
    public static int provideCryostatAgentAppJmxPort(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_APP_JMX_PORT, Integer.TYPE).orElse(Integer.valueOf(System.getProperty("com.sun.management.jmxremote.port", "-1")));
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.registration.retry-ms")
    public static int provideCryostatAgentRegistrationRetryMs(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_REGISTRATION_RETRY_MS, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.registration.check-ms")
    public static int provideCryostatAgentRegistrationCheckMs(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_REGISTRATION_CHECK_MS, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.registration.jmx.ignore")
    public static boolean provideCryostatAgentRegistrationJmxIgnore(Config config) {
        return (Boolean)config.getValue(CRYOSTAT_AGENT_REGISTRATION_JMX_IGNORE, Boolean.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.registration.jmx.use-callback-host")
    public static boolean provideCryostatAgentRegistrationJmxUseCallbackHost(Config config) {
        return (Boolean)config.getValue(CRYOSTAT_AGENT_REGISTRATION_JMX_USE_CALLBACK_HOST, Boolean.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.period-ms")
    public static long provideCryostatAgentHarvesterPeriod(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_HARVESTER_PERIOD_MS, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.template")
    public static String provideCryostatAgentHarvesterTemplate(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_HARVESTER_TEMPLATE, String.class).orElse("");
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.max-files")
    public static int provideCryostatAgentHarvesterMaxFiles(Config config) {
        return (Integer)config.getValue(CRYOSTAT_AGENT_HARVESTER_MAX_FILES, Integer.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.upload.timeout-ms")
    public static long provideCryostatAgentHarvesterUploadTimeoutMs(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_HARVESTER_UPLOAD_TIMEOUT_MS, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.exit.max-age-ms")
    public static long provideCryostatAgentHarvesterExitMaxAge(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_HARVESTER_EXIT_MAX_AGE_MS, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.exit.max-size-b")
    public static long provideCryostatAgentHarvesterExitMaxSize(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_HARVESTER_EXIT_MAX_SIZE_B, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.max-age-ms")
    public static long provideCryostatAgentHarvesterMaxAge(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_HARVESTER_MAX_AGE_MS, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.max-size-b")
    public static long provideCryostatAgentHarvesterMaxSize(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_HARVESTER_MAX_SIZE_B, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.harvester.autoanalyze")
    public static boolean provideCryostatAgentHarvesterAutoanalyze(Config config) {
        return (Boolean)config.getValue(CRYOSTAT_AGENT_HARVESTER_AUTOANALYZE, Boolean.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.exit.signals")
    public static List<String> provideCryostatAgentExitSignals(Config config) {
        return Arrays.asList(((String)config.getValue(CRYOSTAT_AGENT_EXIT_SIGNALS, String.class)).split(","));
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.exit.deregistration.timeout-ms")
    public static long provideCryostatAgentExitDeregistrationTimeoutMs(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_EXIT_DEREGISTRATION_TIMEOUT_MS, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.smart-trigger.definitions")
    public static List<String> provideCryostatSmartTriggerDefinitions(Config config) {
        return config.getOptionalValues(CRYOSTAT_AGENT_SMART_TRIGGER_DEFINITIONS, String.class).orElse(List.of());
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.smart-trigger.evaluation.period-ms")
    public static long provideCryostatSmartTriggerEvaluationPeriodMs(Config config) {
        return (Long)config.getValue(CRYOSTAT_AGENT_SMART_TRIGGER_EVALUATION_PERIOD_MS, Long.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.smart-trigger.config.path")
    public static Optional<Path> provideCryostatSmartTriggerConfigFiles(Config config) {
        return config.getOptionalValue(CRYOSTAT_AGENT_SMART_TRIGGER_CONFIG_PATH, Path.class);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.webclient.tls.required")
    public static boolean provideCryostatAgentTlsEnabled(Config config) {
        return (Boolean)config.getValue(CRYOSTAT_AGENT_WEBCLIENT_TLS_REQUIRED, Boolean.TYPE);
    }

    @Provides
    @Singleton
    @Named(value="cryostat.agent.fleet-sampling-ratio")
    public static double provideCryostatAgentFleetSamplingRatio(Config config) {
        return (Double)config.getValue(CRYOSTAT_AGENT_FLEET_SAMPLING_RATIO, Double.TYPE);
    }

    private static List<CallbackCandidate> buildCallbacksFromComponents(Config config) {
        Optional scheme = config.getOptionalValue(CRYOSTAT_AGENT_CALLBACK_SCHEME, String.class);
        Optional hostNames = config.getOptionalValue(CRYOSTAT_AGENT_CALLBACK_HOST_NAME, String[].class);
        Optional domainName = config.getOptionalValue(CRYOSTAT_AGENT_CALLBACK_DOMAIN_NAME, String.class);
        Optional port = config.getOptionalValue(CRYOSTAT_AGENT_CALLBACK_PORT, Integer.class);
        if (scheme.isPresent() && hostNames.isPresent() && domainName.isPresent() && port.isPresent()) {
            return Arrays.asList((String[])hostNames.get()).stream().map(hostname -> new CallbackCandidate((String)scheme.get(), (String)hostname, (String)domainName.get(), (Integer)port.get())).collect(Collectors.toList());
        }
        return List.of();
    }

    public static class CallbackCandidate {
        private final String scheme;
        private final String hostname;
        private final String domainName;
        private final int port;

        public static CallbackCandidate from(URI uri) {
            String domain;
            String host;
            String hostname = uri.getHost();
            if (hostname.contains(".")) {
                host = hostname.substring(0, hostname.indexOf(46));
                domain = hostname.substring(hostname.indexOf(46) + 1);
            } else {
                host = hostname;
                domain = null;
            }
            return new CallbackCandidate(uri.getScheme(), host, domain, uri.getPort());
        }

        public CallbackCandidate(String scheme, String hostname, String domainName, int port) {
            this.scheme = scheme.strip();
            this.hostname = hostname.strip();
            this.domainName = domainName == null ? null : domainName.strip();
            this.port = port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return Objects.hash(this.scheme, this.hostname, this.domainName, this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallbackCandidate other = (CallbackCandidate)obj;
            return Objects.equals(this.scheme, other.scheme) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.domainName, other.domainName) && this.port == other.port;
        }

        public String toString() {
            return "CallbackCandidate [scheme=" + this.scheme + ", hostname=" + this.hostname + ", domainName=" + this.domainName + ", port=" + this.port + "]";
        }
    }

    public static class BytePass {
        private final byte[] buf;

        public BytePass(byte[] s) {
            this.buf = Arrays.copyOf(s, s.length);
        }

        public BytePass(String s, String charset) {
            this.buf = Arrays.copyOf(s.getBytes(Charset.forName(charset)), s.length());
        }

        public byte[] get() {
            return Arrays.copyOf(this.buf, this.buf.length);
        }

        public void clear() {
            Arrays.fill(this.buf, (byte)0);
        }
    }

    public static enum URIRange {
        LOOPBACK(u -> URIRange.check(u, u2 -> true, InetAddress::isLoopbackAddress)),
        LINK_LOCAL(u -> URIRange.check(u, u2 -> StringUtils.isNotBlank(u2.getHost()), InetAddress::isLinkLocalAddress)),
        SITE_LOCAL(u -> URIRange.check(u, u2 -> StringUtils.isNotBlank(u2.getHost()), InetAddress::isSiteLocalAddress)),
        DNS_LOCAL(u -> StringUtils.isNotBlank(u.getHost()) && (u.getHost().endsWith(".local") || u.getHost().endsWith(".localhost"))),
        PUBLIC(u -> true);

        private final Predicate<URI> fn;

        private URIRange(Predicate<URI> fn) {
            this.fn = fn;
        }

        private static boolean check(URI uri, Predicate<URI> f1, Predicate<InetAddress> f2) {
            try {
                return f1.test(uri) && f2.test(InetAddress.getByName(uri.getHost()));
            }
            catch (UnknownHostException uhe) {
                log.error("Failed to resolve host", (Throwable)uhe);
                return false;
            }
        }

        private boolean test(URI uri) {
            return this.fn.test(uri);
        }

        public boolean validate(URI uri) {
            List ranges = List.of(URIRange.values()).stream().filter(r -> r.ordinal() <= this.ordinal()).collect(Collectors.toList());
            boolean match = false;
            for (URIRange range : ranges) {
                match |= range.test(uri);
            }
            return match;
        }

        public static URIRange fromString(String s) {
            for (URIRange r : URIRange.values()) {
                if (!r.name().equalsIgnoreCase(s)) continue;
                return r;
            }
            return SITE_LOCAL;
        }
    }
}

