/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import io.cryostat.agent.ConfigModule;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.http.client.utils.URIBuilder;
import org.projectnessie.cel.Library;
import org.projectnessie.cel.extension.StringsLib;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.cel.tools.ScriptHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackResolver {
    private static final String HOST_SCRIPT_PATTERN_STRING = "(?<host>[A-Za-z0-9-.]+)(?:\\[(?<script>.+)\\])?";
    private static final Pattern HOST_SCRIPT_PATTERN = Pattern.compile("(?<host>[A-Za-z0-9-.]+)(?:\\[(?<script>.+)\\])?");
    private final ScriptHost scriptHost;
    private final List<ConfigModule.CallbackCandidate> callbacks;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public CallbackResolver(ScriptHost scriptHost, Collection<ConfigModule.CallbackCandidate> callbacks) {
        this.scriptHost = scriptHost;
        this.callbacks = new ArrayList<ConfigModule.CallbackCandidate>(callbacks);
    }

    public URI determineSelfCallback() throws UnknownHostException {
        Optional<URI> resolvedCallback = ((Stream)this.callbacks.stream().sequential()).map(this::tryResolveCallback).filter(Objects::nonNull).findFirst();
        URI callback = resolvedCallback.orElseThrow(() -> new UnknownHostException("Failed to resolve hostname, consider disabling hostname verification in Cryostat for the agent callback"));
        this.log.debug("Using {} as callback", (Object)callback);
        return callback;
    }

    private URI tryResolveCallback(ConfigModule.CallbackCandidate cb) {
        try {
            String transformedHostname = this.transformHostname(cb.getHostname());
            String host = cb.getDomainName() == null ? transformedHostname : String.format("%s.%s", transformedHostname, cb.getDomainName());
            host = this.tryResolveHostname(host);
            return new URIBuilder().setScheme(cb.getScheme()).setHost(host).setPort(cb.getPort()).build();
        }
        catch (URISyntaxException e) {
            this.log.debug(String.format("Callback candidate %s was invalid", cb), (Throwable)e);
            return null;
        }
        catch (UnknownHostException e) {
            this.log.debug(String.format("Callback candidate %s could not be resolved", cb), (Throwable)e);
            return null;
        }
    }

    private String transformHostname(String hostName) {
        Matcher m = HOST_SCRIPT_PATTERN.matcher(hostName);
        if (!m.matches()) {
            throw new RuntimeException(String.format("Invalid hostname argument encountered: %s. Expected format: \"hostname\" or \"hostname[cel-script]\".", hostName));
        }
        if (m.group("script") == null) {
            return m.group("host");
        }
        return this.evaluateHostnameScript(m.group("script"), m.group("host"));
    }

    private String evaluateHostnameScript(String scriptText, String hostname) {
        try {
            Script script = this.scriptHost.buildScript("\"" + hostname + "\"." + scriptText).withLibraries(new Library[]{new StringsLib()}).build();
            HashMap args = new HashMap();
            return (String)script.execute(String.class, args);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Failed to execute provided CEL script", e);
        }
    }

    private String tryResolveHostname(String hostname) throws UnknownHostException {
        this.log.debug("Attempting to resolve {}", (Object)hostname);
        InetAddress addr = InetAddress.getByName(hostname);
        this.log.debug("Resolved {} to {}", (Object)hostname, (Object)addr.getHostAddress());
        return hostname;
    }
}

