/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import io.cryostat.agent.util.ResourcesUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    private static Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private static final String RESOURCE_LOCATION = "META-INF/gitinfo";
    private final GitInfo gitinfo = new GitInfo();

    public GitInfo getGitInfo() {
        return this.gitinfo;
    }

    public static class GitInfo {
        public String getHash() {
            String string;
            BufferedReader br = new BufferedReader(new InputStreamReader(ResourcesUtil.getResourceAsStream(BuildInfo.RESOURCE_LOCATION), StandardCharsets.UTF_8));
            try {
                string = br.lines().findFirst().orElseThrow(() -> new IllegalStateException(String.format("Resource file %s is empty", BuildInfo.RESOURCE_LOCATION))).trim();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Version retrieval exception", (Throwable)e);
                    return "unknown";
                }
            }
            br.close();
            return string;
        }
    }
}

