/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import io.cryostat.agent.util.StringUtils;
import java.lang.instrument.Instrumentation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

class AgentArgs {
    private static final String DELIMITER = "!";
    private final Instrumentation instrumentation;
    private final Map<String, String> properties;
    private final String smartTriggers;

    public AgentArgs(Instrumentation instrumentation, Map<String, String> properties, String smartTriggers) {
        this.instrumentation = instrumentation;
        this.properties = Optional.ofNullable(properties).orElse(Collections.emptyMap());
        this.smartTriggers = StringUtils.defaultValue(smartTriggers, "");
    }

    public AgentArgs(Map<String, String> properties, String smartTriggers) {
        this(null, properties, smartTriggers);
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getSmartTriggers() {
        return this.smartTriggers;
    }

    public static AgentArgs from(Instrumentation instrumentation, String agentmainArg) {
        Map<String, String> properties = new HashMap<String, String>();
        String smartTriggers = "";
        if (StringUtils.isNotBlank(agentmainArg)) {
            ArrayDeque<String> parts = new ArrayDeque<String>(Arrays.asList(agentmainArg.split(DELIMITER)));
            String props = (String)parts.poll();
            if (StringUtils.isNotBlank(props)) {
                properties = Arrays.asList(props.split(",")).stream().map(e -> {
                    int idx = e.indexOf(61);
                    return Pair.of((Object)e.substring(0, idx), (Object)e.substring(idx + 1));
                }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            }
            smartTriggers = (String)parts.poll();
        }
        return new AgentArgs(instrumentation, properties, smartTriggers);
    }

    public String toAgentMain() {
        ArrayList<String> parts = new ArrayList<String>();
        if (!this.properties.isEmpty()) {
            parts.add(String.join((CharSequence)",", this.properties.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.toList())));
        }
        if (StringUtils.isNotBlank(this.smartTriggers)) {
            parts.add(this.smartTriggers);
        }
        return String.join((CharSequence)DELIMITER, parts);
    }
}

