/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import dagger.Component;
import io.cryostat.agent.AgentArgs;
import io.cryostat.agent.BuildInfo;
import io.cryostat.agent.ConfigModule;
import io.cryostat.agent.DaggerAgent_Client;
import io.cryostat.agent.MainModule;
import io.cryostat.agent.Registration;
import io.cryostat.agent.VersionInfo;
import io.cryostat.agent.WebServer;
import io.cryostat.agent.harvest.Harvester;
import io.cryostat.agent.insights.InsightsAgentHelper;
import io.cryostat.agent.model.PluginInfo;
import io.cryostat.agent.shaded.ShadeLogger;
import io.cryostat.agent.triggers.TriggerEvaluator;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@CommandLine.Command(name="CryostatAgent", mixinStandardHelpOptions=true, showAtFileInUsageHelp=true, versionProvider=VersionProvider.class, description={"Launcher for Cryostat Agent to self-inject and dynamically attach to workload JVMs"})
public class Agent
implements Callable<Integer>,
Consumer<AgentArgs> {
    private static final AtomicBoolean needsCleanup = new AtomicBoolean(true);
    private static final String ALL_PIDS = "*";
    static final String AUTO_ATTACH_PID = "0";
    @CommandLine.Parameters(index="0", defaultValue="0", arity="0..1", description={"The PID to attach to and attempt to self-inject the Cryostat Agent. If not specified, the Agent will look to find exactly one candidate and attach to that, failing if none or more than one are found. Otherwise, this should be a process ID, or the '*' wildcard to request the Agent attempt to attach to all discovered JVMs."})
    private String pid;
    @CommandLine.Option(names={"-D", "--property"}, description={"Optional property definitions to supply to the injected Agent copies to add or override property definitions once the Agent is running in the workload JVM. These should be specified as key=value pairs, ex. -Dcryostat.agent.baseuri=http://cryostat.service.local . May be specified more than once."})
    private Map<String, String> properties;
    @CommandLine.Option(names={"--smartTrigger"}, description={"Smart Triggers definition. May be specified more than once."})
    private List<String> smartTriggers;

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new Agent()).execute(args);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws IOException, AttachNotSupportedException, AgentInitializationException, AgentLoadException, URISyntaxException {
        List<String> pids = Agent.getAttachPid(this.pid);
        if (pids.isEmpty()) {
            throw new IllegalStateException("No candidate JVM PIDs");
        }
        String agentmainArg = new AgentArgs(this.properties, String.join((CharSequence)",", this.smartTriggers != null ? this.smartTriggers : List.of())).toAgentMain();
        for (String pid : pids) {
            VirtualMachine vm = VirtualMachine.attach(pid);
            ShadeLogger.getAnonymousLogger().fine(String.format("Injecting agent into PID %s", pid));
            try {
                vm.loadAgent(Path.of(Agent.selfJarLocation()).toAbsolutePath().toString(), agentmainArg);
            }
            finally {
                vm.detach();
            }
        }
        return 0;
    }

    public static void premain(String args, Instrumentation instrumentation) {
        Agent.agentmain(args, instrumentation);
    }

    public static void agentmain(String args, Instrumentation instrumentation) {
        AgentArgs aa = AgentArgs.from(instrumentation, args);
        aa.getProperties().forEach((k, v) -> System.setProperty(k, v));
        Agent agent = new Agent();
        Thread t = new Thread(() -> agent.accept(aa));
        t.setDaemon(true);
        t.setName("cryostat-agent-main");
        t.start();
    }

    private static List<String> getAttachPid(String pidSpec) {
        Predicate<VirtualMachineDescriptor> vmFilter;
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (ALL_PIDS.equals(pidSpec)) {
            vmFilter = vmd -> true;
        } else if (pidSpec == null || AUTO_ATTACH_PID.equals(pidSpec)) {
            if (vms.size() > 2) {
                throw new IllegalStateException(String.format("Too many available virtual machines. Auto-attach only progresses if there is one candidate. VMs: %s", vms));
            }
            if (vms.size() < 2) {
                throw new IllegalStateException(String.format("Too few available virtual machines. Auto-attach only progresses if there is one candidate. VMs: %s", vms));
            }
            long ownId = ProcessHandle.current().pid();
            vmFilter = vmd -> !Objects.equals(String.valueOf(ownId), vmd.id());
        } else {
            vmFilter = vmd -> pidSpec.equals(vmd.id());
        }
        return vms.stream().filter(vmFilter).peek(vmd -> ShadeLogger.getAnonymousLogger().fine(String.format("Attaching to VM: %s %s", vmd.displayName(), vmd.id()))).map(VirtualMachineDescriptor::id).collect(Collectors.toList());
    }

    static URI selfJarLocation() throws URISyntaxException {
        return Agent.class.getProtectionDomain().getCodeSource().getLocation().toURI();
    }

    @Override
    public void accept(AgentArgs args) {
        block7: {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(args.getProperties());
            properties.put("build.git.commit-hash", new BuildInfo().getGitInfo().getHash());
            VersionInfo.Semver agentVersion = VersionInfo.Semver.UNKNOWN;
            Pair serverVersionRange = Pair.of((Object)VersionInfo.Semver.UNKNOWN, (Object)VersionInfo.Semver.UNKNOWN);
            IOException propsIoe = null;
            try {
                VersionInfo versionInfo = VersionInfo.load();
                serverVersionRange = Pair.of((Object)versionInfo.getServerMin(), (Object)versionInfo.getServerMax());
                agentVersion = versionInfo.getAgentVersion();
                properties.putAll(versionInfo.asMap());
            }
            catch (IOException ioe) {
                propsIoe = ioe;
            }
            properties.forEach((k, v) -> System.setProperty(k, v));
            Logger log = LoggerFactory.getLogger(this.getClass());
            if (propsIoe != null) {
                log.warn("Unable to read versions.properties file", (Throwable)propsIoe);
            }
            properties.forEach((k, v) -> log.trace("Set system property {} = {}", k, v));
            log.debug("Cryostat Agent version {} (for Cryostat server version range [{}, {}) ) starting...", new Object[]{agentVersion, serverVersionRange.getLeft(), serverVersionRange.getRight()});
            AgentExitHandler agentExitHandler = null;
            try {
                Client client = DaggerAgent_Client.builder().build();
                boolean sample = client.fleetSampleValue() < client.fleetSamplingRatio();
                log.trace("fleetSampleValue: {} , fleetSampleRatio: {}", (Object)client.fleetSampleValue(), (Object)client.fleetSamplingRatio());
                if (!sample) {
                    log.debug("Cryostat Agent aborting startup - fleet sample value {} is greater than the configured sampling ratio {}", (Object)client.fleetSampleValue(), (Object)client.fleetSamplingRatio());
                    return;
                }
                InsightsAgentHelper insights = new InsightsAgentHelper(client.config(), args.getInstrumentation());
                URI baseUri = client.baseUri();
                ConfigModule.URIRange uriRange = client.uriRange();
                if (!uriRange.validate(baseUri)) {
                    throw new IllegalArgumentException(String.format("cryostat.agent.baseuri of \"%s\" is unacceptable with URI range \"%s\"", new Object[]{baseUri, uriRange}));
                }
                Registration registration = client.registration();
                Harvester harvester = client.harvester();
                WebServer webServer = client.webServer();
                ScheduledExecutorService executor = client.executor();
                List<String> exitSignals = client.exitSignals();
                long exitDeregistrationTimeout = client.exitDeregistrationTimeout();
                AgentExitHandler fHandler = agentExitHandler = Agent.installSignalHandlers(log, exitSignals, registration, harvester, webServer, executor, exitDeregistrationTimeout);
                Thread t = new Thread(() -> {
                    if (needsCleanup.getAndSet(false)) {
                        fHandler.performCleanup(null);
                    }
                });
                t.setName("cryostat-agent-shutdown");
                t.setDaemon(false);
                Runtime.getRuntime().addShutdownHook(t);
                registration.addRegistrationListener(evt -> {
                    switch (evt.state) {
                        case REGISTERED: {
                            log.debug("Registration state: {}", (Object)evt.state);
                            Agent.setupInsightsIfEnabled(log, insights, registration.getPluginInfo());
                            break;
                        }
                        case UNREGISTERED: 
                        case REFRESHING: 
                        case REFRESHED: 
                        case PUBLISHED: {
                            log.debug("Registration state: {}", (Object)evt.state);
                            break;
                        }
                        default: {
                            log.warn("Unknown registration state: {}", (Object)evt.state);
                        }
                    }
                });
                webServer.start();
                registration.start();
                client.triggerEvaluator().start(args.getSmartTriggers());
                log.trace("Startup complete");
            }
            catch (Exception e) {
                log.error(Agent.class.getSimpleName() + " startup failure", (Throwable)e);
                if (agentExitHandler == null) break block7;
                agentExitHandler.reset();
            }
        }
    }

    private static AgentExitHandler installSignalHandlers(Logger log, List<String> exitSignals, Registration registration, Harvester harvester, WebServer webServer, ExecutorService executor, long exitDeregistrationTimeout) {
        AgentExitHandler agentExitHandler = new AgentExitHandler(registration, harvester, webServer, executor, exitDeregistrationTimeout);
        for (String s : exitSignals) {
            Signal signal = new Signal(s);
            try {
                SignalHandler oldHandler = Signal.handle(signal, agentExitHandler);
                agentExitHandler.setOldHandler(signal, oldHandler);
            }
            catch (IllegalArgumentException iae) {
                log.warn("Unable to register signal handler for SIG" + s, (Throwable)iae);
            }
        }
        return agentExitHandler;
    }

    private static void setupInsightsIfEnabled(Logger log, InsightsAgentHelper insights, PluginInfo pluginInfo) {
        if (insights != null && insights.isInsightsEnabled(pluginInfo)) {
            try {
                insights.runInsightsAgent(pluginInfo);
                log.debug("Started Red Hat Insights client");
            }
            catch (Throwable e) {
                log.error("Unable to start Red Hat Insights client", e);
            }
        }
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() throws Exception {
            return new String[]{Agent.class.getPackage().getImplementationVersion()};
        }
    }

    private static class AgentExitHandler
    implements SignalHandler {
        private static Logger log = LoggerFactory.getLogger(AgentExitHandler.class);
        private final Map<Signal, SignalHandler> oldHandlers = new HashMap<Signal, SignalHandler>();
        private final Registration registration;
        private final Harvester harvester;
        private final WebServer webServer;
        private final ExecutorService executor;
        private final long exitDeregistrationTimeout;

        private AgentExitHandler(Registration registration, Harvester harvester, WebServer webServer, ExecutorService executor, long exitDeregistrationTimeout) {
            this.registration = Objects.requireNonNull(registration);
            this.harvester = Objects.requireNonNull(harvester);
            this.webServer = Objects.requireNonNull(webServer);
            this.executor = Objects.requireNonNull(executor);
            this.exitDeregistrationTimeout = exitDeregistrationTimeout;
        }

        void setOldHandler(Signal signal, SignalHandler oldHandler) {
            this.oldHandlers.put(signal, oldHandler);
        }

        @Override
        public void handle(Signal sig) {
            if (sig == null) {
                log.debug("'null' signal handler invoked");
            } else {
                log.debug("Caught SIG{}({})", (Object)sig.getName(), (Object)sig.getNumber());
            }
            if (needsCleanup.getAndSet(false)) {
                this.performCleanup(sig);
            }
        }

        void performCleanup(Signal sig) {
            log.trace("Performing cleanup...");
            try {
                this.harvester.exitUpload().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Exit upload failed", (Throwable)e);
            }
            finally {
                this.registration.deregister().orTimeout(this.exitDeregistrationTimeout, TimeUnit.MILLISECONDS).handle((T v, U t) -> {
                    if (t != null) {
                        log.warn("Exception during deregistration", t);
                    }
                    try {
                        log.debug("Shutting down...");
                        this.safeCall(this.webServer::stop);
                        this.safeCall(this.registration::stop);
                        this.safeCall(this.executor::shutdown);
                    }
                    finally {
                        log.debug("Shutdown complete");
                        if (sig != null) {
                            this.oldHandlers.get(sig).handle(sig);
                        }
                    }
                    return null;
                });
            }
        }

        void reset() {
            this.oldHandlers.forEach(Signal::handle);
            this.oldHandlers.clear();
        }

        private void safeCall(Runnable r) {
            try {
                r.run();
            }
            catch (Exception e) {
                log.warn("Exception during shutdown", (Throwable)e);
            }
        }
    }

    @Singleton
    @Component(modules={MainModule.class})
    static interface Client {
        public Config config();

        @Named(value="cryostat.agent.fleet-sampling-ratio")
        public double fleetSamplingRatio();

        @Named(value="CRYOSTAT_AGENT_FLEET_SAMPLE_VALUE")
        public double fleetSampleValue();

        @Named(value="cryostat.agent.baseuri")
        public URI baseUri();

        @Named(value="cryostat.agent.baseuri-range")
        public ConfigModule.URIRange uriRange();

        public WebServer webServer();

        public Registration registration();

        public Harvester harvester();

        public TriggerEvaluator triggerEvaluator();

        public ScheduledExecutorService executor();

        @Named(value="cryostat.agent.exit.signals")
        public List<String> exitSignals();

        @Named(value="cryostat.agent.exit.deregistration.timeout-ms")
        public long exitDeregistrationTimeout();

        @Component.Builder
        public static interface Builder {
            public Client build();
        }
    }
}

