/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import io.cryostat.agent.shaded.org.jboss.logging.BasicLogger;
import io.cryostat.agent.shaded.org.jboss.logging.Logger;
import io.cryostat.agent.shaded.org.jboss.logging.annotations.Cause;
import io.cryostat.agent.shaded.org.jboss.logging.annotations.Message;
import io.cryostat.agent.shaded.org.jboss.logging.annotations.MessageLogger;
import io.cryostat.agent.shaded.org.jboss.logging.annotations.ValidIdRange;
import io.cryostat.agent.shaded.org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.asn1.ASN1Exception;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=12, max=12), @ValidIdRange(min=7004, max=7024)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=12, value="Unable to load OIDs database from properties file")
    public IllegalStateException unableToLoadOidsFromPropertiesFile(@Cause Throwable var1);

    @Message(id=7004, value="Unexpected ASN.1 tag encountered")
    public ASN1Exception asnUnexpectedTag();

    @Message(id=7005, value="Unable to read X.509 certificate data")
    public ASN1Exception asnUnableToReadCertificateData(@Cause Throwable var1);

    @Message(id=7009, value="No sequence to end")
    public IllegalStateException noSequenceToEnd();

    @Message(id=7010, value="No set to end")
    public IllegalStateException noSetToEnd();

    @Message(id=7011, value="No explicitly tagged element to end")
    public IllegalStateException noExplicitlyTaggedElementToEnd();

    @Message(id=7012, value="Unexpected end of input")
    public ASN1Exception asnUnexpectedEndOfInput();

    @Message(id=7013, value="Invalid number of unused bits")
    public ASN1Exception asnInvalidNumberOfUnusedBits();

    @Message(id=7014, value="Non-zero length encountered for null type tag")
    public ASN1Exception asnNonZeroLengthForNullTypeTag();

    @Message(id=7015, value="Invalid high-tag-number form")
    public ASN1Exception asnInvalidHighTagNumberForm();

    @Message(id=7016, value="Length encoding exceeds 4 bytes")
    public ASN1Exception asnLengthEncodingExceeds4bytes();

    @Message(id=7017, value="Invalid OID character")
    public ASN1Exception asnInvalidOidCharacter();

    @Message(id=7018, value="OID must have at least 2 components")
    public ASN1Exception asnOidMustHaveAtLeast2Components();

    @Message(id=7019, value="Invalid value for first OID component; expected 0, 1, or 2")
    public ASN1Exception asnInvalidValueForFirstOidComponent();

    @Message(id=7020, value="Invalid value for second OID component; expected a value between 0 and 39 (inclusive)")
    public ASN1Exception asnInvalidValueForSecondOidComponent();

    @Message(id=7021, value="Invalid length")
    public ASN1Exception asnInvalidLength();

    @Message(id=7022, value="Unknown tag type: %d")
    public ASN1Exception asnUnknownTagType(int var1);

    @Message(id=7023, value="Unexpected character byte for printable string")
    public ASN1Exception asnUnexpectedCharacterByteForPrintableString();

    @Message(id=7024, value="Invalid length encountered for boolean type tag")
    public ASN1Exception asnInvalidLengthForBooleanTypeTag();
}

