/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.triggers;

import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.shaded.org.slf4j.Logger;
import io.cryostat.agent.shaded.org.slf4j.LoggerFactory;
import io.cryostat.agent.triggers.SmartTrigger;
import io.cryostat.agent.util.StringUtils;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TriggerParser {
    private static final String EXPRESSION_PATTERN_STRING = "\\[(.*(&&)*|(\\|\\|)*)\\]~([\\w\\-]+)(?:\\.jfc)?";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\[(.*(&&)*|(\\|\\|)*)\\]~([\\w\\-]+)(?:\\.jfc)?");
    private final FlightRecorderHelper flightRecorderHelper;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public TriggerParser(FlightRecorderHelper flightRecorderHelper) {
        this.flightRecorderHelper = flightRecorderHelper;
    }

    public List<SmartTrigger> parse(String str) {
        String[] expressions;
        ArrayList<SmartTrigger> triggers = new ArrayList<SmartTrigger>();
        if (StringUtils.isBlank(str)) {
            return triggers;
        }
        for (String s : expressions = str.split(",")) {
            Matcher m = EXPRESSION_PATTERN.matcher(s = s.replaceAll("\\s", ""));
            if (!m.matches()) continue;
            String constraintString = m.group(1);
            String templateName = m.group(4);
            if (this.flightRecorderHelper.isValidTemplate(templateName)) {
                try {
                    SmartTrigger trigger = new SmartTrigger(constraintString, templateName);
                    triggers.add(trigger);
                }
                catch (DateTimeParseException dtpe) {
                    this.log.error("Failed to parse trigger duration constraint", dtpe);
                }
                continue;
            }
            this.log.warn("Template " + templateName + " not found. Skipping trigger.");
        }
        return triggers;
    }
}

