/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.triggers;

import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import io.cryostat.agent.FlightRecorderHelper;
import io.cryostat.agent.harvest.Harvester;
import io.cryostat.agent.model.MBeanInfo;
import io.cryostat.agent.shaded.org.projectnessie.cel.checker.Decls;
import io.cryostat.agent.shaded.org.projectnessie.cel.tools.Script;
import io.cryostat.agent.shaded.org.projectnessie.cel.tools.ScriptCreateException;
import io.cryostat.agent.shaded.org.projectnessie.cel.tools.ScriptHost;
import io.cryostat.agent.shaded.org.slf4j.Logger;
import io.cryostat.agent.shaded.org.slf4j.LoggerFactory;
import io.cryostat.agent.triggers.SmartTrigger;
import io.cryostat.agent.triggers.TriggerParser;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TriggerEvaluator {
    private final ScheduledExecutorService scheduler;
    private final List<String> definitions;
    private final TriggerParser parser;
    private final ScriptHost scriptHost;
    private final FlightRecorderHelper flightRecorderHelper;
    private final Harvester harvester;
    private final long evaluationPeriodMs;
    private final ConcurrentHashMap<SmartTrigger, Script> conditionScriptCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<SmartTrigger, Script> durationScriptCache = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<SmartTrigger> triggers = new ConcurrentLinkedQueue();
    private Future<?> task;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public TriggerEvaluator(ScheduledExecutorService scheduler, ScriptHost scriptHost, List<String> definitions, TriggerParser parser, FlightRecorderHelper flightRecorderHelper, Harvester harvester, long evaluationPeriodMs) {
        this.scheduler = scheduler;
        this.definitions = Collections.unmodifiableList(definitions);
        this.parser = parser;
        this.scriptHost = scriptHost;
        this.flightRecorderHelper = flightRecorderHelper;
        this.harvester = harvester;
        this.evaluationPeriodMs = evaluationPeriodMs;
    }

    public void start(String str) {
        this.stop();
        this.parser.parse(str).forEach(this::registerTrigger);
        this.parser.parse(String.join((CharSequence)",", this.definitions)).forEach(this::registerTrigger);
        this.start();
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel(false);
        }
    }

    private void registerTrigger(SmartTrigger t) {
        this.log.trace("Registering Smart Trigger: {}", (Object)t);
        if (!this.triggers.contains(t)) {
            this.triggers.add(t);
        }
    }

    private void start() {
        this.stop();
        if (this.triggers.isEmpty()) {
            return;
        }
        this.task = this.scheduler.scheduleAtFixedRate(this::evaluate, 0L, this.evaluationPeriodMs, TimeUnit.MILLISECONDS);
    }

    private void evaluate() {
        try {
            for (SmartTrigger t : this.triggers) {
                this.log.trace("Evaluating {}", (Object)t);
                Date currentTime = new Date(System.currentTimeMillis());
                long difference = 0L;
                if (t.getTimeConditionFirstMet() != null) {
                    difference = currentTime.getTime() - t.getTimeConditionFirstMet().getTime();
                }
                switch (t.getState()) {
                    case COMPLETE: {
                        this.log.trace("Completed {} , removing", (Object)t);
                        this.triggers.remove(t);
                        this.conditionScriptCache.remove(t);
                        this.durationScriptCache.remove(t);
                        break;
                    }
                    case NEW: {
                        if (t.isSimple() && this.evaluateTriggerConstraint(t, t.getTargetDuration())) {
                            this.log.trace("Trigger {} satisfied, starting recording...", (Object)t);
                            this.startRecording(t);
                            break;
                        }
                        if (t.isSimple()) break;
                        if (this.evaluateTriggerConstraint(t, Duration.ZERO)) {
                            this.log.trace("Trigger {} satisfied, watching...", (Object)t);
                            t.setState(SmartTrigger.TriggerState.WAITING_HIGH);
                            t.setTimeConditionFirstMet(new Date(System.currentTimeMillis()));
                            break;
                        }
                        this.log.trace("Trigger {} not yet satisfied...", (Object)t);
                        t.setState(SmartTrigger.TriggerState.WAITING_LOW);
                        break;
                    }
                    case WAITING_HIGH: {
                        if (this.evaluateTriggerConstraint(t, Duration.ofMillis(difference))) {
                            this.log.trace("Trigger {} satisfied, completing...", (Object)t);
                            this.startRecording(t);
                            break;
                        }
                        if (this.evaluateTriggerConstraint(t, Duration.ZERO)) {
                            this.log.trace("Trigger {} satisfied, waiting for duration...", (Object)t);
                            break;
                        }
                        t.setState(SmartTrigger.TriggerState.WAITING_LOW);
                        this.log.trace("Trigger {} not satisfied, going WAITING_LOW...", (Object)t);
                        break;
                    }
                    case WAITING_LOW: {
                        this.log.trace("Trigger {} in WAITING_LOW, checking...", (Object)t);
                        if (!this.evaluateTriggerConstraint(t, Duration.ZERO)) break;
                        this.log.trace("Trigger {} met for the first time! Going to WAITING_HIGH", (Object)t);
                        t.setTimeConditionFirstMet(new Date(System.currentTimeMillis()));
                        t.setState(SmartTrigger.TriggerState.WAITING_HIGH);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected exception during evaluation", e);
        }
    }

    private void startRecording(SmartTrigger t) {
        this.flightRecorderHelper.createRecordingWithPredefinedTemplate(t.getRecordingTemplateName()).ifPresent(tr -> {
            String recordingName = String.format("cryostat-smart-trigger-%d", tr.getRecording().getId());
            tr.getRecording().setName(recordingName);
            this.harvester.handleNewRecording((FlightRecorderHelper.TemplatedRecording)tr);
            tr.getRecording().start();
            t.setState(SmartTrigger.TriggerState.COMPLETE);
            this.log.debug("Started recording \"{}\" using template \"{}\" due to trigger \"{}\"", recordingName, t.getRecordingTemplateName(), t.getExpression());
        });
    }

    private boolean evaluateTriggerConstraint(SmartTrigger trigger, Duration targetDuration) {
        try {
            Map<String, Object> conditionVars = new MBeanInfo().getSimplifiedMetrics();
            this.log.trace("evaluating mbean map:\n{}", (Object)conditionVars);
            Boolean conditionResult = this.buildConditionScript(trigger, conditionVars).execute(Boolean.class, conditionVars);
            Map<String, Object> durationVar = Map.of("TargetDuration", targetDuration);
            Boolean durationResult = Duration.ZERO.equals(targetDuration) ? Boolean.TRUE : this.buildDurationScript(trigger, durationVar).execute(Boolean.class, durationVar);
            return Boolean.TRUE.equals(conditionResult) && Boolean.TRUE.equals(durationResult);
        }
        catch (Exception e) {
            this.log.error("Failed to create or execute script", e);
            return false;
        }
    }

    private Script buildConditionScript(SmartTrigger trigger, Map<String, Object> scriptVars) {
        return this.conditionScriptCache.computeIfAbsent(trigger, t -> this.buildScript(t.getTriggerCondition(), scriptVars));
    }

    private Script buildDurationScript(SmartTrigger trigger, Map<String, Object> scriptVars) {
        return this.durationScriptCache.computeIfAbsent(trigger, t -> this.buildScript(t.getDurationConstraint(), scriptVars));
    }

    private Script buildScript(String script, Map<String, Object> scriptVars) {
        try {
            return this.scriptHost.buildScript(script).withDeclarations(this.buildDeclarations(scriptVars)).build();
        }
        catch (ScriptCreateException sce) {
            this.log.error("Failed to create script", sce);
            throw new RuntimeException(sce);
        }
    }

    private List<Decl> buildDeclarations(Map<String, Object> scriptVars) {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        for (Map.Entry<String, Object> s : scriptVars.entrySet()) {
            String key = s.getKey();
            Type parseType = this.parseType(s.getValue());
            this.log.trace("Declaring script var {} [{}]", (Object)key, (Object)parseType);
            decls.add(Decls.newVar(key, parseType));
        }
        return decls;
    }

    private Type parseType(Object obj) {
        if (obj.getClass().equals(String.class)) {
            return Decls.String;
        }
        if (obj.getClass().equals(Boolean.class)) {
            return Decls.Bool;
        }
        if (obj.getClass().equals(Integer.class)) {
            return Decls.Int;
        }
        if (obj.getClass().equals(Long.class)) {
            return Decls.newPrimitiveType(Type.PrimitiveType.INT64);
        }
        if (obj.getClass().equals(Double.class)) {
            return Decls.Double;
        }
        if (obj.getClass().equals(Duration.class)) {
            return Decls.Duration;
        }
        return Decls.String;
    }
}

