/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.triggers;

import java.time.Duration;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmartTrigger {
    private static final String DURATION_PATTERN_STR = "(TargetDuration\\s*[<>=]+\\s*duration\\(['\"](\\d+[sSmMhH]+)['\"]\\))";
    private static final String DEFINITION_PATTERN_STR = "(.+)\\s*(?:;)\\s*(TargetDuration\\s*[<>=]+\\s*duration\\(['\"](\\d+[sSmMhH]+)['\"]\\))";
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("(.+)\\s*(?:;)\\s*(TargetDuration\\s*[<>=]+\\s*duration\\(['\"](\\d+[sSmMhH]+)['\"]\\))");
    private final String rawExpression;
    private final String durationConstraint;
    private final String triggerCondition;
    private final String recordingTemplate;
    private final Duration targetDuration;
    private volatile Date firstMetTime;
    private volatile TriggerState state;

    public SmartTrigger(String expression, String templateName) {
        this.rawExpression = expression;
        this.recordingTemplate = templateName;
        this.state = TriggerState.NEW;
        Matcher m = DEFINITION_PATTERN.matcher(expression);
        if (m.matches()) {
            this.triggerCondition = m.group(1).replaceAll("\\s", "");
            this.durationConstraint = m.group(2).replaceAll("'", "\"").replaceAll("\\s", "");
            this.targetDuration = Duration.parse("PT" + m.group(3).replaceAll("\\s", ""));
        } else {
            this.triggerCondition = expression;
            this.durationConstraint = "";
            this.targetDuration = Duration.ZERO;
        }
    }

    public String getExpression() {
        return this.rawExpression;
    }

    public TriggerState getState() {
        return this.state;
    }

    public void setState(TriggerState targetState) {
        this.state = targetState;
    }

    public String getRecordingTemplateName() {
        return this.recordingTemplate;
    }

    public boolean isSimple() {
        return Duration.ZERO.equals(this.getTargetDuration());
    }

    public Duration getTargetDuration() {
        return this.targetDuration;
    }

    public void setTimeConditionFirstMet(Date date) {
        this.firstMetTime = new Date(date.getTime());
    }

    public Date getTimeConditionFirstMet() {
        return this.firstMetTime == null ? null : new Date(this.firstMetTime.getTime());
    }

    public String getTriggerCondition() {
        return this.triggerCondition;
    }

    public String getDurationConstraint() {
        return this.durationConstraint;
    }

    public int hashCode() {
        return Objects.hash(this.rawExpression, this.durationConstraint, this.triggerCondition, this.recordingTemplate, this.targetDuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmartTrigger other = (SmartTrigger)obj;
        return Objects.equals(this.rawExpression, other.rawExpression) && Objects.equals(this.durationConstraint, other.durationConstraint) && Objects.equals(this.triggerCondition, other.triggerCondition) && Objects.equals(this.recordingTemplate, other.recordingTemplate) && Objects.equals(this.targetDuration, other.targetDuration);
    }

    public String toString() {
        return "SmartTrigger [rawExpression=" + this.rawExpression + ", durationConstraint=" + this.durationConstraint + ", recordingTemplate=" + this.recordingTemplate + ", targetDuration=" + String.valueOf(this.targetDuration) + ", triggerCondition=" + this.triggerCondition + "]";
    }

    public static enum TriggerState {
        NEW,
        WAITING_HIGH,
        WAITING_LOW,
        COMPLETE;

    }
}

