/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.parser;

import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.SourceInfo;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.ErrorWithLocation;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.Errors;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.Location;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.Source;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.operators.Operator;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.ExprHelperImpl;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Helper;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Macro;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Options;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.StringCharStream;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Unescape;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.gen.CELLexer;
import io.cryostat.agent.shaded.org.projectnessie.cel.parser.gen.CELParser;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.ANTLRErrorListener;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.CommonTokenStream;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.DefaultErrorStrategy;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.IntStream;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.ParserRuleContext;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.RecognitionException;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Recognizer;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.RuleContext;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Token;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.dfa.DFA;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.tree.ErrorNode;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.tree.ParseTree;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.tree.ParseTreeListener;
import io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.tree.TerminalNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Parser {
    private static final Set<String> reservedIds = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("as", "break", "const", "continue", "else", "false", "for", "function", "if", "import", "in", "let", "loop", "package", "namespace", "null", "return", "true", "var", "void", "while")));
    private final Options options;

    public static ParseResult parseAllMacros(Source source) {
        return Parser.parse(Options.builder().macros(Macro.AllMacros).build(), source);
    }

    public static ParseResult parseWithMacros(Source source, List<Macro> macros) {
        return Parser.parse(Options.builder().macros(macros).build(), source);
    }

    public static ParseResult parse(Options options, Source source) {
        return new Parser(options).parse(source);
    }

    Parser(Options options) {
        this.options = options;
    }

    ParseResult parse(Source source) {
        StringCharStream charStream = new StringCharStream(source.content(), source.description());
        CELLexer lexer = new CELLexer(charStream);
        CELParser parser = new CELParser(new CommonTokenStream(lexer, 0));
        RecursionListener parserListener = new RecursionListener(this.options.getMaxRecursionDepth());
        parser.addParseListener(parserListener);
        parser.setErrorHandler(new RecoveryLimitErrorStrategy(this.options.getErrorRecoveryLimit()));
        Helper helper = new Helper(source);
        Errors errors = new Errors(source);
        InnerParser inner = new InnerParser(helper, errors);
        lexer.addErrorListener(inner);
        parser.addErrorListener(inner);
        Expr expr = null;
        try {
            if (charStream.size() > this.options.getExpressionSizeCodePointLimit()) {
                errors.reportError(Location.NoLocation, "expression code point size exceeds limit: size: %d, limit %d", charStream.size(), this.options.getExpressionSizeCodePointLimit());
            } else {
                expr = inner.exprVisit(parser.start());
            }
        }
        catch (RecoveryLimitError | RecursionError e) {
            errors.reportError(e, Location.NoLocation, "%s", e.getMessage());
        }
        if (errors.hasErrors()) {
            expr = null;
        }
        return new ParseResult(expr, errors, helper.getSourceInfo());
    }

    public static final class ParseResult {
        private final Expr expr;
        private final Errors errors;
        private final SourceInfo sourceInfo;

        public ParseResult(Expr expr, Errors errors, SourceInfo sourceInfo) {
            this.expr = expr;
            this.errors = errors;
            this.sourceInfo = sourceInfo;
        }

        public Expr getExpr() {
            return this.expr;
        }

        public Errors getErrors() {
            return this.errors;
        }

        public SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        public boolean hasErrors() {
            return this.errors.hasErrors();
        }
    }

    static final class RecursionListener
    implements ParseTreeListener {
        private final int maxDepth;
        private int depth;

        RecursionListener(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public void visitTerminal(TerminalNode node) {
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
        }

        @Override
        public void enterEveryRule(ParserRuleContext ctx) {
            if (ctx != null && ctx.getRuleIndex() == 1) {
                if (this.depth >= this.maxDepth) {
                    ++this.depth;
                    throw new RecursionError(String.format("expression recursion limit exceeded: %d", this.maxDepth));
                }
                ++this.depth;
            }
        }

        @Override
        public void exitEveryRule(ParserRuleContext ctx) {
            if (ctx != null && ctx.getRuleIndex() == 1) {
                --this.depth;
            }
        }
    }

    static final class RecoveryLimitErrorStrategy
    extends DefaultErrorStrategy {
        private final int maxAttempts;
        private int attempts;

        private RecoveryLimitErrorStrategy(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public void recover(io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Parser recognizer, RecognitionException e) {
            this.checkAttempts(recognizer);
            super.recover(recognizer, e);
        }

        @Override
        public Token recoverInline(io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Parser recognizer) throws RecognitionException {
            this.checkAttempts(recognizer);
            return super.recoverInline(recognizer);
        }

        void checkAttempts(io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Parser recognizer) throws RecognitionException {
            if (this.attempts >= this.maxAttempts) {
                ++this.attempts;
                String msg = String.format("error recovery attempt limit exceeded: %d", this.maxAttempts);
                recognizer.notifyErrorListeners(null, msg, null);
                throw new RecoveryLimitError(msg, recognizer, null, null);
            }
            ++this.attempts;
        }
    }

    final class InnerParser
    extends AbstractParseTreeVisitor<Object>
    implements ANTLRErrorListener {
        private final Helper helper;
        private final Errors errors;

        InnerParser(Helper helper, Errors errors) {
            this.helper = helper;
            this.errors = errors;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.errors.syntaxError(Location.newLocation(line, charPositionInLine), msg);
        }

        @Override
        public void reportAmbiguity(io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportAttemptingFullContext(io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(io.cryostat.agent.shaded.org.projectnessie.cel.shaded.org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }

        Expr reportError(Object ctx, String message) {
            return this.reportError(ctx, "%s", message);
        }

        Expr reportError(Object ctx, String format, Object ... args) {
            Expr err;
            Location location;
            if (ctx instanceof Location) {
                location = (Location)ctx;
            } else if (ctx instanceof Token || ctx instanceof ParserRuleContext) {
                err = this.helper.newExpr(ctx);
                location = this.helper.getLocation(err.getId());
            } else {
                location = Location.NoLocation;
            }
            err = this.helper.newExpr(ctx);
            this.errors.reportError(location, format, args);
            return err;
        }

        public Expr exprVisit(ParseTree tree) {
            Object r = this.visit(tree);
            return (Expr)r;
        }

        @Override
        public Object visit(ParseTree tree) {
            if (tree instanceof RuleContext) {
                RuleContext ruleContext = (RuleContext)tree;
                int ruleIndex = ruleContext.getRuleIndex();
                switch (ruleIndex) {
                    case 0: {
                        return this.visitStart((CELParser.StartContext)tree);
                    }
                    case 1: {
                        return this.visitExpr((CELParser.ExprContext)tree);
                    }
                    case 2: {
                        return this.visitConditionalOr((CELParser.ConditionalOrContext)tree);
                    }
                    case 3: {
                        return this.visitConditionalAnd((CELParser.ConditionalAndContext)tree);
                    }
                    case 4: {
                        return this.visitRelation((CELParser.RelationContext)tree);
                    }
                    case 5: {
                        return this.visitCalc((CELParser.CalcContext)tree);
                    }
                    case 6: {
                        if (tree instanceof CELParser.LogicalNotContext) {
                            return this.visitLogicalNot((CELParser.LogicalNotContext)tree);
                        }
                        if (tree instanceof CELParser.NegateContext) {
                            return this.visitNegate((CELParser.NegateContext)tree);
                        }
                        if (tree instanceof CELParser.MemberExprContext) {
                            return this.visitMemberExpr((CELParser.MemberExprContext)tree);
                        }
                        return this.visitUnary((CELParser.UnaryContext)tree);
                    }
                    case 7: {
                        if (tree instanceof CELParser.CreateMessageContext) {
                            return this.visitCreateMessage((CELParser.CreateMessageContext)tree);
                        }
                        if (tree instanceof CELParser.PrimaryExprContext) {
                            return this.visitPrimaryExpr((CELParser.PrimaryExprContext)tree);
                        }
                        if (tree instanceof CELParser.SelectOrCallContext) {
                            return this.visitSelectOrCall((CELParser.SelectOrCallContext)tree);
                        }
                        if (!(tree instanceof CELParser.IndexContext)) break;
                        return this.visitIndex((CELParser.IndexContext)tree);
                    }
                    case 8: {
                        if (tree instanceof CELParser.CreateListContext) {
                            return this.visitCreateList((CELParser.CreateListContext)tree);
                        }
                        if (!(tree instanceof CELParser.CreateStructContext)) break;
                        return this.visitCreateStruct((CELParser.CreateStructContext)tree);
                    }
                    case 10: 
                    case 11: {
                        return this.visitMapInitializerList((CELParser.MapInitializerListContext)tree);
                    }
                    default: {
                        return this.reportError(tree, "parser rule '%d'", ruleIndex);
                    }
                }
            }
            if (!this.errors.hasErrors()) {
                String txt = "<<nil>>";
                if (tree != null) {
                    txt = String.format("<<%s>>", tree.getClass().getSimpleName());
                }
                return this.reportError(Location.NoLocation, "unknown parse element encountered: %s", txt);
            }
            return this.helper.newExpr(Location.NoLocation);
        }

        private Object visitStart(CELParser.StartContext ctx) {
            return this.visit(ctx.expr());
        }

        private Expr visitExpr(CELParser.ExprContext ctx) {
            Expr result = this.exprVisit(ctx.e);
            if (ctx.op == null) {
                return result;
            }
            long opID = this.helper.id(ctx.op);
            Expr ifTrue = this.exprVisit(ctx.e1);
            Expr ifFalse = this.exprVisit(ctx.e2);
            return this.globalCallOrMacro(opID, Operator.Conditional.id, result, ifTrue, ifFalse);
        }

        private Expr visitConditionalAnd(CELParser.ConditionalAndContext ctx) {
            Expr result = this.exprVisit(ctx.e);
            if (ctx.ops == null || ctx.ops.isEmpty()) {
                return result;
            }
            Helper.Balancer b = this.helper.newBalancer(Operator.LogicalAnd.id, result);
            List<CELParser.RelationContext> rest = ctx.e1;
            for (int i = 0; i < ctx.ops.size(); ++i) {
                Token op = ctx.ops.get(i);
                if (i >= rest.size()) {
                    return this.reportError(ctx, "unexpected character, wanted '&&'");
                }
                Expr next = this.exprVisit(rest.get(i));
                long opID = this.helper.id(op);
                b.addTerm(opID, next);
            }
            return b.balance();
        }

        private Expr visitConditionalOr(CELParser.ConditionalOrContext ctx) {
            Expr result = this.exprVisit(ctx.e);
            if (ctx.ops == null || ctx.ops.isEmpty()) {
                return result;
            }
            Helper.Balancer b = this.helper.newBalancer(Operator.LogicalOr.id, result);
            List<CELParser.ConditionalAndContext> rest = ctx.e1;
            for (int i = 0; i < ctx.ops.size(); ++i) {
                Token op = ctx.ops.get(i);
                if (i >= rest.size()) {
                    return this.reportError(ctx, "unexpected character, wanted '||'");
                }
                Expr next = this.exprVisit(rest.get(i));
                long opID = this.helper.id(op);
                b.addTerm(opID, next);
            }
            return b.balance();
        }

        private Expr visitRelation(CELParser.RelationContext ctx) {
            Operator op;
            if (ctx.calc() != null) {
                return this.exprVisit(ctx.calc());
            }
            String opText = "";
            if (ctx.op != null) {
                opText = ctx.op.getText();
            }
            if ((op = Operator.find(opText)) != null) {
                Expr lhs = this.exprVisit(ctx.relation(0));
                long opID = this.helper.id(ctx.op);
                Expr rhs = this.exprVisit(ctx.relation(1));
                return this.globalCallOrMacro(opID, op.id, lhs, rhs);
            }
            return this.reportError(ctx, "operator not found");
        }

        private Expr visitCalc(CELParser.CalcContext ctx) {
            Operator op;
            if (ctx.unary() != null) {
                return this.exprVisit(ctx.unary());
            }
            String opText = "";
            if (ctx.op != null) {
                opText = ctx.op.getText();
            }
            if ((op = Operator.find(opText)) != null) {
                Expr lhs = this.exprVisit(ctx.calc(0));
                long opID = this.helper.id(ctx.op);
                Expr rhs = this.exprVisit(ctx.calc(1));
                return this.globalCallOrMacro(opID, op.id, lhs, rhs);
            }
            return this.reportError(ctx, "operator not found");
        }

        private Expr visitLogicalNot(CELParser.LogicalNotContext ctx) {
            if (ctx.ops.size() % 2 == 0) {
                return this.exprVisit(ctx.member());
            }
            long opID = this.helper.id(ctx.ops.get(0));
            Expr target = this.exprVisit(ctx.member());
            return this.globalCallOrMacro(opID, Operator.LogicalNot.id, target);
        }

        private Expr visitMemberExpr(CELParser.MemberExprContext ctx) {
            if (ctx.member() instanceof CELParser.PrimaryExprContext) {
                return this.visitPrimaryExpr((CELParser.PrimaryExprContext)ctx.member());
            }
            if (ctx.member() instanceof CELParser.SelectOrCallContext) {
                return this.visitSelectOrCall((CELParser.SelectOrCallContext)ctx.member());
            }
            if (ctx.member() instanceof CELParser.IndexContext) {
                return this.visitIndex((CELParser.IndexContext)ctx.member());
            }
            if (ctx.member() instanceof CELParser.CreateMessageContext) {
                return this.visitCreateMessage((CELParser.CreateMessageContext)ctx.member());
            }
            return this.reportError(ctx, "unsupported simple expression");
        }

        private Expr visitPrimaryExpr(CELParser.PrimaryExprContext ctx) {
            if (ctx.primary() instanceof CELParser.NestedContext) {
                return this.visitNested((CELParser.NestedContext)ctx.primary());
            }
            if (ctx.primary() instanceof CELParser.IdentOrGlobalCallContext) {
                return this.visitIdentOrGlobalCall((CELParser.IdentOrGlobalCallContext)ctx.primary());
            }
            if (ctx.primary() instanceof CELParser.CreateListContext) {
                return this.visitCreateList((CELParser.CreateListContext)ctx.primary());
            }
            if (ctx.primary() instanceof CELParser.CreateStructContext) {
                return this.visitCreateStruct((CELParser.CreateStructContext)ctx.primary());
            }
            if (ctx.primary() instanceof CELParser.ConstantLiteralContext) {
                return this.visitConstantLiteral((CELParser.ConstantLiteralContext)ctx.primary());
            }
            return this.reportError(ctx, "invalid primary expression");
        }

        private Expr visitConstantLiteral(CELParser.ConstantLiteralContext ctx) {
            if (ctx.literal() instanceof CELParser.IntContext) {
                return this.visitInt((CELParser.IntContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.UintContext) {
                return this.visitUint((CELParser.UintContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.DoubleContext) {
                return this.visitDouble((CELParser.DoubleContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.StringContext) {
                return this.visitString((CELParser.StringContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.BytesContext) {
                return this.visitBytes((CELParser.BytesContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.BoolFalseContext) {
                return this.visitBoolFalse((CELParser.BoolFalseContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.BoolTrueContext) {
                return this.visitBoolTrue((CELParser.BoolTrueContext)ctx.literal());
            }
            if (ctx.literal() instanceof CELParser.NullContext) {
                return this.visitNull((CELParser.NullContext)ctx.literal());
            }
            return this.reportError(ctx, "invalid literal");
        }

        private Expr visitInt(CELParser.IntContext ctx) {
            String text = ctx.tok.getText();
            int base = 10;
            if (text.startsWith("0x")) {
                base = 16;
                text = text.substring(2);
            }
            if (ctx.sign != null) {
                text = ctx.sign.getText() + text;
            }
            try {
                long i = Long.parseLong(text, base);
                return this.helper.newLiteralInt(ctx, i);
            }
            catch (Exception e) {
                return this.reportError(ctx, "invalid int literal");
            }
        }

        private Expr visitUint(CELParser.UintContext ctx) {
            String text = ctx.tok.getText();
            text = text.substring(0, text.length() - 1);
            int base = 10;
            if (text.startsWith("0x")) {
                base = 16;
                text = text.substring(2);
            }
            try {
                long i = Long.parseUnsignedLong(text, base);
                return this.helper.newLiteralUint(ctx, i);
            }
            catch (Exception e) {
                return this.reportError(ctx, "invalid int literal");
            }
        }

        private Expr visitDouble(CELParser.DoubleContext ctx) {
            String txt = ctx.tok.getText();
            if (ctx.sign != null) {
                txt = ctx.sign.getText() + txt;
            }
            try {
                double f = Double.parseDouble(txt);
                return this.helper.newLiteralDouble(ctx, f);
            }
            catch (Exception e) {
                return this.reportError(ctx, "invalid double literal");
            }
        }

        private Expr visitString(CELParser.StringContext ctx) {
            String s = this.unquoteString(ctx, ctx.getText());
            return this.helper.newLiteralString(ctx, s);
        }

        private Expr visitBytes(CELParser.BytesContext ctx) {
            ByteString b = this.unquoteBytes(ctx, ctx.tok.getText().substring(1));
            return this.helper.newLiteralBytes(ctx, b);
        }

        private Expr visitBoolFalse(CELParser.BoolFalseContext ctx) {
            return this.helper.newLiteralBool(ctx, false);
        }

        private Expr visitBoolTrue(CELParser.BoolTrueContext ctx) {
            return this.helper.newLiteralBool(ctx, true);
        }

        private Expr visitNull(CELParser.NullContext ctx) {
            return this.helper.newLiteral(ctx, Constant.newBuilder().setNullValue(NullValue.NULL_VALUE));
        }

        private List<Expr> visitList(CELParser.ExprListContext ctx) {
            if (ctx == null) {
                return Collections.emptyList();
            }
            return this.visitSlice(ctx.e);
        }

        private List<Expr> visitSlice(List<CELParser.ExprContext> expressions) {
            if (expressions == null) {
                return Collections.emptyList();
            }
            ArrayList<Expr> result = new ArrayList<Expr>(expressions.size());
            for (CELParser.ExprContext e : expressions) {
                Expr ex = this.exprVisit(e);
                result.add(ex);
            }
            return result;
        }

        String extractQualifiedName(Expr e) {
            if (e == null) {
                return null;
            }
            switch (e.getExprKindCase()) {
                case IDENT_EXPR: {
                    return e.getIdentExpr().getName();
                }
                case SELECT_EXPR: {
                    Expr.Select s = e.getSelectExpr();
                    String prefix = this.extractQualifiedName(s.getOperand());
                    return prefix + "." + s.getField();
                }
            }
            Location location = this.helper.getLocation(e.getId());
            this.reportError(location, "expected a qualified name");
            return null;
        }

        List<Expr.CreateStruct.Entry> visitIFieldInitializerList(CELParser.FieldInitializerListContext ctx) {
            if (ctx == null || ctx.fields == null) {
                return Collections.emptyList();
            }
            ArrayList<Expr.CreateStruct.Entry> result = new ArrayList<Expr.CreateStruct.Entry>(ctx.fields.size());
            List<Token> cols = ctx.cols;
            List<CELParser.ExprContext> vals = ctx.values;
            for (int i = 0; i < ctx.fields.size(); ++i) {
                Token f = ctx.fields.get(i);
                if (i >= cols.size() || i >= vals.size()) {
                    return Collections.emptyList();
                }
                long initID = this.helper.id(cols.get(i));
                Expr value = this.exprVisit(vals.get(i));
                Expr.CreateStruct.Entry field = this.helper.newObjectField(initID, f.getText(), value);
                result.add(field);
            }
            return result;
        }

        private Expr visitIdentOrGlobalCall(CELParser.IdentOrGlobalCallContext ctx) {
            String identName = "";
            if (ctx.leadingDot != null) {
                identName = ".";
            }
            if (ctx.id == null) {
                return this.helper.newExpr(ctx);
            }
            String id = ctx.id.getText();
            if (reservedIds.contains(id)) {
                return this.reportError(ctx, "reserved identifier: %s", id);
            }
            identName = identName + id;
            if (ctx.op != null) {
                long opID = this.helper.id(ctx.op);
                return this.globalCallOrMacro(opID, identName, this.visitList(ctx.args));
            }
            return this.helper.newIdent(ctx.id, identName);
        }

        private Expr visitNested(CELParser.NestedContext ctx) {
            return this.exprVisit(ctx.e);
        }

        private Expr visitSelectOrCall(CELParser.SelectOrCallContext ctx) {
            Expr operand = this.exprVisit(ctx.member());
            if (ctx.id == null) {
                return this.helper.newExpr(ctx);
            }
            String id = ctx.id.getText();
            if (ctx.open != null) {
                long opID = this.helper.id(ctx.open);
                return this.receiverCallOrMacro(opID, id, operand, this.visitList(ctx.args));
            }
            return this.helper.newSelect(ctx.op, operand, id);
        }

        private List<Expr.CreateStruct.Entry> visitMapInitializerList(CELParser.MapInitializerListContext ctx) {
            if (ctx == null || ctx.keys.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Expr.CreateStruct.Entry> result = new ArrayList<Expr.CreateStruct.Entry>(ctx.cols.size());
            List<CELParser.ExprContext> keys = ctx.keys;
            List<CELParser.ExprContext> vals = ctx.values;
            for (int i = 0; i < ctx.cols.size(); ++i) {
                Token col = ctx.cols.get(i);
                long colID = this.helper.id(col);
                if (i >= keys.size() || i >= vals.size()) {
                    return Collections.emptyList();
                }
                Expr key = this.exprVisit(keys.get(i));
                Expr value = this.exprVisit(vals.get(i));
                Expr.CreateStruct.Entry entry = this.helper.newMapEntry(colID, key, value);
                result.add(entry);
            }
            return result;
        }

        private Expr visitNegate(CELParser.NegateContext ctx) {
            if (ctx.ops.size() % 2 == 0) {
                return this.exprVisit(ctx.member());
            }
            long opID = this.helper.id(ctx.ops.get(0));
            Expr target = this.exprVisit(ctx.member());
            return this.globalCallOrMacro(opID, Operator.Negate.id, target);
        }

        private Expr visitIndex(CELParser.IndexContext ctx) {
            Expr target = this.exprVisit(ctx.member());
            long opID = this.helper.id(ctx.op);
            Expr index = this.exprVisit(ctx.index);
            return this.globalCallOrMacro(opID, Operator.Index.id, target, index);
        }

        private Expr visitUnary(CELParser.UnaryContext ctx) {
            return this.helper.newLiteralString(ctx, "<<error>>");
        }

        private Expr visitCreateList(CELParser.CreateListContext ctx) {
            long listID = this.helper.id(ctx.op);
            return this.helper.newList(listID, this.visitList(ctx.elems));
        }

        private Expr visitCreateMessage(CELParser.CreateMessageContext ctx) {
            Expr target = this.exprVisit(ctx.member());
            long objID = this.helper.id(ctx.op);
            String messageName = this.extractQualifiedName(target);
            if (messageName != null) {
                List<Expr.CreateStruct.Entry> entries = this.visitIFieldInitializerList(ctx.entries);
                return this.helper.newObject(objID, messageName, entries);
            }
            return this.helper.newExpr(objID);
        }

        private Expr visitCreateStruct(CELParser.CreateStructContext ctx) {
            long structID = this.helper.id(ctx.op);
            if (ctx.entries != null) {
                return this.helper.newMap(structID, this.visitMapInitializerList(ctx.entries));
            }
            return this.helper.newMap(structID, Collections.emptyList());
        }

        Expr globalCallOrMacro(long exprID, String function, Expr ... args) {
            return this.globalCallOrMacro(exprID, function, Arrays.asList(args));
        }

        Expr globalCallOrMacro(long exprID, String function, List<Expr> args) {
            Expr expr = this.expandMacro(exprID, function, null, args);
            if (expr != null) {
                return expr;
            }
            return this.helper.newGlobalCall((Object)exprID, function, args);
        }

        Expr receiverCallOrMacro(long exprID, String function, Expr target, List<Expr> args) {
            Expr expr = this.expandMacro(exprID, function, target, args);
            if (expr != null) {
                return expr;
            }
            return this.helper.newReceiverCall(exprID, function, target, args);
        }

        Expr expandMacro(long exprID, String function, Expr target, List<Expr> args) {
            Macro macro = Parser.this.options.getMacro(Macro.makeMacroKey(function, args.size(), target != null));
            if (macro == null && (macro = Parser.this.options.getMacro(Macro.makeVarArgMacroKey(function, target != null))) == null) {
                return null;
            }
            ExprHelperImpl eh = new ExprHelperImpl(this.helper, exprID);
            try {
                return macro.expander().expand(eh, target, args);
            }
            catch (ErrorWithLocation err) {
                Location loc = err.getLocation();
                if (loc == null) {
                    loc = this.helper.getLocation(exprID);
                }
                return this.reportError(loc, err.getMessage());
            }
            catch (Exception e) {
                return this.reportError(this.helper.getLocation(exprID), e.getMessage());
            }
        }

        ByteString unquoteBytes(Object ctx, String value) {
            try {
                ByteBuffer buf = Unescape.unescape(value, true);
                return ByteString.copyFrom(buf);
            }
            catch (Exception e) {
                this.reportError(ctx, e.toString());
                return ByteString.copyFromUtf8(value);
            }
        }

        String unquoteString(Object ctx, String value) {
            try {
                ByteBuffer buf = Unescape.unescape(value, false);
                return Unescape.toUtf8(buf);
            }
            catch (Exception e) {
                this.reportError(ctx, e.toString());
                return value;
            }
        }
    }

    static final class RecoveryLimitError
    extends RecognitionException {
        public RecoveryLimitError(String message, Recognizer<?, ?> recognizer, IntStream input, ParserRuleContext ctx) {
            super(message, recognizer, input, ctx);
        }
    }

    static final class RecursionError
    extends RuntimeException {
        public RecursionError(String message) {
            super(message);
        }
    }
}

