/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.parser;

import io.cryostat.agent.shaded.org.projectnessie.cel.parser.Macro;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Options {
    private final int maxRecursionDepth;
    private final int errorRecoveryLimit;
    private final int expressionSizeCodePointLimit;
    private final Map<String, Macro> macros;

    private Options(int maxRecursionDepth, int errorRecoveryLimit, int expressionSizeCodePointLimit, Map<String, Macro> macros) {
        this.maxRecursionDepth = maxRecursionDepth;
        this.errorRecoveryLimit = errorRecoveryLimit;
        this.expressionSizeCodePointLimit = expressionSizeCodePointLimit;
        this.macros = macros;
    }

    public int getMaxRecursionDepth() {
        return this.maxRecursionDepth;
    }

    public int getErrorRecoveryLimit() {
        return this.errorRecoveryLimit;
    }

    public int getExpressionSizeCodePointLimit() {
        return this.expressionSizeCodePointLimit;
    }

    public Macro getMacro(String name) {
        return this.macros.get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Macro> macros = new HashMap<String, Macro>();
        private int maxRecursionDepth = 250;
        private int errorRecoveryLimit = 30;
        private int expressionSizeCodePointLimit = 100000;

        private Builder() {
        }

        public Builder maxRecursionDepth(int maxRecursionDepth) {
            if (maxRecursionDepth < -1) {
                throw new IllegalArgumentException(String.format("max recursion depth must be greater than or equal to -1: %d", maxRecursionDepth));
            }
            if (maxRecursionDepth == -1) {
                maxRecursionDepth = Integer.MAX_VALUE;
            }
            this.maxRecursionDepth = maxRecursionDepth;
            return this;
        }

        public Builder errorRecoveryLimit(int errorRecoveryLimit) {
            if (errorRecoveryLimit < -1) {
                throw new IllegalArgumentException(String.format("error recovery limit must be greater than or equal to -1: %d", errorRecoveryLimit));
            }
            if (errorRecoveryLimit == -1) {
                errorRecoveryLimit = Integer.MAX_VALUE;
            }
            this.errorRecoveryLimit = errorRecoveryLimit;
            return this;
        }

        public Builder expressionSizeCodePointLimit(int expressionSizeCodePointLimit) {
            if (expressionSizeCodePointLimit < -1) {
                throw new IllegalArgumentException(String.format("expression size code point limit must be greater than or equal to -1: %d", expressionSizeCodePointLimit));
            }
            if (expressionSizeCodePointLimit == -1) {
                expressionSizeCodePointLimit = Integer.MAX_VALUE;
            }
            this.expressionSizeCodePointLimit = expressionSizeCodePointLimit;
            return this;
        }

        public Builder macros(Macro ... macros) {
            return this.macros(Arrays.asList(macros));
        }

        public Builder macros(List<Macro> macros) {
            for (Macro macro : macros) {
                this.macros.put(macro.macroKey(), macro);
            }
            return this;
        }

        public Options build() {
            return new Options(this.maxRecursionDepth, this.errorRecoveryLimit, this.expressionSizeCodePointLimit, new HashMap<String, Macro>(this.macros));
        }
    }
}

