/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.operators.Operator;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.BoolT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.BytesT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.DoubleT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.DurationT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IntT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IterableT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IteratorT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.StringT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.TimestampT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.TypeT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.UintT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeEnum;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Adder;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Comparer;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Container;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Divider;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Indexer;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Matcher;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Modder;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Multiplier;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Negater;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Sizer;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Subtractor;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Trait;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.BinaryOp;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.FunctionOp;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.UnaryOp;

public final class Overload {
    public final String operator;
    public final Trait operandTrait;
    public final UnaryOp unary;
    public final BinaryOp binary;
    public final FunctionOp function;

    public static Overload unary(Operator operator, UnaryOp op) {
        return Overload.unary(operator.id, op);
    }

    public static Overload unary(String operator, UnaryOp op) {
        return Overload.unary(operator, null, op);
    }

    public static Overload unary(Operator operator, Trait trait, UnaryOp op) {
        return Overload.unary(operator.id, trait, op);
    }

    public static Overload unary(String operator, Trait trait, UnaryOp op) {
        return new Overload(operator, trait, op, null, null);
    }

    public static Overload binary(Operator operator, BinaryOp op) {
        return Overload.binary(operator.id, op);
    }

    public static Overload binary(String operator, BinaryOp op) {
        return Overload.binary(operator, null, op);
    }

    public static Overload binary(Operator operator, Trait trait, BinaryOp op) {
        return Overload.binary(operator.id, trait, op);
    }

    public static Overload binary(String operator, Trait trait, BinaryOp op) {
        return new Overload(operator, trait, null, op, null);
    }

    public static Overload function(String operator, FunctionOp op) {
        return Overload.function(operator, null, op);
    }

    public static Overload function(String operator, Trait trait, FunctionOp op) {
        return new Overload(operator, trait, null, null, op);
    }

    public static Overload overload(String operator, Trait trait, UnaryOp unary, BinaryOp binary, FunctionOp function) {
        return new Overload(operator, trait, unary, binary, function);
    }

    private Overload(String operator, Trait operandTrait, UnaryOp unary, BinaryOp binary, FunctionOp function) {
        this.operator = operator;
        this.operandTrait = operandTrait;
        this.unary = unary;
        this.binary = binary;
        this.function = function;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Overload{");
        sb.append(this.operator).append('\'');
        sb.append(", trait=").append((Object)this.operandTrait);
        if (this.unary != null) {
            sb.append(", unary");
        }
        if (this.binary != null) {
            sb.append(", binary");
        }
        if (this.binary != null) {
            sb.append(", function");
        }
        sb.append('}');
        return sb.toString();
    }

    public static Overload[] standardOverloads() {
        return new Overload[]{Overload.unary(Operator.LogicalNot, Trait.NegatorType, (Val v) -> {
            if (v.type().typeEnum() == TypeEnum.Bool) {
                return ((Negater)((Object)v)).negate();
            }
            return Err.noSuchOverload(null, Operator.LogicalNot.id, v);
        }), Overload.unary(Operator.NotStrictlyFalse, Overload::notStrictlyFalse), Overload.unary(Operator.OldNotStrictlyFalse, Overload::notStrictlyFalse), Overload.binary(Operator.Less, Trait.ComparerType, (Val lhs, Val rhs) -> {
            Val cmp = ((Comparer)((Object)lhs)).compare(rhs);
            if (cmp == IntT.IntNegOne) {
                return BoolT.True;
            }
            if (cmp == IntT.IntOne || cmp == IntT.IntZero) {
                return BoolT.False;
            }
            return cmp;
        }), Overload.binary(Operator.LessEquals, Trait.ComparerType, (Val lhs, Val rhs) -> {
            Val cmp = ((Comparer)((Object)lhs)).compare(rhs);
            if (cmp == IntT.IntNegOne || cmp == IntT.IntZero) {
                return BoolT.True;
            }
            if (cmp == IntT.IntOne) {
                return BoolT.False;
            }
            return cmp;
        }), Overload.binary(Operator.Greater, Trait.ComparerType, (Val lhs, Val rhs) -> {
            Val cmp = ((Comparer)((Object)lhs)).compare(rhs);
            if (cmp == IntT.IntOne) {
                return BoolT.True;
            }
            if (cmp == IntT.IntNegOne || cmp == IntT.IntZero) {
                return BoolT.False;
            }
            return cmp;
        }), Overload.binary(Operator.GreaterEquals, Trait.ComparerType, (Val lhs, Val rhs) -> {
            Val cmp = ((Comparer)((Object)lhs)).compare(rhs);
            if (cmp == IntT.IntOne || cmp == IntT.IntZero) {
                return BoolT.True;
            }
            if (cmp == IntT.IntNegOne) {
                return BoolT.False;
            }
            return cmp;
        }), Overload.binary(Operator.Add, Trait.AdderType, (Val lhs, Val rhs) -> ((Adder)((Object)lhs)).add(rhs)), Overload.binary(Operator.Subtract, Trait.SubtractorType, (Val lhs, Val rhs) -> ((Subtractor)((Object)lhs)).subtract(rhs)), Overload.binary(Operator.Multiply, Trait.MultiplierType, (Val lhs, Val rhs) -> ((Multiplier)((Object)lhs)).multiply(rhs)), Overload.binary(Operator.Divide, Trait.DividerType, (Val lhs, Val rhs) -> ((Divider)((Object)lhs)).divide(rhs)), Overload.binary(Operator.Modulo, Trait.ModderType, (Val lhs, Val rhs) -> ((Modder)((Object)lhs)).modulo(rhs)), Overload.unary(Operator.Negate, Trait.NegatorType, (Val v) -> {
            if (v.type().typeEnum() != TypeEnum.Bool) {
                return ((Negater)((Object)v)).negate();
            }
            return Err.noSuchOverload(null, Operator.Negate.id, v);
        }), Overload.binary(Operator.Index, Trait.IndexerType, (Val lhs, Val rhs) -> ((Indexer)((Object)lhs)).get(rhs)), Overload.unary("size", Trait.SizerType, (Val v) -> ((Sizer)((Object)v)).size()), Overload.binary(Operator.In, Overload::inAggregate), Overload.binary(Operator.OldIn, Overload::inAggregate), Overload.binary("matches", Trait.MatcherType, (Val lhs, Val rhs) -> ((Matcher)((Object)lhs)).match(rhs)), Overload.unary("int", (Val v) -> v.convertToType(IntT.IntType)), Overload.unary("uint", (Val v) -> v.convertToType(UintT.UintType)), Overload.unary("double", (Val v) -> v.convertToType(DoubleT.DoubleType)), Overload.unary("bool", (Val v) -> v.convertToType(BoolT.BoolType)), Overload.unary("bytes", (Val v) -> v.convertToType(BytesT.BytesType)), Overload.unary("string", (Val v) -> v.convertToType(StringT.StringType)), Overload.unary("timestamp", (Val v) -> v.convertToType(TimestampT.TimestampType)), Overload.unary("duration", (Val v) -> v.convertToType(DurationT.DurationType)), Overload.unary("type", (Val v) -> v.convertToType(TypeT.TypeType)), Overload.unary("dyn", (Val v) -> v), Overload.unary("@iterator", Trait.IterableType, (Val v) -> ((IterableT)((Object)v)).iterator()), Overload.unary("@hasNext", Trait.IteratorType, (Val v) -> ((IteratorT)v).hasNext()), Overload.unary("@next", Trait.IteratorType, (Val v) -> ((IteratorT)v).next())};
    }

    static Val notStrictlyFalse(Val value) {
        if (value.type().typeEnum() == TypeEnum.Bool) {
            return value;
        }
        return BoolT.True;
    }

    static Val inAggregate(Val lhs, Val rhs) {
        if (rhs.type().hasTrait(Trait.ContainerType)) {
            return ((Container)((Object)rhs)).contains(lhs);
        }
        return Err.noSuchOverload(lhs, Operator.In.id, rhs);
    }
}

