/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.interpreter;

import com.google.api.expr.v1alpha1.CheckedExpr;
import com.google.api.expr.v1alpha1.Expr;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.containers.Container;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeAdapter;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeProvider;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.AttributeFactory;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Dispatcher;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.EvalState;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Interpretable;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.InterpretableDecorator;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.InterpretablePlanner;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.Overload;

public interface Interpreter {
    public Interpretable newInterpretable(CheckedExpr var1, InterpretableDecorator ... var2);

    public Interpretable newUncheckedInterpretable(Expr var1, InterpretableDecorator ... var2);

    public static InterpretableDecorator trackState(EvalState state) {
        return InterpretableDecorator.decObserveEval(state::setValue);
    }

    public static InterpretableDecorator exhaustiveEval(EvalState state) {
        InterpretableDecorator ex = InterpretableDecorator.decDisableShortcircuits();
        InterpretableDecorator obs = Interpreter.trackState(state);
        return i -> {
            Interpretable iDec = ex.decorate(i);
            return obs.decorate(iDec);
        };
    }

    public static InterpretableDecorator optimize() {
        return InterpretableDecorator.decOptimize();
    }

    public static Interpreter newInterpreter(Dispatcher dispatcher, Container container, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory) {
        return new ExprInterpreter(dispatcher, container, provider, adapter, attrFactory);
    }

    public static Interpreter newStandardInterpreter(Container container, TypeProvider provider, TypeAdapter adapter, AttributeFactory resolver) {
        Dispatcher dispatcher = Dispatcher.newDispatcher();
        dispatcher.add(Overload.standardOverloads());
        return Interpreter.newInterpreter(dispatcher, container, provider, adapter, resolver);
    }

    public static final class ExprInterpreter
    implements Interpreter {
        private final Dispatcher dispatcher;
        private final Container container;
        private final TypeProvider provider;
        private final TypeAdapter adapter;
        private final AttributeFactory attrFactory;

        ExprInterpreter(Dispatcher dispatcher, Container container, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory) {
            this.dispatcher = dispatcher;
            this.container = container;
            this.provider = provider;
            this.adapter = adapter;
            this.attrFactory = attrFactory;
        }

        @Override
        public Interpretable newInterpretable(CheckedExpr checked, InterpretableDecorator ... decorators) {
            InterpretablePlanner p = InterpretablePlanner.newPlanner(this.dispatcher, this.provider, this.adapter, this.attrFactory, this.container, checked, decorators);
            return p.plan(checked.getExpr());
        }

        @Override
        public Interpretable newUncheckedInterpretable(Expr expr, InterpretableDecorator ... decorators) {
            InterpretablePlanner p = InterpretablePlanner.newUncheckedPlanner(this.dispatcher, this.provider, this.adapter, this.attrFactory, this.container, decorators);
            return p.plan(expr);
        }
    }
}

