/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.interpreter;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.BoolT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IntT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IteratorT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Overloads;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Util;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Type;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.traits.Lister;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Activation;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.AttributeFactory;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.Interpretable;
import java.util.HashSet;

@FunctionalInterface
public interface InterpretableDecorator {
    public Interpretable decorate(Interpretable var1);

    public static InterpretableDecorator decObserveEval(EvalObserver observer) {
        return i -> {
            if (i instanceof Interpretable.EvalWatch || i instanceof Interpretable.EvalWatchAttr || i instanceof Interpretable.EvalWatchConst) {
                return i;
            }
            if (i instanceof Interpretable.InterpretableAttribute) {
                return new Interpretable.EvalWatchAttr((Interpretable.InterpretableAttribute)i, observer);
            }
            if (i instanceof Interpretable.InterpretableConst) {
                return new Interpretable.EvalWatchConst((Interpretable.InterpretableConst)i, observer);
            }
            return new Interpretable.EvalWatch(i, observer);
        };
    }

    public static InterpretableDecorator decDisableShortcircuits() {
        return i -> {
            Interpretable.InterpretableAttribute expr;
            if (i instanceof Interpretable.EvalOr) {
                Interpretable.EvalOr expr2 = (Interpretable.EvalOr)i;
                return new Interpretable.EvalExhaustiveOr(expr2.id, expr2.lhs, expr2.rhs);
            }
            if (i instanceof Interpretable.EvalAnd) {
                Interpretable.EvalAnd expr3 = (Interpretable.EvalAnd)i;
                return new Interpretable.EvalExhaustiveAnd(expr3.id, expr3.lhs, expr3.rhs);
            }
            if (i instanceof Interpretable.EvalFold) {
                Interpretable.EvalFold expr4 = (Interpretable.EvalFold)i;
                return new Interpretable.EvalExhaustiveFold(expr4.id, expr4.accu, expr4.accuVar, expr4.iterRange, expr4.iterVar, expr4.cond, expr4.step, expr4.result);
            }
            if (i instanceof Interpretable.InterpretableAttribute && (expr = (Interpretable.InterpretableAttribute)i).attr() instanceof AttributeFactory.ConditionalAttribute) {
                return new Interpretable.EvalExhaustiveConditional(i.id(), expr.adapter(), (AttributeFactory.ConditionalAttribute)expr.attr());
            }
            return i;
        };
    }

    public static InterpretableDecorator decOptimize() {
        return i -> {
            if (i instanceof Interpretable.EvalList) {
                return InterpretableDecorator.maybeBuildListLiteral(i, (Interpretable.EvalList)i);
            }
            if (i instanceof Interpretable.EvalMap) {
                return InterpretableDecorator.maybeBuildMapLiteral(i, (Interpretable.EvalMap)i);
            }
            if (i instanceof Interpretable.InterpretableCall) {
                Interpretable.InterpretableCall inst = (Interpretable.InterpretableCall)i;
                if (inst.overloadID().equals("in_list")) {
                    return InterpretableDecorator.maybeOptimizeSetMembership(i, inst);
                }
                if (Overloads.isTypeConversionFunction(inst.function())) {
                    return InterpretableDecorator.maybeOptimizeConstUnary(i, inst);
                }
            }
            return i;
        };
    }

    public static Interpretable maybeOptimizeConstUnary(Interpretable i, Interpretable.InterpretableCall call) {
        Interpretable[] args = call.args();
        if (args.length != 1) {
            return i;
        }
        if (!(args[0] instanceof Interpretable.InterpretableConst)) {
            return i;
        }
        Val val = call.eval(Activation.emptyActivation());
        Err.throwErrorAsIllegalStateException(val);
        return Interpretable.newConstValue(call.id(), val);
    }

    public static Interpretable maybeBuildListLiteral(Interpretable i, Interpretable.EvalList l) {
        for (Interpretable elem : l.elems) {
            if (elem instanceof Interpretable.InterpretableConst) continue;
            return i;
        }
        return Interpretable.newConstValue(l.id(), l.eval(Activation.emptyActivation()));
    }

    public static Interpretable maybeBuildMapLiteral(Interpretable i, Interpretable.EvalMap mp) {
        for (int idx = 0; idx < mp.keys.length; ++idx) {
            if (!(mp.keys[idx] instanceof Interpretable.InterpretableConst)) {
                return i;
            }
            if (mp.vals[idx] instanceof Interpretable.InterpretableConst) continue;
            return i;
        }
        return Interpretable.newConstValue(mp.id(), mp.eval(Activation.emptyActivation()));
    }

    public static Interpretable maybeOptimizeSetMembership(Interpretable i, Interpretable.InterpretableCall inlist) {
        Interpretable[] args = inlist.args();
        Interpretable lhs = args[0];
        Interpretable rhs = args[1];
        if (!(rhs instanceof Interpretable.InterpretableConst)) {
            return i;
        }
        Interpretable.InterpretableConst l = (Interpretable.InterpretableConst)rhs;
        Lister list = (Lister)l.value();
        if (list.size() == IntT.IntZero) {
            return Interpretable.newConstValue(inlist.id(), BoolT.False);
        }
        IteratorT it = list.iterator();
        Type typ = null;
        HashSet<Val> valueSet = new HashSet<Val>();
        while (it.hasNext() == BoolT.True) {
            Val elem = it.next();
            if (!Util.isPrimitiveType(elem)) {
                return i;
            }
            if (typ == null) {
                typ = elem.type();
            } else if (!typ.typeName().equals(elem.type().typeName())) {
                return i;
            }
            valueSet.add(elem);
        }
        return new Interpretable.EvalSetMembership(inlist, lhs, typ.typeName(), valueSet);
    }

    @FunctionalInterface
    public static interface EvalObserver {
        public void observe(long var1, Val var3);
    }
}

