/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.interpreter;

import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.Overload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface Dispatcher {
    public void add(Overload ... var1);

    public Overload findOverload(String var1);

    public String[] overloadIds();

    public static Dispatcher newDispatcher() {
        return new DefaultDispatcher(null, new HashMap<String, Overload>());
    }

    public static Dispatcher extendDispatcher(Dispatcher parent) {
        return new DefaultDispatcher(parent, new HashMap<String, Overload>());
    }

    public static final class DefaultDispatcher
    implements Dispatcher {
        private final Dispatcher parent;
        private final Map<String, Overload> overloads;

        DefaultDispatcher(Dispatcher parent, Map<String, Overload> overloads) {
            this.parent = parent;
            this.overloads = overloads;
        }

        @Override
        public void add(Overload ... overloads) {
            for (Overload o : overloads) {
                if (this.overloads.containsKey(o.operator)) {
                    throw new IllegalArgumentException(String.format("overload already exists '%s'", o.operator));
                }
                this.overloads.put(o.operator, o);
            }
        }

        @Override
        public Overload findOverload(String overload) {
            Overload o = this.overloads.get(overload);
            if (o != null) {
                return o;
            }
            return this.parent != null ? this.parent.findOverload(overload) : null;
        }

        @Override
        public String[] overloadIds() {
            ArrayList<String> r = new ArrayList<String>(this.overloads.keySet());
            if (this.parent != null) {
                Collections.addAll(r, this.parent.overloadIds());
            }
            return r.toArray(new String[0]);
        }
    }
}

