/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.interpreter;

import java.util.Objects;

public interface Coster {
    public Cost cost();

    public static Cost costOf(long min, long max) {
        return new Cost(min, max);
    }

    public static final class Cost {
        public static final Cost Unknown = Coster.costOf(0L, Long.MAX_VALUE);
        public static final Cost None = Coster.costOf(0L, 0L);
        public static final Cost OneOne = Coster.costOf(1L, 1L);
        public final long min;
        public final long max;

        private Cost(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public static Cost estimateCost(Object i) {
            if (i instanceof Coster) {
                return ((Coster)i).cost();
            }
            return Unknown;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cost cost = (Cost)o;
            return this.min == cost.min && this.max == cost.max;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }

        public String toString() {
            return "Cost{min=" + this.min + ", max=" + this.max + '}';
        }

        public Cost add(Cost c) {
            return new Cost(this.min + c.min, this.max + c.max);
        }

        public Cost multiply(long multiplier) {
            return new Cost(this.min * multiplier, this.max * multiplier);
        }
    }
}

