/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.extension;

import io.cryostat.agent.shaded.org.projectnessie.cel.EnvOption;
import io.cryostat.agent.shaded.org.projectnessie.cel.Library;
import io.cryostat.agent.shaded.org.projectnessie.cel.ProgramOption;
import io.cryostat.agent.shaded.org.projectnessie.cel.checker.Decls;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.extension.Guards;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.Overload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class StringsLib
implements Library {
    private static final String CHAR_AT = "charAt";
    private static final String INDEX_OF = "indexOf";
    private static final String JOIN = "join";
    private static final String LAST_INDEX_OF = "lastIndexOf";
    private static final String LOWER_ASCII = "lowerAscii";
    private static final String REPLACE = "replace";
    private static final String SPLIT = "split";
    private static final String SUBSTR = "substring";
    private static final String TRIM_SPACE = "trim";
    private static final String UPPER_ASCII = "upperAscii";
    private static final Set<Character> UNICODE_WHITE_SPACES = new HashSet<Character>(Arrays.asList(Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\u000b'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('\u0085'), Character.valueOf('\u00a0'), Character.valueOf('\u1680'), Character.valueOf('\u2000'), Character.valueOf('\u2001'), Character.valueOf('\u2002'), Character.valueOf('\u2003'), Character.valueOf('\u2004'), Character.valueOf('\u2005'), Character.valueOf('\u2006'), Character.valueOf('\u2007'), Character.valueOf('\u2008'), Character.valueOf('\u2009'), Character.valueOf('\u200a'), Character.valueOf('\u2028'), Character.valueOf('\u2029'), Character.valueOf('\u202f'), Character.valueOf('\u205f'), Character.valueOf('\u3000')));

    public static EnvOption strings() {
        return Library.Lib(new StringsLib());
    }

    @Override
    public List<EnvOption> getCompileOptions() {
        ArrayList<EnvOption> list = new ArrayList<EnvOption>();
        EnvOption option = EnvOption.declarations(Decls.newFunction(CHAR_AT, Decls.newInstanceOverload("string_char_at_int", Arrays.asList(Decls.String, Decls.Int), Decls.String)), Decls.newFunction(INDEX_OF, Decls.newInstanceOverload("string_index_of_string", Arrays.asList(Decls.String, Decls.String), Decls.Int), Decls.newInstanceOverload("string_index_of_string_int", Arrays.asList(Decls.String, Decls.String, Decls.Int), Decls.Int)), Decls.newFunction(JOIN, Decls.newInstanceOverload("list_join", Arrays.asList(Decls.newListType(Decls.String)), Decls.String), Decls.newInstanceOverload("list_join_string", Arrays.asList(Decls.newListType(Decls.String), Decls.String), Decls.String)), Decls.newFunction(LAST_INDEX_OF, Decls.newInstanceOverload("string_last_index_of_string", Arrays.asList(Decls.String, Decls.String), Decls.Int), Decls.newInstanceOverload("string_last_index_of_string_int", Arrays.asList(Decls.String, Decls.String, Decls.Int), Decls.Int)), Decls.newFunction(LOWER_ASCII, Decls.newInstanceOverload("string_lower_ascii", Arrays.asList(Decls.String), Decls.String)), Decls.newFunction(REPLACE, Decls.newInstanceOverload("string_replace_string_string", Arrays.asList(Decls.String, Decls.String, Decls.String), Decls.String), Decls.newInstanceOverload("string_replace_string_string_int", Arrays.asList(Decls.String, Decls.String, Decls.String, Decls.Int), Decls.String)), Decls.newFunction(SPLIT, Decls.newInstanceOverload("string_split_string", Arrays.asList(Decls.String, Decls.String), Decls.Dyn), Decls.newInstanceOverload("string_split_string_int", Arrays.asList(Decls.String, Decls.String, Decls.Int), Decls.Dyn)), Decls.newFunction(SUBSTR, Decls.newInstanceOverload("string_substring_int", Arrays.asList(Decls.String, Decls.Int), Decls.String), Decls.newInstanceOverload("string_substring_int_int", Arrays.asList(Decls.String, Decls.Int, Decls.Int), Decls.String)), Decls.newFunction(TRIM_SPACE, Decls.newInstanceOverload("string_trim", Arrays.asList(Decls.String), Decls.String)), Decls.newFunction(UPPER_ASCII, Decls.newInstanceOverload("string_upper_ascii", Arrays.asList(Decls.String), Decls.String)));
        list.add(option);
        return list;
    }

    @Override
    public List<ProgramOption> getProgramOptions() {
        ArrayList<ProgramOption> list = new ArrayList<ProgramOption>();
        ProgramOption functions = ProgramOption.functions(Overload.binary(CHAR_AT, Guards.callInStrIntOutStr(StringsLib::charAt)), Overload.overload(INDEX_OF, null, null, Guards.callInStrStrOutInt(StringsLib::indexOf), Guards.callInStrStrIntOutInt(StringsLib::indexOfOffset)), Overload.overload(JOIN, null, Guards.callInStrArrayOutStr(StringsLib::join), Guards.callInStrArrayStrOutStr(StringsLib::joinSepartor), null), Overload.overload(LAST_INDEX_OF, null, null, Guards.callInStrStrOutInt(StringsLib::lastIndexOf), Guards.callInStrStrIntOutInt(StringsLib::lastIndexOfOffset)), Overload.unary(LOWER_ASCII, Guards.callInStrOutStr(StringsLib::lowerASCII)), Overload.overload(REPLACE, null, null, null, values -> {
            if (values.length == 3) {
                return Guards.callInStrStrStrOutStr(StringsLib::replace).invoke(values);
            }
            if (values.length == 4) {
                return Guards.callInStrStrStrIntOutStr(StringsLib::replaceN).invoke(values);
            }
            return Err.maybeNoSuchOverloadErr(null);
        }), Overload.overload(SPLIT, null, null, Guards.callInStrStrOutStrArr(StringsLib::split), Guards.callInStrStrIntOutStrArr(StringsLib::splitN)), Overload.overload(SUBSTR, null, null, Guards.callInStrIntOutStr(StringsLib::substr), Guards.callInStrIntIntOutStr(StringsLib::substrRange)), Overload.unary(TRIM_SPACE, Guards.callInStrOutStr(StringsLib::trimSpace)), Overload.unary(UPPER_ASCII, Guards.callInStrOutStr(StringsLib::upperASCII)));
        list.add(functions);
        return list;
    }

    static String charAt(String str, int index) {
        if (str.length() == index) {
            return "";
        }
        return String.valueOf(str.charAt(index));
    }

    static int indexOf(String str, String substr) {
        return str.indexOf(substr);
    }

    static int indexOfOffset(String str, String substr, int offset) {
        if (offset < 0 || offset > str.length()) {
            throw new IndexOutOfBoundsException("String index out of range: " + offset);
        }
        return str.indexOf(substr, offset);
    }

    static String join(String[] strs) {
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(strs).forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    static String joinSepartor(String[] strs, String seperator) {
        return String.join((CharSequence)seperator, strs);
    }

    static int lastIndexOf(String str, String substr) {
        return str.lastIndexOf(substr);
    }

    static int lastIndexOfOffset(String str, String substr, int offset) {
        if (offset < 0 || offset > str.length()) {
            throw new IndexOutOfBoundsException("String index out of range: " + offset);
        }
        return str.lastIndexOf(substr, offset);
    }

    static String lowerASCII(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String replace(String str, String old, String replacement) {
        return str.replace(old, replacement);
    }

    static String replaceN(String str, String old, String replacement, int n) {
        if (n == 0 || old.equals(replacement)) {
            return str;
        }
        if (n < 0) {
            return str.replace(old, replacement);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        for (int count = 0; count < n && index < str.length(); ++count) {
            if (old.length() == 0) {
                stringBuilder.append(replacement).append(str, index, index + 1);
                ++index;
                continue;
            }
            int found = str.indexOf(old, index);
            if (found == -1) {
                stringBuilder.append(str, index, str.length());
                return stringBuilder.toString();
            }
            if (found > index) {
                stringBuilder.append(str, index, found);
            }
            stringBuilder.append(replacement);
            index = found + old.length();
        }
        if (index < str.length()) {
            stringBuilder.append(str, index, str.length());
        }
        return stringBuilder.toString();
    }

    static String[] split(String str, String separator) {
        return str.split(Pattern.quote(separator));
    }

    static String[] splitN(String s, String sep, int n) {
        int found;
        if (n < 0) {
            return StringsLib.split(s, sep);
        }
        if (n == 0) {
            return new String[0];
        }
        if (n == 1) {
            return new String[]{s};
        }
        if (sep.length() == 0) {
            return StringsLib.explode(s, n);
        }
        int index = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (int count = 0; index < s.length() && count < n - 1 && (found = s.indexOf(sep, index)) >= 0; ++count) {
            list.add(s.substring(index, found));
            index = found + sep.length();
        }
        if (index <= s.length()) {
            list.add(s.substring(index));
        }
        return list.toArray(new String[0]);
    }

    private static String[] explode(String s, int n) {
        if (n < 0 || n > s.length()) {
            n = s.length();
        }
        String[] arr = new String[n];
        for (int i = 0; i < n - 1; ++i) {
            arr[i] = s.substring(i, i + 1);
        }
        if (n > 0) {
            arr[n - 1] = s.substring(n - 1);
        }
        return arr;
    }

    static String substr(String str, int start) {
        return str.substring(start);
    }

    static String substrRange(String str, int start, int end) {
        if (start < 0 || start > str.length()) {
            throw new IndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || end > str.length()) {
            throw new IndexOutOfBoundsException("String index out of range: " + end);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException(String.format("invalid substring range. start: %d, end: %d", start, end));
        }
        return str.substring(start, end);
    }

    static String trimSpace(String str) {
        int start;
        char[] chars = str.toCharArray();
        int end = str.length() - 1;
        for (start = 0; start < str.length() && StringsLib.isWhiteSpace(chars[start]); ++start) {
        }
        while (end > start && StringsLib.isWhiteSpace(chars[end])) {
            --end;
        }
        return str.substring(start, end + 1);
    }

    private static boolean isWhiteSpace(char ch) {
        return UNICODE_WHITE_SPACES.contains(Character.valueOf(ch));
    }

    static String upperASCII(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c >= 'a' && c <= 'z') {
                stringBuilder.append(Character.toUpperCase(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

