/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.extension;

import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Err;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IntT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ListT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.StringT;
import io.cryostat.agent.shaded.org.projectnessie.cel.extension.QuadFunction;
import io.cryostat.agent.shaded.org.projectnessie.cel.extension.TriFunction;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.BinaryOp;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.FunctionOp;
import io.cryostat.agent.shaded.org.projectnessie.cel.interpreter.functions.UnaryOp;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class Guards {
    private Guards() {
    }

    public static BinaryOp callInStrIntOutStr(BiFunction<String, Integer, String> func) {
        return (lhs, rhs) -> {
            try {
                return StringT.stringOf((String)func.apply((String)lhs.value(), Guards.getIntValue((IntT)rhs)));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrIntIntOutStr(TriFunction<String, Integer, Integer, String> func) {
        return values -> {
            try {
                return StringT.stringOf((String)func.apply((String)values[0].value(), Guards.getIntValue((IntT)values[1]), Guards.getIntValue((IntT)values[2])));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static BinaryOp callInStrStrOutInt(BiFunction<String, String, Integer> func) {
        return (lhs, rhs) -> {
            try {
                return IntT.intOf(((Integer)func.apply((String)lhs.value(), (String)rhs.value())).intValue());
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrIntOutInt(TriFunction<String, String, Integer, Integer> func) {
        return values -> {
            try {
                return IntT.intOf(((Integer)func.apply((String)values[0].value(), (String)values[1].value(), Guards.getIntValue((IntT)values[2]))).intValue());
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static BinaryOp callInStrStrOutStrArr(BiFunction<String, String, String[]> func) {
        return (lhs, rhs) -> {
            try {
                return ListT.newStringArrayList((String[])func.apply((String)lhs.value(), (String)rhs.value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrIntOutStrArr(TriFunction<String, String, Integer, String[]> func) {
        return values -> {
            try {
                return ListT.newStringArrayList((String[])func.apply((String)values[0].value(), (String)values[1].value(), Guards.getIntValue((IntT)values[2])));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrStrOutStr(TriFunction<String, String, String, String> func) {
        return values -> {
            try {
                return StringT.stringOf((String)func.apply((String)values[0].value(), (String)values[1].value(), (String)values[2].value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrStrIntOutStr(QuadFunction<String, String, String, Integer, String> func) {
        return values -> {
            try {
                return StringT.stringOf((String)func.apply((String)values[0].value(), (String)values[1].value(), (String)values[2].value(), Guards.getIntValue((IntT)values[3])));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static UnaryOp callInStrOutStr(UnaryOperator<String> func) {
        return val -> {
            try {
                return StringT.stringOf((String)func.apply((String)val.value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static UnaryOp callInStrArrayOutStr(Function<String[], String> func) {
        return val -> {
            try {
                Object[] objects = (Object[])val.value();
                return StringT.stringOf((String)func.apply((String[])Arrays.copyOf(objects, objects.length, String[].class)));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static BinaryOp callInStrArrayStrOutStr(BiFunction<String[], String, String> func) {
        return (lhs, rhs) -> {
            try {
                Object[] objects = (Object[])lhs.value();
                return StringT.stringOf((String)func.apply((String[])Arrays.copyOf(objects, objects.length, String[].class), (String)rhs.value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    private static int getIntValue(IntT value) {
        Long longValue = (Long)value.value();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw new RuntimeException(String.format("Integer %d value overflow", longValue));
        }
        return longValue.intValue();
    }
}

