/*
 * Decompiled with CFR 0.152.
 */
package io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.EnumValue;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.ULong;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.BytesT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.DoubleT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.DurationT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.IntT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ListT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.MapT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.NullT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.StringT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.TimestampT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.Types;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.UintT;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.pb.DefaultTypeAdapter;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.TypeAdapter;
import io.cryostat.agent.shaded.org.projectnessie.cel.common.types.ref.Val;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public final class TypeAdapterSupport {
    private static final Map<Class<?>, BiFunction<TypeAdapter, Object, Val>> NativeToValueExact = new IdentityHashMap();

    private TypeAdapterSupport() {
    }

    public static Val maybeNativeToValue(TypeAdapter a, Object value) {
        if (value == null) {
            return NullT.NullValue;
        }
        BiFunction<TypeAdapter, Object, Val> conv = NativeToValueExact.get(value.getClass());
        if (conv != null) {
            return conv.apply(a, value);
        }
        if (value instanceof Object[]) {
            return ListT.newGenericArrayList(a, (Object[])value);
        }
        if (value instanceof List) {
            return ListT.newGenericArrayList(a, ((List)value).toArray());
        }
        if (value instanceof Map) {
            return MapT.newMaybeWrappedMap(a, (Map)value);
        }
        if (value instanceof ByteString) {
            return BytesT.bytesOf((ByteString)value);
        }
        if (value instanceof Instant) {
            return TimestampT.timestampOf(((Instant)value).atZone(TimestampT.ZoneIdZ));
        }
        if (value instanceof ZonedDateTime) {
            return TimestampT.timestampOf((ZonedDateTime)value);
        }
        if (value instanceof Date) {
            return TimestampT.timestampOf(((Date)value).toInstant().atZone(TimestampT.ZoneIdZ));
        }
        if (value instanceof Calendar) {
            return TimestampT.timestampOf(((Calendar)value).toInstant().atZone(TimestampT.ZoneIdZ));
        }
        return null;
    }

    static {
        NativeToValueExact.put(Boolean.class, (a, value) -> Types.boolOf((Boolean)value));
        NativeToValueExact.put(byte[].class, (a, value) -> BytesT.bytesOf((byte[])value));
        NativeToValueExact.put(Float.class, (a, value) -> DoubleT.doubleOf(((Float)value).doubleValue()));
        NativeToValueExact.put(Double.class, (a, value) -> DoubleT.doubleOf((Double)value));
        NativeToValueExact.put(Byte.class, (a, value) -> IntT.intOf(((Byte)value).byteValue()));
        NativeToValueExact.put(Short.class, (a, value) -> IntT.intOf(((Short)value).shortValue()));
        NativeToValueExact.put(Integer.class, (a, value) -> IntT.intOf(((Integer)value).intValue()));
        NativeToValueExact.put(ULong.class, (a, value) -> UintT.uintOf(((ULong)value).longValue()));
        NativeToValueExact.put(Long.class, (a, value) -> IntT.intOf((Long)value));
        NativeToValueExact.put(String.class, (a, value) -> StringT.stringOf((String)value));
        NativeToValueExact.put(java.time.Duration.class, (a, value) -> DurationT.durationOf((java.time.Duration)value));
        NativeToValueExact.put(Duration.class, (a, value) -> DurationT.durationOf((Duration)value));
        NativeToValueExact.put(Timestamp.class, (a, value) -> TimestampT.timestampOf((Timestamp)value));
        NativeToValueExact.put(ZonedDateTime.class, (a, value) -> TimestampT.timestampOf((ZonedDateTime)value));
        NativeToValueExact.put(Instant.class, (a, value) -> TimestampT.timestampOf((Instant)value));
        NativeToValueExact.put(int[].class, (a, value) -> ListT.newValArrayList(DefaultTypeAdapter.Instance, (Val[])Arrays.stream((int[])value).mapToObj(IntT::intOf).toArray(Val[]::new)));
        NativeToValueExact.put(long[].class, (a, value) -> ListT.newValArrayList(DefaultTypeAdapter.Instance, (Val[])Arrays.stream((long[])value).mapToObj(IntT::intOf).toArray(Val[]::new)));
        NativeToValueExact.put(double[].class, (a, value) -> ListT.newValArrayList(DefaultTypeAdapter.Instance, (Val[])Arrays.stream((double[])value).mapToObj(DoubleT::doubleOf).toArray(Val[]::new)));
        NativeToValueExact.put(String[].class, (a, value) -> ListT.newStringArrayList((String[])value));
        NativeToValueExact.put(Val[].class, (a, value) -> ListT.newValArrayList(a, (Val[])value));
        NativeToValueExact.put(NullValue.class, (a, value) -> NullT.NullValue);
        NativeToValueExact.put(ListValue.class, (a, value) -> ListT.newJSONList(a, (ListValue)value));
        NativeToValueExact.put(UInt32Value.class, (a, value) -> UintT.uintOf(((UInt32Value)value).getValue()));
        NativeToValueExact.put(UInt64Value.class, (a, value) -> UintT.uintOf(((UInt64Value)value).getValue()));
        NativeToValueExact.put(Struct.class, (a, value) -> MapT.newJSONStruct(a, (Struct)value));
        NativeToValueExact.put(EnumValue.class, (a, value) -> IntT.intOf(((EnumValue)value).getNumber()));
        NativeToValueExact.put(Descriptors.EnumValueDescriptor.class, (a, value) -> {
            Descriptors.EnumValueDescriptor e = (Descriptors.EnumValueDescriptor)value;
            return IntT.intOf(e.getNumber());
        });
    }
}

